/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.utilities.ContextLocaliser;
import io.intercom.android.sdk.utilities.TimeFormatter;

public class PartMetadataFormatter {
    private final String sendingText;
    private final String deliveredText;
    private final String failedText;
    private final String seenText;
    private final String unseenText;
    private final TimeFormatter timeFormatter;

    public static PartMetadataFormatter create(Context context) {
        String sendingText = context.getString(R.string.intercom_sending);
        String deliveredText = context.getString(R.string.intercom_delivered);
        String seenText = context.getString(R.string.intercom_message_seen);
        String unseenText = context.getString(R.string.intercom_message_unseen);
        String failedText = context.getString(R.string.intercom_message_failed_try_again);
        Context localisedContext = ContextLocaliser.create().createLocalisedContext(context);
        TimeFormatter timeFormatter = new TimeFormatter(localisedContext, Injector.get().getTimeProvider());
        return new PartMetadataFormatter(timeFormatter, sendingText, deliveredText, failedText, seenText, unseenText);
    }

    PartMetadataFormatter(TimeFormatter timeFormatter, String sendingText, String deliveredText, String failedText, String seenText, String unseenText) {
        this.timeFormatter = timeFormatter;
        this.sendingText = sendingText;
        this.deliveredText = deliveredText;
        this.failedText = failedText;
        this.seenText = seenText;
        this.unseenText = unseenText;
    }

    @Nullable
    public String getMetadataString(int type, Part conversationPart, boolean isLastItem) {
        switch (conversationPart.getMessageState()) {
            case SENDING: {
                return this.sendingText;
            }
            case FAILED: 
            case UPLOAD_FAILED: {
                return this.failedText;
            }
        }
        if (type == 2 || type == 3) {
            return null;
        }
        if (isLastItem) {
            return this.formatLastPart(conversationPart);
        }
        return this.formatPart(conversationPart);
    }

    @NonNull
    String formatLastPart(Part conversationPart) {
        StringBuilder sb = new StringBuilder();
        if (conversationPart.isDisplayDelivered()) {
            sb.append(this.deliveredText);
        } else {
            sb.append(this.timeFormatter.getFormattedTime(conversationPart.getCreatedAt()));
        }
        if ("seen".equalsIgnoreCase(conversationPart.getSeenByAdmin())) {
            sb.append(". ").append(this.seenText);
        } else if ("unseen".equalsIgnoreCase(conversationPart.getSeenByAdmin())) {
            sb.append(". ").append(this.unseenText);
        }
        return sb.toString();
    }

    @NonNull
    String formatPart(Part conversationPart) {
        if (conversationPart.isDisplayDelivered()) {
            return "";
        }
        return TimeFormatter.getAbsoluteTime(conversationPart.getCreatedAt());
    }
}

