/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.profile;

import android.content.Context;
import android.support.design.widget.AppBarLayout;
import android.support.v4.view.ViewCompat;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.profile.ProfileToolbarBehavior;

class TeamProfileToolbarBehavior
extends ProfileToolbarBehavior {
    private static final float CHANGE_IN_SCALE = 0.3f;
    private final ViewGroup rootLayout;
    private LinearLayout teamProfiles;
    private ImageView avatarMini1;
    private ImageView avatarMini2;
    private ImageView avatarMini3;
    private TextView bio;
    private float translate16dp;

    public TeamProfileToolbarBehavior(ViewGroup rootLayout) {
        super(rootLayout.getContext());
        this.rootLayout = rootLayout;
        this.translate16dp = ScreenUtils.convertDpToPixel((float)16.0f, (Context)rootLayout.getContext());
    }

    private void updateCollapsedAvatars(ViewGroup child, float scrollPercentage) {
        if (this.avatarMini1 == null) {
            this.avatarMini1 = (ImageView)child.findViewById(R.id.intercom_collapsing_team_avatar1);
        }
        if (this.avatarMini2 == null) {
            this.avatarMini2 = (ImageView)child.findViewById(R.id.intercom_collapsing_team_avatar2);
        }
        if (this.avatarMini3 == null) {
            this.avatarMini3 = (ImageView)child.findViewById(R.id.intercom_collapsing_team_avatar3);
        }
        float scale = 0.7f + 0.003f * scrollPercentage;
        ViewCompat.setScaleX((View)this.avatarMini1, (float)scale);
        ViewCompat.setScaleX((View)this.avatarMini2, (float)scale);
        ViewCompat.setScaleX((View)this.avatarMini3, (float)scale);
        ViewCompat.setScaleY((View)this.avatarMini1, (float)scale);
        ViewCompat.setScaleY((View)this.avatarMini2, (float)scale);
        ViewCompat.setScaleY((View)this.avatarMini3, (float)scale);
    }

    private void updateTeamProfile(ViewGroup child, View dependency, float scrollPercentage) {
        if (this.teamProfiles == null) {
            this.teamProfiles = (LinearLayout)child.findViewById(R.id.intercom_team_profiles_layout);
        }
        this.setAlphaAsPercentageOfScroll((View)this.teamProfiles, dependency, 1.0f, false);
        float translationY = this.translate16dp / 100.0f * scrollPercentage;
        ViewCompat.setTranslationY((View)this.teamProfiles, (float)((int)Math.max(0.0f, translationY)));
    }

    private void updateCollapsedBio(ViewGroup child, View dependency, float scrollPercentage) {
        if (this.bio == null) {
            this.bio = (TextView)child.findViewById(R.id.intercom_collapsing_team_bio);
        }
        this.setAlphaAsPercentageOfScroll((View)this.bio, dependency, 0.7f, false);
        float translationY = this.translate16dp / 100.0f * scrollPercentage;
        ViewCompat.setTranslationY((View)this.bio, (float)((int)Math.max(0.0f, translationY)));
    }

    public void onOffsetChanged(AppBarLayout appBarLayout, int verticalOffset) {
        if ((float)appBarLayout.getHeight() - this.toolbarHeight < 1.0f) {
            return;
        }
        float scrollPercentage = this.getScrollPercentage((View)appBarLayout);
        this.rootLayout.getLayoutParams().height = appBarLayout.getBottom();
        this.updateCollapsedAvatars(this.rootLayout, scrollPercentage);
        this.updateTeamProfile(this.rootLayout, (View)appBarLayout, scrollPercentage);
        this.updateCollapsedBio(this.rootLayout, (View)appBarLayout, scrollPercentage);
        this.rootLayout.requestLayout();
    }
}

