/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import io.intercom.android.sdk.logger.IntercomLogger;

class PushIntentHandler {
    private Uri lastPushData = Uri.EMPTY;
    private String lastPushOnlyId = "";

    PushIntentHandler() {
    }

    void updateLastStoredIntent(Intent intent) {
        if (this.notLaunchedFromHistory(intent) && this.isIntercomIntent(intent.getExtras())) {
            String uriPushOnlyId = intent.getStringExtra("push_only_convo_id");
            if (TextUtils.isEmpty((CharSequence)uriPushOnlyId)) {
                IntercomLogger.internal("The uri had no push only id");
            } else {
                this.lastPushOnlyId = uriPushOnlyId;
            }
            Uri data = intent.getData();
            if (data == null) {
                IntercomLogger.internal("The uri had no push data");
            } else {
                this.lastPushData = data;
            }
        }
    }

    private boolean isIntercomIntent(Bundle intentExtras) {
        return intentExtras != null && intentExtras.containsKey("intercom_push_key");
    }

    private boolean notLaunchedFromHistory(Intent intent) {
        return intent != null && (intent.getFlags() & 0x100000) == 0;
    }

    void clear() {
        this.lastPushData = Uri.EMPTY;
        this.lastPushOnlyId = "";
    }

    @NonNull
    Uri getLastPushData() {
        return this.lastPushData;
    }

    @NonNull
    String getLastPushOnlyId() {
        return this.lastPushOnlyId;
    }

    boolean isEmpty() {
        return this.lastPushData == Uri.EMPTY && this.lastPushOnlyId.isEmpty();
    }

    boolean hasPushOnlyId() {
        return !TextUtils.isEmpty((CharSequence)this.lastPushOnlyId);
    }
}

