/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models.carousel;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import io.intercom.android.sdk.blocks.lib.models.Block;
import io.intercom.android.sdk.models.carousel.AutoValue_CarouselScreen;
import io.intercom.android.sdk.models.carousel.ScreenAction;
import io.intercom.android.sdk.utilities.NullSafety;
import io.intercom.android.sdk.utilities.commons.CollectionUtils;
import java.util.ArrayList;
import java.util.List;

@AutoValue
public abstract class CarouselScreen
implements Parcelable {
    public static CarouselScreen NULL = new Builder().build();
    public static final Parcelable.Creator<CarouselScreen> CREATOR = new Parcelable.Creator<CarouselScreen>(){

        public CarouselScreen createFromParcel(Parcel in) {
            ArrayList<Block> blocks2 = new ArrayList<Block>();
            in.readList(blocks2, ScreenAction.class.getClassLoader());
            ArrayList<ScreenAction> screenActions = new ArrayList<ScreenAction>();
            in.readList(screenActions, ScreenAction.class.getClassLoader());
            return CarouselScreen.create(in.readString(), in.readString(), in.readString(), blocks2, screenActions, in.readString());
        }

        public CarouselScreen[] newArray(int size) {
            return new CarouselScreen[size];
        }
    };

    public static CarouselScreen create(String id2, String backgroundColor, String textColor, List<Block> blocks2, List<ScreenAction> actions, String alignment) {
        return new AutoValue_CarouselScreen(id2, backgroundColor, textColor, blocks2, actions, alignment);
    }

    public abstract String getId();

    public abstract String getBackgroundColor();

    public abstract String getTextColor();

    public abstract List<Block> getBlocks();

    public abstract List<ScreenAction> getActions();

    public abstract String getVerticalAlignment();

    public int getGravity() {
        if ("bottom".equals(this.getVerticalAlignment())) {
            return 80;
        }
        if ("center".equals(this.getVerticalAlignment())) {
            return 16;
        }
        return 48;
    }

    public ScreenAction getPermissionAction() {
        for (ScreenAction screenAction : this.getActions()) {
            if (!screenAction.isPermissionAction()) continue;
            return screenAction;
        }
        return ScreenAction.NULL;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeList(this.getBlocks());
        dest.writeList(this.getActions());
        dest.writeString(this.getId());
        dest.writeString(this.getBackgroundColor());
        dest.writeString(this.getTextColor());
        dest.writeString(this.getVerticalAlignment());
    }

    public static final class Builder {
        @Nullable
        String id;
        @Nullable
        String background_color;
        @Nullable
        String text_color;
        @Nullable
        List<Block.Builder> blocks;
        @Nullable
        List<ScreenAction.Builder> actions;
        @Nullable
        String vertical_alignment;

        public Builder withId(String id2) {
            this.id = id2;
            return this;
        }

        public Builder withBackgroundColor(String color2) {
            this.background_color = color2;
            return this;
        }

        public Builder withTextColor(String color2) {
            this.text_color = color2;
            return this;
        }

        public Builder withBlocks(List<Block.Builder> blocks2) {
            this.blocks = blocks2;
            return this;
        }

        public Builder withActions(List<ScreenAction.Builder> actions) {
            this.actions = actions;
            return this;
        }

        public Builder withVerticalAlignment(String verticalAlignment) {
            this.vertical_alignment = verticalAlignment;
            return this;
        }

        public CarouselScreen build() {
            ArrayList<ScreenAction> actions = new ArrayList<ScreenAction>(CollectionUtils.capacityFor(this.actions));
            if (this.actions != null) {
                for (ScreenAction.Builder builder : this.actions) {
                    if (builder == null) continue;
                    actions.add(builder.build());
                }
            }
            ArrayList<Block> blocks2 = new ArrayList<Block>(CollectionUtils.capacityFor(this.blocks));
            if (this.blocks != null) {
                for (Block.Builder builder : this.blocks) {
                    if (builder == null) continue;
                    blocks2.add(builder.build());
                }
            }
            return CarouselScreen.create(NullSafety.valueOrEmpty(this.id), NullSafety.valueOrEmpty(this.background_color), NullSafety.valueOrEmpty(this.text_color), blocks2, actions, NullSafety.valueOrEmpty(this.vertical_alignment));
        }
    }
}

