/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.conversation.utils.audio;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import androidx.activity.compose.ActivityResultRegistryKt;
import androidx.activity.compose.LocalActivityKt;
import androidx.activity.compose.ManagedActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.ComposableTarget;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.CompositionLocal;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.platform.AndroidCompositionLocals_androidKt;
import androidx.compose.ui.res.StringResources_androidKt;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.m5.conversation.utils.audio.PermissionResult;
import io.intercom.android.sdk.ui.R;
import io.intercom.android.sdk.ui.component.PermissionDeniedDialogKt;
import io.intercom.android.sdk.utilities.Phrase;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a/\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0001\u00a2\u0006\u0002\u0010\u0005\u001a\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0000\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0012\u0010\u000e\u001a\u00020\r2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0000\u00a8\u0006\u000f\u00b2\u0006\n\u0010\u0010\u001a\u00020\rX\u008a\u008e\u0002"}, d2={"rememberAudioPermissionHandler", "Lkotlin/Function0;", "", "onPermissionGranted", "onPermissionDenied", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Landroidx/compose/runtime/Composer;I)Lkotlin/jvm/functions/Function0;", "checkAudioPermissionStatus", "Lio/intercom/android/sdk/m5/conversation/utils/audio/PermissionResult;", "context", "Landroid/content/Context;", "activity", "Landroid/app/Activity;", "hasRecordAudioPermissionInManifest", "", "shouldShowRequestPermissionRationale", "intercom-sdk-base_release", "showSettingsDialog"})
@SourceDebugExtension(value={"SMAP\nAudioPermissionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioPermissionHandler.kt\nio/intercom/android/sdk/m5/conversation/utils/audio/AudioPermissionHandlerKt\n+ 2 CompositionLocal.kt\nandroidx/compose/runtime/CompositionLocal\n+ 3 Composer.kt\nandroidx/compose/runtime/ComposerKt\n+ 4 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n*L\n1#1,149:1\n75#2:150\n75#2:151\n1282#3,6:152\n1282#3,6:158\n1282#3,6:164\n1282#3,6:170\n85#4:176\n117#4,2:177\n*S KotlinDebug\n*F\n+ 1 AudioPermissionHandler.kt\nio/intercom/android/sdk/m5/conversation/utils/audio/AudioPermissionHandlerKt\n*L\n42#1:150\n43#1:151\n44#1:152,6\n48#1:158,6\n57#1:164,6\n89#1:170,6\n44#1:176\n44#1:177,2\n*E\n"})
public final class AudioPermissionHandlerKt {
    /*
     * WARNING - void declaration
     */
    @Composable
    @ComposableTarget(applier="androidx.compose.ui.UiComposable")
    @NotNull
    public static final Function0<Unit> rememberAudioPermissionHandler(@NotNull Function0<Unit> onPermissionGranted, @NotNull Function0<Unit> onPermissionDenied, @Nullable Composer $composer, int $changed) {
        Object object;
        void $this$cache$iv;
        Object object2;
        ActivityResultContract activityResultContract;
        void invalid$iv22;
        Function0 $this$cache$iv2;
        Object object3;
        Function1 $this$cache$iv3;
        void this_$iv;
        void this_$iv2;
        Intrinsics.checkNotNullParameter(onPermissionGranted, (String)"onPermissionGranted");
        Intrinsics.checkNotNullParameter(onPermissionDenied, (String)"onPermissionDenied");
        $composer.startReplaceGroup(2051621013);
        CompositionLocal compositionLocal = (CompositionLocal)AndroidCompositionLocals_androidKt.getLocalContext();
        boolean $changed$iv22 = false;
        boolean $i$f$getCurrent = false;
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)2023513938, (String)"CC(<get-current>):CompositionLocal.kt#9igjgp");
        Object object4 = $composer.consume((CompositionLocal)this_$iv2);
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        Context context = (Context)object4;
        CompositionLocal $changed$iv22 = (CompositionLocal)LocalActivityKt.getLocalActivity();
        boolean $changed$iv32 = false;
        boolean $i$f$getCurrent22 = false;
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)2023513938, (String)"CC(<get-current>):CompositionLocal.kt#9igjgp");
        Object object5 = $composer.consume((CompositionLocal)this_$iv);
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        Activity activity = (Activity)object5;
        $composer.startReplaceGroup(826575842);
        Composer $i$f$getCurrent22 = $composer;
        boolean bl = false;
        boolean $i$f$cache = false;
        Object it$iv = $this$cache$iv3.rememberedValue();
        boolean bl2 = false;
        if (it$iv == Composer.Companion.getEmpty()) {
            boolean bl3 = false;
            MutableState value$iv = SnapshotStateKt.mutableStateOf$default((Object)false, null, (int)2, null);
            $this$cache$iv3.updateRememberedValue((Object)value$iv);
            object3 = value$iv;
        } else {
            object3 = it$iv;
        }
        MutableState $changed$iv32 = (MutableState)object3;
        $composer.endReplaceGroup();
        MutableState showSettingsDialog$delegate = $changed$iv32;
        ActivityResultContract activityResultContract2 = (ActivityResultContract)new ActivityResultContracts.RequestPermission();
        $composer.startReplaceGroup(826581387);
        Composer invalid$iv = $composer;
        $i$f$cache = (($changed & 0xE ^ 6) > 4 && $composer.changed(onPermissionGranted) || ($changed & 6) == 4) | (($changed & 0x70 ^ 0x30) > 32 && $composer.changed(onPermissionDenied) || ($changed & 0x30) == 32);
        boolean $i$f$cache2 = false;
        Object it$iv2 = $this$cache$iv2.rememberedValue();
        $i$a$-let-ComposerKt$cache$1$iv = false;
        if (invalid$iv22 != false || it$iv2 == Composer.Companion.getEmpty()) {
            activityResultContract = activityResultContract2;
            boolean bl4 = false;
            activityResultContract2 = activityResultContract;
            Function1 value$iv = arg_0 -> AudioPermissionHandlerKt.rememberAudioPermissionHandler$lambda$4$lambda$3(onPermissionGranted, onPermissionDenied, arg_0);
            $this$cache$iv2.updateRememberedValue((Object)value$iv);
            object2 = value$iv;
        } else {
            object2 = it$iv2;
        }
        $this$cache$iv3 = (Function1)object2;
        $composer.endReplaceGroup();
        ManagedActivityResultLauncher permissionLauncher = ActivityResultRegistryKt.rememberLauncherForActivityResult((ActivityResultContract)activityResultContract2, (Function1)$this$cache$iv3, (Composer)$composer, (int)8);
        $composer.startReplaceGroup(826589549);
        Composer invalid$iv22 = $composer;
        $i$f$cache2 = false;
        boolean $i$f$cache32 = false;
        Object it$iv32 = $this$cache$iv.rememberedValue();
        $i$a$-let-ComposerKt$cache$1$iv = false;
        if (it$iv32 == Composer.Companion.getEmpty()) {
            boolean bl5 = false;
            Function0 value$iv = () -> AudioPermissionHandlerKt.rememberAudioPermissionHandler$lambda$6$lambda$5(context, activity, onPermissionGranted, permissionLauncher, showSettingsDialog$delegate);
            $this$cache$iv.updateRememberedValue((Object)value$iv);
            object = value$iv;
        } else {
            object = it$iv32;
        }
        $this$cache$iv2 = (Function0)object;
        $composer.endReplaceGroup();
        Function0 checkPermission = $this$cache$iv2;
        if (AudioPermissionHandlerKt.rememberAudioPermissionHandler$lambda$1((MutableState<Boolean>)showSettingsDialog$delegate)) {
            Object object6;
            void invalid$iv3;
            void $this$cache$iv4;
            String appName = ((Object)context.getApplicationInfo().loadLabel(context.getPackageManager())).toString();
            String message = ((Object)Phrase.from(context, R.string.intercom_need_microphone_access).put("app_name", appName).format()).toString();
            ActivityResultContract activityResultContract3 = null;
            String string2 = message;
            String string3 = StringResources_androidKt.stringResource((int)R.string.intercom_settings, (Composer)$composer, (int)0);
            String string4 = StringResources_androidKt.stringResource((int)R.string.intercom_not_now, (Composer)$composer, (int)0);
            Integer n = R.drawable.intercom_ic_microphone;
            $composer.startReplaceGroup(826629471);
            Composer $i$f$cache32 = $composer;
            boolean it$iv32 = ($changed & 0x70 ^ 0x30) > 32 && $composer.changed(onPermissionDenied) || ($changed & 0x30) == 32;
            boolean $i$f$cache4 = false;
            Object it$iv4 = $this$cache$iv4.rememberedValue();
            $i$a$-let-ComposerKt$cache$1$iv = false;
            if (invalid$iv3 != false || it$iv4 == Composer.Companion.getEmpty()) {
                Integer n2 = n;
                String string5 = string4;
                String string6 = string3;
                String string7 = string2;
                activityResultContract = activityResultContract3;
                boolean bl6 = false;
                Function0 function0 = () -> AudioPermissionHandlerKt.rememberAudioPermissionHandler$lambda$8$lambda$7(onPermissionDenied, showSettingsDialog$delegate);
                activityResultContract3 = activityResultContract;
                string2 = string7;
                string3 = string6;
                string4 = string5;
                n = n2;
                Function0 value$iv = function0;
                $this$cache$iv4.updateRememberedValue((Object)value$iv);
                object6 = value$iv;
            } else {
                object6 = it$iv4;
            }
            Function0 function0 = (Function0)object6;
            $composer.endReplaceGroup();
            PermissionDeniedDialogKt.PermissionDeniedDialog((Modifier)activityResultContract3, (String)string2, (String)string3, (String)string4, (Integer)n, (Function0)function0, () -> AudioPermissionHandlerKt.rememberAudioPermissionHandler$lambda$9(context, showSettingsDialog$delegate), (Composer)$composer, (int)0, (int)1);
        }
        $composer.endReplaceGroup();
        return checkPermission;
    }

    @NotNull
    public static final PermissionResult checkAudioPermissionStatus(@NotNull Context context, @Nullable Activity activity) {
        PermissionResult permissionResult;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!AudioPermissionHandlerKt.hasRecordAudioPermissionInManifest(context)) {
            return PermissionResult.NotRequired.INSTANCE;
        }
        switch (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.RECORD_AUDIO")) {
            case 0: {
                permissionResult = PermissionResult.Granted.INSTANCE;
                break;
            }
            case -1: {
                if (AudioPermissionHandlerKt.shouldShowRequestPermissionRationale(activity)) {
                    permissionResult = PermissionResult.PermanentlyDenied.INSTANCE;
                    break;
                }
                permissionResult = PermissionResult.Denied.INSTANCE;
                break;
            }
            default: {
                permissionResult = PermissionResult.Denied.INSTANCE;
            }
        }
        return permissionResult;
    }

    public static final boolean hasRecordAudioPermissionInManifest(@NotNull Context context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            boolean bl2;
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 4096);
            if (packageInfo.requestedPermissions != null) {
                bl2 = ArraysKt.contains((Object[])packageInfo.requestedPermissions, (Object)"android.permission.RECORD_AUDIO");
            } else {
                String[] cfr_ignored_0 = packageInfo.requestedPermissions;
                bl2 = false;
            }
            bl = bl2;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            bl = false;
        }
        return bl;
    }

    public static final boolean shouldShowRequestPermissionRationale(@Nullable Activity activity) {
        boolean bl;
        Activity activity2 = activity;
        if (activity2 != null) {
            Activity it = activity2;
            boolean bl2 = false;
            bl = ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)"android.permission.RECORD_AUDIO");
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean rememberAudioPermissionHandler$lambda$1(MutableState<Boolean> $showSettingsDialog$delegate) {
        void $this$getValue$iv;
        State state = (State)$showSettingsDialog$delegate;
        Object var2_2 = null;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (Boolean)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private static final void rememberAudioPermissionHandler$lambda$2(MutableState<Boolean> $showSettingsDialog$delegate, boolean bl) {
        void $this$setValue$iv;
        MutableState<Boolean> mutableState = $showSettingsDialog$delegate;
        Object var3_3 = null;
        Object var4_4 = null;
        Boolean value$iv = bl;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)value$iv);
    }

    private static final Unit rememberAudioPermissionHandler$lambda$4$lambda$3(Function0 $onPermissionGranted, Function0 $onPermissionDenied, boolean isGranted) {
        Intrinsics.checkNotNullParameter((Object)$onPermissionGranted, (String)"$onPermissionGranted");
        Intrinsics.checkNotNullParameter((Object)$onPermissionDenied, (String)"$onPermissionDenied");
        if (isGranted) {
            $onPermissionGranted.invoke();
        } else {
            $onPermissionDenied.invoke();
        }
        return Unit.INSTANCE;
    }

    private static final Unit rememberAudioPermissionHandler$lambda$6$lambda$5(Context $context, Activity $activity, Function0 $onPermissionGranted, ManagedActivityResultLauncher $permissionLauncher, MutableState $showSettingsDialog$delegate) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$onPermissionGranted, (String)"$onPermissionGranted");
        Intrinsics.checkNotNullParameter((Object)$permissionLauncher, (String)"$permissionLauncher");
        Intrinsics.checkNotNullParameter((Object)$showSettingsDialog$delegate, (String)"$showSettingsDialog$delegate");
        PermissionResult permissionResult = AudioPermissionHandlerKt.checkAudioPermissionStatus($context, $activity);
        if (Intrinsics.areEqual((Object)permissionResult, (Object)PermissionResult.Granted.INSTANCE) || Intrinsics.areEqual((Object)permissionResult, (Object)PermissionResult.NotRequired.INSTANCE)) {
            $onPermissionGranted.invoke();
        } else if (Intrinsics.areEqual((Object)permissionResult, (Object)PermissionResult.Denied.INSTANCE)) {
            $permissionLauncher.launch((Object)"android.permission.RECORD_AUDIO");
        } else if (Intrinsics.areEqual((Object)permissionResult, (Object)PermissionResult.PermanentlyDenied.INSTANCE)) {
            AudioPermissionHandlerKt.rememberAudioPermissionHandler$lambda$2((MutableState<Boolean>)$showSettingsDialog$delegate, true);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return Unit.INSTANCE;
    }

    private static final Unit rememberAudioPermissionHandler$lambda$8$lambda$7(Function0 $onPermissionDenied, MutableState $showSettingsDialog$delegate) {
        Intrinsics.checkNotNullParameter((Object)$onPermissionDenied, (String)"$onPermissionDenied");
        Intrinsics.checkNotNullParameter((Object)$showSettingsDialog$delegate, (String)"$showSettingsDialog$delegate");
        AudioPermissionHandlerKt.rememberAudioPermissionHandler$lambda$2((MutableState<Boolean>)$showSettingsDialog$delegate, false);
        $onPermissionDenied.invoke();
        return Unit.INSTANCE;
    }

    private static final Unit rememberAudioPermissionHandler$lambda$9(Context $context, MutableState $showSettingsDialog$delegate) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$showSettingsDialog$delegate, (String)"$showSettingsDialog$delegate");
        AudioPermissionHandlerKt.rememberAudioPermissionHandler$lambda$2((MutableState<Boolean>)$showSettingsDialog$delegate, false);
        Uri uri = Uri.fromParts((String)"package", (String)$context.getPackageName(), null);
        $context.startActivity(new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", uri));
        return Unit.INSTANCE;
    }
}

