/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.CallbackHolder;
import io.intercom.android.sdk.api.ExternalUploadApi;
import io.intercom.android.sdk.api.HeaderInterceptor;
import io.intercom.android.sdk.api.KotlinXConvertorFactory;
import io.intercom.android.sdk.api.MessengerApi;
import io.intercom.android.sdk.api.RateLimiter;
import io.intercom.android.sdk.api.RetryInterceptor;
import io.intercom.android.sdk.api.S3HostRedirectInterceptor;
import io.intercom.android.sdk.api.ShutdownInterceptor;
import io.intercom.android.sdk.api.ShutdownState;
import io.intercom.android.sdk.api.SurveyApi;
import io.intercom.android.sdk.api.TaggingSocketFactory;
import io.intercom.android.sdk.api.UserIdentityInterceptor;
import io.intercom.android.sdk.helpcenter.api.HelpCenterApi;
import io.intercom.android.sdk.helpcenter.utils.networking.NetworkResponseAdapterFactory;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.m5.data.IntercomDataLayer;
import io.intercom.android.sdk.m5.home.data.HomeCards;
import io.intercom.android.sdk.metrics.UnreadConversationsTracker;
import io.intercom.android.sdk.metrics.ops.OpsMetricTracker;
import io.intercom.android.sdk.models.Ticket;
import io.intercom.android.sdk.tickets.create.data.TicketApi;
import io.intercom.android.sdk.utilities.UtilsKt;
import io.intercom.android.sdk.utilities.commons.TimeProvider;
import io.intercom.android.sdk.utilities.gson.RuntimeTypeAdapterFactory;
import java.io.File;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import okhttp3.Cache;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0003\u00a2\u0006\u0004\b\u0002\u0010\u0003JT\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020)2\u0006\u0010&\u001a\u00020'J\u000e\u0010*\u001a\u00020+2\u0006\u0010&\u001a\u00020'J\u000e\u0010,\u001a\u00020#2\u0006\u0010&\u001a\u00020'J\u000e\u0010-\u001a\u00020.2\u0006\u0010&\u001a\u00020'J\u001e\u0010/\u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u00100\u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u00101\u001a\u000202J\u001e\u00103\u001a\u00020'2\u0006\u00104\u001a\u00020\u00052\u0006\u0010 \u001a\u00020!2\u0006\u00105\u001a\u000202J\u0016\u00106\u001a\u00020'2\u0006\u00104\u001a\u00020\u00052\u0006\u0010 \u001a\u00020!J\u0016\u00107\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u00108\u001a\u00020\u00052\u0006\u00104\u001a\u00020\u0005J\u0016\u00109\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010;\u001a\u00020\u00052\u0006\u0010<\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010=\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u0005H\u0007J\u000e\u0010>\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u0005J\u000e\u0010?\u001a\b\u0012\u0004\u0012\u00020A0@H\u0002J\u000e\u0010B\u001a\b\u0012\u0004\u0012\u00020C0@H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lio/intercom/android/sdk/api/ApiFactory;", "", "<init>", "()V", "CACHE_NAME", "", "PROTOCOL", "PARTIAL_HOSTNAME_US", "PARTIAL_HOSTNAME_AUS", "PARTIAL_HOSTNAME_EU", "ENDPOINT", "CACHE_SIZE", "", "MAX_DNS_SEGMENT_SIZE", "INTERCOM_TRAFFIC_TAG", "createApi", "Lio/intercom/android/sdk/api/Api;", "context", "Landroid/content/Context;", "appIdentity", "Lio/intercom/android/sdk/identity/AppIdentity;", "userIdentity", "Lio/intercom/android/sdk/identity/UserIdentity;", "appConfigProvider", "Lio/intercom/android/sdk/Provider;", "Lio/intercom/android/sdk/identity/AppConfig;", "opsMetricTracker", "Lio/intercom/android/sdk/metrics/ops/OpsMetricTracker;", "dataLayer", "Lio/intercom/android/sdk/m5/data/IntercomDataLayer;", "unreadConversationsTracker", "Lio/intercom/android/sdk/metrics/UnreadConversationsTracker;", "httpClient", "Lokhttp3/OkHttpClient;", "messengerApi", "Lio/intercom/android/sdk/api/MessengerApi;", "createHelpCenterApi", "Lio/intercom/android/sdk/helpcenter/api/HelpCenterApi;", "retrofit", "Lretrofit2/Retrofit;", "createSurveyApi", "Lio/intercom/android/sdk/api/SurveyApi;", "createTicketApi", "Lio/intercom/android/sdk/tickets/create/data/TicketApi;", "createMessengerApi", "getUploadApi", "Lio/intercom/android/sdk/api/ExternalUploadApi;", "createConfigurableHttpClient", "createHttpClientWithoutHeaders", "createGsonWithAdapters", "Lcom/google/gson/Gson;", "createLegacyRetrofit", "hostname", "gson", "createKotlinXRetrofit", "getServerUrl", "convertHostnameToUrl", "getFullHostname", "appId", "getCorrectServerHostname", "region", "createUniqueIdentifier", "removeInvalidCharacters", "getHomeCardsAdapterFactory", "Lio/intercom/android/sdk/utilities/gson/RuntimeTypeAdapterFactory;", "Lio/intercom/android/sdk/m5/home/data/HomeCards;", "getTicketTypeAdapterFactory", "Lio/intercom/android/sdk/models/Ticket$TicketAttribute;", "intercom-sdk-base_release"})
@StabilityInferred(parameters=1)
public final class ApiFactory {
    @NotNull
    public static final ApiFactory INSTANCE = new ApiFactory();
    @NotNull
    private static final String CACHE_NAME = "Intercom_SDK/HttpCache";
    @NotNull
    private static final String PROTOCOL = "https://";
    @NotNull
    private static final String PARTIAL_HOSTNAME_US = ".mobile-messenger.intercom.com";
    @NotNull
    private static final String PARTIAL_HOSTNAME_AUS = ".mobile-messenger.au.intercom.io";
    @NotNull
    private static final String PARTIAL_HOSTNAME_EU = ".mobile-messenger.eu.intercom.io";
    @NotNull
    private static final String ENDPOINT = "/messenger/mobile/";
    private static final int CACHE_SIZE = 0xA00000;
    private static final int MAX_DNS_SEGMENT_SIZE = 63;
    private static final int INTERCOM_TRAFFIC_TAG = 46837266;
    public static final int $stable;

    private ApiFactory() {
    }

    @NotNull
    public final Api createApi(@NotNull Context context, @NotNull AppIdentity appIdentity, @NotNull UserIdentity userIdentity, @NotNull Provider<AppConfig> appConfigProvider, @NotNull OpsMetricTracker opsMetricTracker, @NotNull IntercomDataLayer dataLayer, @NotNull UnreadConversationsTracker unreadConversationsTracker, @NotNull OkHttpClient httpClient, @NotNull MessengerApi messengerApi) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)appIdentity, (String)"appIdentity");
        Intrinsics.checkNotNullParameter((Object)userIdentity, (String)"userIdentity");
        Intrinsics.checkNotNullParameter(appConfigProvider, (String)"appConfigProvider");
        Intrinsics.checkNotNullParameter((Object)opsMetricTracker, (String)"opsMetricTracker");
        Intrinsics.checkNotNullParameter((Object)dataLayer, (String)"dataLayer");
        Intrinsics.checkNotNullParameter((Object)unreadConversationsTracker, (String)"unreadConversationsTracker");
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)messengerApi, (String)"messengerApi");
        CallbackHolder callbackHolder = new CallbackHolder(dataLayer, userIdentity, unreadConversationsTracker);
        RateLimiter rateLimiter = new RateLimiter(appConfigProvider.get());
        return new Api(context, appIdentity, userIdentity, httpClient, messengerApi, callbackHolder, rateLimiter, appConfigProvider, opsMetricTracker, dataLayer);
    }

    @NotNull
    public final HelpCenterApi createHelpCenterApi(@NotNull Retrofit retrofit) {
        Intrinsics.checkNotNullParameter((Object)retrofit, (String)"retrofit");
        Object object = retrofit.create(HelpCenterApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(...)");
        return (HelpCenterApi)object;
    }

    @NotNull
    public final SurveyApi createSurveyApi(@NotNull Retrofit retrofit) {
        Intrinsics.checkNotNullParameter((Object)retrofit, (String)"retrofit");
        Object object = retrofit.create(SurveyApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(...)");
        return (SurveyApi)object;
    }

    @NotNull
    public final TicketApi createTicketApi(@NotNull Retrofit retrofit) {
        Intrinsics.checkNotNullParameter((Object)retrofit, (String)"retrofit");
        Object object = retrofit.create(TicketApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(...)");
        return (TicketApi)object;
    }

    @NotNull
    public final MessengerApi createMessengerApi(@NotNull Retrofit retrofit) {
        Intrinsics.checkNotNullParameter((Object)retrofit, (String)"retrofit");
        Object object = retrofit.create(MessengerApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(...)");
        return (MessengerApi)object;
    }

    @NotNull
    public final ExternalUploadApi getUploadApi(@NotNull Retrofit retrofit) {
        Intrinsics.checkNotNullParameter((Object)retrofit, (String)"retrofit");
        Object object = retrofit.create(ExternalUploadApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(...)");
        return (ExternalUploadApi)object;
    }

    @NotNull
    public final OkHttpClient createConfigurableHttpClient(@NotNull Context context, @NotNull AppIdentity appIdentity, @NotNull UserIdentity userIdentity) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)appIdentity, (String)"appIdentity");
        Intrinsics.checkNotNullParameter((Object)userIdentity, (String)"userIdentity");
        OkHttpClient.Builder builder = new OkHttpClient.Builder().readTimeout(2L, TimeUnit.MINUTES).connectTimeout(2L, TimeUnit.MINUTES).writeTimeout(2L, TimeUnit.MINUTES).socketFactory((SocketFactory)new TaggingSocketFactory(SocketFactory.getDefault(), 46837266)).addInterceptor((Interceptor)new UserIdentityInterceptor(userIdentity)).addInterceptor((Interceptor)new RetryInterceptor(new RetryInterceptor.Sleeper())).addInterceptor((Interceptor)new ShutdownInterceptor(new ShutdownState(context, appIdentity, TimeProvider.SYSTEM)));
        HeaderInterceptor headerInterceptor = HeaderInterceptor.create(context, appIdentity);
        Intrinsics.checkNotNullExpressionValue((Object)headerInterceptor, (String)"create(...)");
        OkHttpClient.Builder builder2 = builder.addNetworkInterceptor((Interceptor)headerInterceptor);
        File systemCacheDirectory = context.getCacheDir();
        if (systemCacheDirectory != null) {
            File responseCacheDirectory = new File(systemCacheDirectory.getAbsolutePath(), CACHE_NAME);
            builder2.cache(new Cache(responseCacheDirectory, 0xA00000L));
        }
        return builder2.build();
    }

    @NotNull
    public final OkHttpClient createHttpClientWithoutHeaders(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.addInterceptor((Interceptor)new S3HostRedirectInterceptor());
        return builder.build();
    }

    @NotNull
    public final Gson createGsonWithAdapters() {
        Gson gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)this.getHomeCardsAdapterFactory()).registerTypeAdapterFactory((TypeAdapterFactory)this.getTicketTypeAdapterFactory()).create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        return gson;
    }

    @NotNull
    public final Retrofit createLegacyRetrofit(@NotNull String hostname, @NotNull OkHttpClient httpClient, @NotNull Gson gson) {
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
        Retrofit retrofit = new Retrofit.Builder().baseUrl(hostname).addCallAdapterFactory((CallAdapter.Factory)new NetworkResponseAdapterFactory()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).client(httpClient).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"build(...)");
        return retrofit;
    }

    @NotNull
    public final Retrofit createKotlinXRetrofit(@NotNull String hostname, @NotNull OkHttpClient httpClient) {
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Retrofit retrofit = new Retrofit.Builder().baseUrl(hostname).addCallAdapterFactory((CallAdapter.Factory)new NetworkResponseAdapterFactory()).addConverterFactory(KotlinXConvertorFactory.INSTANCE.getConvertorFactory()).client(httpClient).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"build(...)");
        return retrofit;
    }

    @NotNull
    public final String getServerUrl(@NotNull AppIdentity appIdentity, @NotNull Context context) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)appIdentity, (String)"appIdentity");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String customHost = UtilsKt.readHostFromManifest(context);
        if (TextUtils.isEmpty((CharSequence)customHost)) {
            String string3 = appIdentity.appId();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"appId(...)");
            string2 = this.getFullHostname(string3, context);
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            String string4 = appIdentity.appId();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"appId(...)");
            string2 = stringBuilder.append(this.createUniqueIdentifier(string4)).append(customHost).toString();
        }
        String hostName = string2;
        return this.convertHostnameToUrl(hostName);
    }

    @NotNull
    public final String convertHostnameToUrl(@NotNull String hostname) {
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        return PROTOCOL + hostname + ENDPOINT;
    }

    @NotNull
    public final String getFullHostname(@NotNull String appId, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.createUniqueIdentifier(appId) + this.getCorrectServerHostname(UtilsKt.getServerRegionFromManifest(context), context);
    }

    private final String getCorrectServerHostname(int region, Context context) {
        String string2;
        int n = region;
        if (n == UtilsKt.getRegionCode(context, R.integer.intercom_server_region_aus)) {
            string2 = PARTIAL_HOSTNAME_AUS;
        } else if (n == UtilsKt.getRegionCode(context, R.integer.intercom_server_region_eu)) {
            string2 = PARTIAL_HOSTNAME_EU;
        } else if (n == UtilsKt.getRegionCode(context, R.integer.intercom_server_region_us) || n == 0) {
            LumberMill.getLogger().i("Defaulting to US region, since no explicit region was mentioned. For more info on regions, please visit Intercom Android SDK documentation", new Object[0]);
            string2 = PARTIAL_HOSTNAME_US;
        } else {
            LumberMill.getLogger().e("Incorrect value for region is provided in AndroidManifest.xml file. Please use one of the available regions values from provided list. For more info on regions, please visit Intercom Android SDK documentation", new Object[0]);
            string2 = "";
        }
        return string2;
    }

    @VisibleForTesting
    @NotNull
    public final String createUniqueIdentifier(@NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        String identifier = this.removeInvalidCharacters(appId) + "-android";
        if (identifier.length() > 63) {
            int endIndex = 63;
            if (identifier.charAt(62) == '-') {
                --endIndex;
            }
            String string2 = identifier.substring(0, endIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            identifier = string2;
        }
        return identifier;
    }

    @NotNull
    public final String removeInvalidCharacters(@NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        CharSequence charSequence = appId;
        Regex regex = new Regex("[^A-Za-z0-9\\-$]");
        String string2 = "";
        return regex.replace(charSequence, string2);
    }

    private final RuntimeTypeAdapterFactory<HomeCards> getHomeCardsAdapterFactory() {
        RuntimeTypeAdapterFactory<HomeCards> runtimeTypeAdapterFactory = RuntimeTypeAdapterFactory.of(HomeCards.class, "type");
        String string2 = "SPACES".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        RuntimeTypeAdapterFactory<HomeCards.HomeSpacesData> runtimeTypeAdapterFactory2 = runtimeTypeAdapterFactory.registerSubtype(HomeCards.HomeSpacesData.class, string2);
        String string3 = "NEW_CONVERSATION".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        RuntimeTypeAdapterFactory<HomeCards.HomeNewConversationData> runtimeTypeAdapterFactory3 = runtimeTypeAdapterFactory2.registerSubtype(HomeCards.HomeNewConversationData.class, string3);
        String string4 = "RECENT_CONVERSATION".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        RuntimeTypeAdapterFactory<HomeCards.HomeRecentConversationData> runtimeTypeAdapterFactory4 = runtimeTypeAdapterFactory3.registerSubtype(HomeCards.HomeRecentConversationData.class, string4);
        String string5 = "HELP_CENTER".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
        RuntimeTypeAdapterFactory<HomeCards.HomeHelpCenterData> runtimeTypeAdapterFactory5 = runtimeTypeAdapterFactory4.registerSubtype(HomeCards.HomeHelpCenterData.class, string5);
        String string6 = "EXTERNAL_LINKS".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
        RuntimeTypeAdapterFactory<HomeCards.HomeExternalLinkData> runtimeTypeAdapterFactory6 = runtimeTypeAdapterFactory5.registerSubtype(HomeCards.HomeExternalLinkData.class, string6);
        String string7 = "MESSENGER_APP".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toLowerCase(...)");
        RuntimeTypeAdapterFactory<HomeCards.HomeMessengerAppData> runtimeTypeAdapterFactory7 = runtimeTypeAdapterFactory6.registerSubtype(HomeCards.HomeMessengerAppData.class, string7);
        String string8 = "RECENT_TICKETS".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toLowerCase(...)");
        RuntimeTypeAdapterFactory<HomeCards.HomeRecentTicketsData> runtimeTypeAdapterFactory8 = runtimeTypeAdapterFactory7.registerSubtype(HomeCards.HomeRecentTicketsData.class, string8);
        String string9 = "TICKET_LINKS".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"toLowerCase(...)");
        RuntimeTypeAdapterFactory<HomeCards> runtimeTypeAdapterFactory9 = runtimeTypeAdapterFactory8.registerSubtype(HomeCards.HomeTicketLinksData.class, string9).registerIgnoredSubtype(HomeCards.UnSupported.class, "UnSupported");
        Intrinsics.checkNotNullExpressionValue(runtimeTypeAdapterFactory9, (String)"registerIgnoredSubtype(...)");
        return runtimeTypeAdapterFactory9;
    }

    private final RuntimeTypeAdapterFactory<Ticket.TicketAttribute> getTicketTypeAdapterFactory() {
        RuntimeTypeAdapterFactory<Ticket.TicketAttribute> runtimeTypeAdapterFactory = RuntimeTypeAdapterFactory.of(Ticket.TicketAttribute.class, "type");
        String string2 = "STRING".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        RuntimeTypeAdapterFactory<Ticket.TicketAttribute.PrimitiveAttribute> runtimeTypeAdapterFactory2 = runtimeTypeAdapterFactory.registerSubtype(Ticket.TicketAttribute.PrimitiveAttribute.class, string2);
        String string3 = "INTEGER".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        RuntimeTypeAdapterFactory<Ticket.TicketAttribute.PrimitiveAttribute> runtimeTypeAdapterFactory3 = runtimeTypeAdapterFactory2.registerSubtype(Ticket.TicketAttribute.PrimitiveAttribute.class, string3);
        String string4 = "FLOAT".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        RuntimeTypeAdapterFactory<Ticket.TicketAttribute.PrimitiveAttribute> runtimeTypeAdapterFactory4 = runtimeTypeAdapterFactory3.registerSubtype(Ticket.TicketAttribute.PrimitiveAttribute.class, string4);
        String string5 = "BOOLEAN".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
        RuntimeTypeAdapterFactory<Ticket.TicketAttribute.PrimitiveAttribute> runtimeTypeAdapterFactory5 = runtimeTypeAdapterFactory4.registerSubtype(Ticket.TicketAttribute.PrimitiveAttribute.class, string5);
        String string6 = "LIST".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
        RuntimeTypeAdapterFactory<Ticket.TicketAttribute.ListAttribute> runtimeTypeAdapterFactory6 = runtimeTypeAdapterFactory5.registerSubtype(Ticket.TicketAttribute.ListAttribute.class, string6);
        String string7 = "DATETIME".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toLowerCase(...)");
        RuntimeTypeAdapterFactory<Ticket.TicketAttribute.DateTimeAttribute> runtimeTypeAdapterFactory7 = runtimeTypeAdapterFactory6.registerSubtype(Ticket.TicketAttribute.DateTimeAttribute.class, string7);
        String string8 = "FILES".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toLowerCase(...)");
        RuntimeTypeAdapterFactory<Ticket.TicketAttribute> runtimeTypeAdapterFactory8 = runtimeTypeAdapterFactory7.registerSubtype(Ticket.TicketAttribute.FilesAttribute.class, string8).registerIgnoredSubtype(Ticket.TicketAttribute.UnSupported.class, "UnSupported");
        Intrinsics.checkNotNullExpressionValue(runtimeTypeAdapterFactory8, (String)"registerIgnoredSubtype(...)");
        return runtimeTypeAdapterFactory8;
    }
}

