/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.overlay;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.ValueAnimator;
import android.content.Context;
import android.util.Property;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.overlay.InAppNotification;
import io.intercom.android.sdk.utilities.commons.ScreenUtils;

abstract class ChatNotification
extends InAppNotification {
    private static final int ANIMATION_DURATION = 170;
    private static final int GROWTH_WIDTH = 355;

    protected ChatNotification(Context localisedContext, Conversation conversation, int position, int screenHeight, InAppNotification.Listener listener2, Provider<AppConfig> appConfigProvider) {
        super(localisedContext, conversation, position, screenHeight, listener2, appConfigProvider);
    }

    protected abstract ViewGroup inflateChatRootView(ViewGroup var1, LayoutInflater var2);

    protected abstract View getContentContainer();

    protected abstract void updateContentContainer(Part var1);

    @Override
    protected abstract void updateViewDataDuringReplyPulse(int var1);

    @Override
    public void display(ViewGroup parentRoot, LayoutInflater inflater, boolean withFullAnimation, int bottomPadding) {
        if (this.overlayRoot == null) {
            this.overlayRoot = this.inflateChatRootView(parentRoot, inflater);
        }
        if (!this.isAttached()) {
            parentRoot.addView((View)this.overlayRoot, 0);
        }
        if (this.bottomPadding != bottomPadding) {
            FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.overlayRoot.getLayoutParams();
            params.setMargins(params.leftMargin, params.topMargin, params.rightMargin, params.bottomMargin + this.overlayRoot.getResources().getDimensionPixelSize(R.dimen.intercom_bottom_padding) + bottomPadding);
            this.overlayRoot.setLayoutParams((ViewGroup.LayoutParams)params);
            this.bottomPadding = bottomPadding;
        }
        this.populateViewsWithData();
        this.overlayRoot.setVisibility(0);
        this.beginListeningForTouchEvents();
    }

    @Override
    protected void onNotificationPressed(View view) {
        view.animate().scaleX(0.9f).scaleY(0.9f).alpha(0.9f).setDuration(50L).start();
    }

    @Override
    protected void onNotificationReleased(View view) {
        view.animate().scaleX(1.0f).scaleY(1.0f).alpha(1.0f).setDuration(50L).start();
    }

    @Override
    public void moveBackward(ViewGroup rootView, AnimatorListenerAdapter animationListener) {
        ++this.position;
        this.animateToPosition(rootView.getContext());
        this.expandChat(rootView, animationListener);
    }

    abstract void populateViewsWithData();

    private void expandChat(ViewGroup rootView, AnimatorListenerAdapter animatorListener) {
        ViewGroup bubble = (ViewGroup)rootView.findViewById(R.id.chathead_text_container);
        if (bubble == null) {
            return;
        }
        TextView headerTextView = (TextView)rootView.findViewById(R.id.chathead_text_header);
        View bodyContent = this.getContentContainer();
        ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)bubble.getLayoutParams();
        View avatarView = rootView.findViewById(R.id.chat_avatar_container);
        float translationX = avatarView.getTranslationX();
        float translationY = avatarView.getTranslationY();
        ObjectAnimator.ofPropertyValuesHolder((Object)avatarView, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.ALPHA, (float[])new float[]{1.0f, 0.8f}), PropertyValuesHolder.ofFloat((String)"translationX", (float[])new float[]{translationX, translationX + 100.0f}), PropertyValuesHolder.ofFloat((String)"translationY", (float[])new float[]{translationY, translationY - 40.0f}), PropertyValuesHolder.ofFloat((Property)View.SCALE_X, (float[])new float[]{1.0f, 0.8f}), PropertyValuesHolder.ofFloat((Property)View.SCALE_Y, (float[])new float[]{1.0f, 0.8f})}).setDuration(170L).start();
        ObjectAnimator.ofFloat((Object)headerTextView, (Property)View.ALPHA, (float[])new float[]{1.0f, 0.0f}).setDuration(170L).start();
        ObjectAnimator.ofFloat((Object)bodyContent, (Property)View.ALPHA, (float[])new float[]{1.0f, 0.0f}).setDuration(170L).start();
        this.getWidthAnimator(bubble, (Animator.AnimatorListener)animatorListener).start();
        this.getWidthAnimator(this.overlayRoot).start();
        this.getMarginAnimator(bubble, layoutParams).start();
    }

    private Animator getMarginAnimator(final ViewGroup bubble, ViewGroup.MarginLayoutParams layoutParams) {
        int leftMargin = layoutParams.leftMargin;
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{leftMargin, 0});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int val = (Integer)animation.getAnimatedValue();
                ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)bubble.getLayoutParams();
                layoutParams.leftMargin = val;
                bubble.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        });
        animator.setDuration(170L);
        return animator;
    }

    private Animator getWidthAnimator(ViewGroup bubble, final Animator.AnimatorListener animatorListener) {
        final int diff = Math.abs(bubble.getMeasuredWidth() - ScreenUtils.dpToPx(355.0f, bubble.getContext()));
        ValueAnimator animator = this.getWidthAnimator(bubble);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
            boolean hasSentUpdate = false;

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                int percentage;
                int val = (Integer)valueAnimator.getAnimatedValue();
                int n = percentage = diff > 0 ? val / diff * 100 : 100;
                if (percentage > 80 && !this.hasSentUpdate) {
                    this.hasSentUpdate = true;
                    animatorListener.onAnimationEnd(null);
                }
            }
        });
        return animator;
    }

    private ValueAnimator getWidthAnimator(final ViewGroup view) {
        int from = view.getMeasuredWidth();
        int to = ScreenUtils.dpToPx(355.0f, view.getContext());
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{from, to});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                int val = (Integer)valueAnimator.getAnimatedValue();
                ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
                layoutParams.width = val;
                view.setLayoutParams(layoutParams);
            }
        });
        animator.setDuration(170L);
        return animator;
    }
}

