/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import com.intercom.twig.Twig;
import io.intercom.android.sdk.api.BaseCallback;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.m5.data.IntercomDataLayer;
import io.intercom.android.sdk.m5.data.IntercomEvent;
import io.intercom.android.sdk.metrics.UnreadConversationsTracker;
import io.intercom.android.sdk.models.LogEventResponse;
import io.intercom.android.sdk.models.UsersResponse;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

class CallbackHolder {
    final IntercomDataLayer dataLayer;
    private static final Twig TWIG = LumberMill.getLogger();
    private final UserIdentity userIdentity;
    private final UnreadConversationsTracker unreadConversationsTracker;

    CallbackHolder(IntercomDataLayer dataLayer, UserIdentity userIdentity, UnreadConversationsTracker unreadConversationsTracker) {
        this.dataLayer = dataLayer;
        this.userIdentity = userIdentity;
        this.unreadConversationsTracker = unreadConversationsTracker;
    }

    BaseCallback<LogEventResponse.Builder> logEventCallback() {
        return new BaseCallback<LogEventResponse.Builder>(){

            @Override
            public void onSuccess(LogEventResponse.Builder builder) {
                LogEventResponse response = builder.build();
                CallbackHolder.this.dataLayer.emitEvent(new IntercomEvent.BaseResponseReceived(response));
                CallbackHolder.this.unreadConversationsTracker.track(response);
                CallbackHolder.this.userIdentity.update(response.getUser());
                CallbackHolder.this.dataLayer.updateConfig(response.getConfig());
                CallbackHolder.this.dataLayer.updateCarousel(response.getCarousel());
                CallbackHolder.this.dataLayer.updateOverlayConversations(response.getUnreadConversations().getConversations());
                CallbackHolder.this.dataLayer.updateUnreadConversationIds(response.getUnreadConversations().getUnreadConversationIds());
            }
        };
    }

    BaseCallback<UsersResponse.Builder> unreadCallback() {
        return new BaseCallback<UsersResponse.Builder>(){

            @Override
            public void onSuccess(UsersResponse.Builder builder) {
                UsersResponse response = builder.build();
                CallbackHolder.this.dataLayer.emitEvent(new IntercomEvent.BaseResponseReceived(response));
                CallbackHolder.this.unreadConversationsTracker.track(response);
                CallbackHolder.this.userIdentity.update(response.getUser());
                CallbackHolder.this.dataLayer.updateConfig(response.getConfig());
                CallbackHolder.this.dataLayer.updateOverlayConversations(response.getUnreadConversations().getConversations());
                CallbackHolder.this.dataLayer.updateUnreadConversationIds(response.getUnreadConversations().getUnreadConversationIds());
            }
        };
    }

    Callback<Void> loggingCallback(final String action) {
        return new Callback<Void>(){

            public void onResponse(Call<Void> call, Response<Void> response) {
                TWIG.internal(action + " success");
            }

            public void onFailure(Call<Void> call, Throwable throwable) {
                TWIG.internal(action + " failure");
            }
        };
    }
}

