/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.overlay;

import android.content.Context;
import android.content.res.Resources;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.ConfigModules;
import io.intercom.android.sdk.models.CustomizationColorsModel;
import io.intercom.android.sdk.overlay.DefaultLauncher;
import io.intercom.android.sdk.overlay.LauncherOpenBehaviour;
import io.intercom.android.sdk.utilities.ColorUtils;

public class DefaultLauncherPresenter
implements DefaultLauncher.Listener {
    private final LayoutInflater inflater;
    private final LauncherOpenBehaviour openBehaviour;
    private final MetricTracker metricTracker;
    private int previousUnreadCount = 0;
    private int bottomPadding = 0;
    @VisibleForTesting
    @Nullable
    DefaultLauncher defaultLauncher;

    public DefaultLauncherPresenter(LayoutInflater inflater, LauncherOpenBehaviour openBehaviour, MetricTracker metricTracker) {
        this.inflater = inflater;
        this.openBehaviour = openBehaviour;
        this.metricTracker = metricTracker;
        this.bottomPadding = this.getDefaultPadding(inflater.getContext().getResources());
    }

    public void displayLauncherOnAttachedRoot(ViewGroup root, AppConfig appConfig) {
        if (this.defaultLauncher != null && !this.defaultLauncher.isAttachedToRoot(root)) {
            this.defaultLauncher.removeView();
            this.defaultLauncher = null;
        }
        if (this.defaultLauncher == null) {
            this.defaultLauncher = new DefaultLauncher(root, this.inflater, this, this.bottomPadding);
            this.defaultLauncher.fadeOnScreen();
        }
        this.setLauncherBackgroundColor(appConfig);
        this.setLauncherLogo(appConfig);
        this.setUnreadCount(this.previousUnreadCount);
    }

    DefaultLauncher getAndUnsetLauncher() {
        DefaultLauncher localLauncher = this.defaultLauncher;
        this.defaultLauncher = null;
        return localLauncher;
    }

    void setLauncherBackgroundColor(@ColorInt int foregroundColor, @ColorInt int backgroundColor) {
        if (this.defaultLauncher != null) {
            this.defaultLauncher.setLauncherColor(foregroundColor, backgroundColor);
        }
    }

    void setLauncherBackgroundColor(AppConfig appConfig) {
        ConfigModules config = appConfig.getConfigModules();
        if (config != null) {
            CustomizationColorsModel actionColors = config.getCustomization().getAction();
            int backgroundColor = ColorUtils.parseColor(actionColors.getBackgroundColor());
            int foregroundColor = ColorUtils.parseColor(actionColors.getForegroundLowContrastColor());
            this.setLauncherBackgroundColor(foregroundColor, backgroundColor);
        }
    }

    void setLauncherLogo(AppConfig appConfig) {
        boolean hasLauncherLogo;
        boolean bl = hasLauncherLogo = !TextUtils.isEmpty((CharSequence)appConfig.getLauncherLogoUrl()) || appConfig.getConfigModules() != null && (!TextUtils.isEmpty((CharSequence)appConfig.getConfigModules().getCustomization().getLauncherLogoUrl()) || !TextUtils.isEmpty((CharSequence)appConfig.getConfigModules().getCustomization().getLauncherLogoDarkUrl()));
        if (this.defaultLauncher != null && hasLauncherLogo) {
            this.defaultLauncher.setLauncherLogo(appConfig);
        } else if (this.defaultLauncher != null) {
            this.defaultLauncher.setDefaultLogo();
        }
    }

    void removeLauncher() {
        if (this.defaultLauncher != null) {
            this.defaultLauncher.fadeOffScreen(null);
            this.defaultLauncher = null;
        }
    }

    public boolean isDisplaying() {
        return this.defaultLauncher != null;
    }

    public void setUnreadCount(int unreadCount) {
        if (this.isDisplaying()) {
            String unreadCountText = String.valueOf(unreadCount);
            if (unreadCount > this.previousUnreadCount) {
                this.metricTracker.receivedNotificationFromBadgeWhenMessengerClosed(unreadCountText);
            }
            if (unreadCount > 0) {
                this.defaultLauncher.setBadgeCount(unreadCountText);
            } else {
                this.defaultLauncher.hideBadgeCount();
            }
        }
        this.previousUnreadCount = unreadCount;
    }

    @Override
    public void onLauncherClicked(Context context) {
        this.openBehaviour.openMessenger(context);
    }

    private int getDefaultPadding(Resources resources) {
        return resources.getDimensionPixelSize(R.dimen.intercom_launcher_padding_bottom) + resources.getDimensionPixelSize(R.dimen.intercom_bottom_padding);
    }

    public void setBottomPadding(int bottomPadding) {
        this.bottomPadding = this.getDefaultPadding(this.inflater.getContext().getResources()) + bottomPadding;
        if (this.isDisplaying()) {
            this.defaultLauncher.updateBottomPadding(this.bottomPadding);
        }
    }
}

