/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.conversation.reducers;

import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.m5.conversation.states.BottomBarUiState;
import io.intercom.android.sdk.m5.conversation.states.ComposerState;
import io.intercom.android.sdk.m5.conversation.states.ConversationClientState;
import io.intercom.android.sdk.m5.conversation.states.InputTypeState;
import io.intercom.android.sdk.models.ComposerSuggestions;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.OpenMessengerResponse;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.ReactionReply;
import io.intercom.android.sdk.utilities.extensions.AppConfigExtensionsKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\r"}, d2={"reduceComposerState", "Lio/intercom/android/sdk/m5/conversation/states/BottomBarUiState;", "clientState", "Lio/intercom/android/sdk/m5/conversation/states/ConversationClientState;", "config", "Lio/intercom/android/sdk/identity/AppConfig;", "composerSuggestions", "Lio/intercom/android/sdk/models/ComposerSuggestions;", "isNewConversation", "", "reduceTextInput", "Lio/intercom/android/sdk/m5/conversation/states/ComposerState;", "currentState", "intercom-sdk-base_release"})
@SourceDebugExtension(value={"SMAP\nComposerStateReducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposerStateReducer.kt\nio/intercom/android/sdk/m5/conversation/reducers/ComposerStateReducerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1747#2,3:110\n*S KotlinDebug\n*F\n+ 1 ComposerStateReducer.kt\nio/intercom/android/sdk/m5/conversation/reducers/ComposerStateReducerKt\n*L\n68#1:110,3\n*E\n"})
public final class ComposerStateReducerKt {
    @NotNull
    public static final BottomBarUiState reduceComposerState(@NotNull ConversationClientState clientState, @NotNull AppConfig config, @NotNull ComposerSuggestions composerSuggestions, boolean isNewConversation) {
        List list;
        ComposerState composerState;
        Intrinsics.checkNotNullParameter((Object)clientState, (String)"clientState");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)composerSuggestions, (String)"composerSuggestions");
        Conversation conversation = clientState.getConversation();
        if (conversation == null) {
            composerState = composerSuggestions.isComposerDisabled() ? (ComposerState)new ComposerState.Hidden(false, 1, null) : (clientState.isConversationalHome() ? (ComposerState)ComposerState.StartConversation.INSTANCE : ComposerStateReducerKt.reduceTextInput(clientState.getComposerState(), isNewConversation));
        } else {
            boolean hasReactions;
            boolean allowStartingNewConversation = AppConfigExtensionsKt.canStartNewConversation(config) && !conversation.getInboundConversationsDisabled();
            Object object = clientState.getOpenMessengerResponse();
            OpenMessengerResponse.NewConversationData.Cta ctaData = object != null && (object = ((OpenMessengerResponse)object).getNewConversationData()) != null ? ((OpenMessengerResponse.NewConversationData)object).getCta() : null;
            Pair pair = allowStartingNewConversation && ctaData != null ? new Pair((Object)ctaData.getText(), (Object)ctaData.getIcon().getIcon()) : new Pair(null, null);
            String ctaTitle = (String)pair.component1();
            Integer trailingIcon = (Integer)pair.component2();
            ComposerState.ConversationEnded conversationEndedState = new ComposerState.ConversationEnded(allowStartingNewConversation, ctaTitle, trailingIcon);
            boolean bl = hasReactions = !ReactionReply.isNull(conversation.getLastPart().getReactionReply());
            if (conversation.shouldPreventEndUserReplies()) {
                composerState = conversationEndedState;
            } else if (conversation.getComposerState().isVisible() && !hasReactions) {
                composerState = ComposerStateReducerKt.reduceTextInput(clientState.getComposerState(), isNewConversation);
            } else if (hasReactions) {
                ReactionReply reactionReply = conversation.getLastPart().getReactionReply();
                Intrinsics.checkNotNullExpressionValue((Object)reactionReply, (String)"conversation.lastPart.reactionReply");
                String string2 = conversation.getLastPart().getId();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"conversation.lastPart.id");
                String string3 = conversation.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"conversation.id");
                composerState = new ComposerState.Reactions(reactionReply, string2, string3);
            } else {
                boolean bl2;
                block14: {
                    List<Part> list2 = conversation.getParts();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"conversation.parts");
                    Iterable $this$any$iv = list2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Part it = (Part)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it.getMessageStyle(), (Object)"attribute_collector")) continue;
                            bl2 = true;
                            break block14;
                        }
                        bl2 = false;
                    }
                }
                boolean bl4 = !bl2;
                composerState = new ComposerState.Hidden(bl4);
            }
        }
        ComposerState composerState2 = composerState;
        List $this$reduceComposerState_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (config.getAttachmentSettings().getGifsEnabled()) {
            $this$reduceComposerState_u24lambda_u241.add(BottomBarUiState.BottomBarButton.GifInsert.INSTANCE);
        }
        if (config.getAttachmentSettings().getMediaEnabled() || config.getAttachmentSettings().getCameraEnabled()) {
            $this$reduceComposerState_u24lambda_u241.add(BottomBarUiState.BottomBarButton.MediaInsert.INSTANCE);
        }
        if (config.getFinDictationUiEnabled()) {
            $this$reduceComposerState_u24lambda_u241.add(BottomBarUiState.BottomBarButton.VoiceTypingInsert.INSTANCE);
        }
        List bottomBarButtons = CollectionsKt.build((List)list);
        return new BottomBarUiState(composerState2, clientState.getCurrentlyTypingState(), new InputTypeState(config.getAttachmentSettings().getMediaEnabled(), config.getAttachmentSettings().getGifsEnabled(), config.getAttachmentSettings().getCameraEnabled(), config.getAttachmentSettings().getTrustedFileExtensions(), config.getFinDictationUiEnabled()), bottomBarButtons);
    }

    private static final ComposerState reduceTextInput(ComposerState currentState, boolean isNewConversation) {
        ComposerState composerState;
        if (currentState instanceof ComposerState.TextInput) {
            ComposerState.TextInput textInput = (ComposerState.TextInput)currentState;
            int n = R.string.intercom_message_placeholder;
            String string2 = isNewConversation ? ((ComposerState.TextInput)currentState).getInitialMessage() : "";
            composerState = textInput.copy(string2, n);
        } else {
            composerState = currentState;
        }
        return composerState;
    }
}

