/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.overlay;

import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.OvershootInterpolator;
import android.widget.TextView;
import androidx.compose.ui.platform.ComposeView;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.m5.notification.InAppNotificationCardKt;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.overlay.InAppNotification;

class StackableSnippet
extends InAppNotification
implements View.OnTouchListener {
    private static final int BASE_MARGIN_DP = 16;
    private static final int BASE_ELEVATION = 18;
    private static final int ELEVATION_STEP = 3;
    private final Handler handler;

    public StackableSnippet(Context localisedContext, Conversation conversation, int position, Handler handler, int screenHeight, InAppNotification.Listener listener2, Provider<AppConfig> appConfigProvider) {
        super(localisedContext, conversation, position, screenHeight, listener2, appConfigProvider);
        this.handler = handler;
    }

    @Override
    public void moveBackward(ViewGroup rootView, AnimatorListenerAdapter animationListener) {
        ++this.position;
        this.animateToPosition(rootView.getContext());
    }

    @Override
    public void display(ViewGroup root, LayoutInflater inflater, boolean withFullAnimation, int bottomPadding) {
        this.setupView(root, inflater);
        this.setViewData(bottomPadding);
        if (withFullAnimation) {
            this.animateOnScreen();
        } else {
            this.overlayRoot.setVisibility(0);
        }
    }

    @Override
    public void update(Conversation conversation, Runnable updateEndAction) {
        this.conversation = conversation;
        View textContainer = this.overlayRoot.findViewById(R.id.notification_root);
        View text = this.overlayRoot.findViewById(R.id.in_app_notification_message_summary);
        this.performReplyPulse(textContainer, text, updateEndAction);
    }

    @Override
    protected void updateViewDataDuringReplyPulse(int bottomPadding) {
        this.setViewData(bottomPadding);
    }

    private void setupView(ViewGroup root, LayoutInflater inflater) {
        if (this.overlayRoot == null) {
            this.overlayRoot = (ViewGroup)inflater.inflate(R.layout.intercom_preview_notification, root, false);
        }
        if (!this.isAttached()) {
            root.addView((View)this.overlayRoot, 0);
        }
    }

    private void setViewData(int bottomPadding) {
        Context context = this.overlayRoot.getContext();
        ComposeView composeView = (ComposeView)this.overlayRoot.findViewById(R.id.chat_snippet_compose_view);
        InAppNotificationCardKt.addInappNotificationCardToView(composeView, this.conversation);
        this.overlayRoot.setElevation((float)(18 - 3 * this.position));
        this.overlayRoot.setScaleX(1.0f - (float)this.position * 0.05f);
        if (this.position == 0) {
            this.beginListeningForTouchEvents();
        }
    }

    private void setSummaryText(Part part) {
        TextView summary = (TextView)this.overlayRoot.findViewById(R.id.in_app_notification_message_summary);
        if (part.getEventData().getCustomStatePrefix() != null && !part.getEventData().getCustomStatePrefix().isEmpty()) {
            summary.setText((CharSequence)part.getEventData().getCustomStatePrefix());
        } else {
            summary.setText((CharSequence)part.getSummary());
        }
    }

    private void animateOnScreen() {
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                StackableSnippet.this.overlayRoot.setVisibility(0);
                StackableSnippet.this.overlayRoot.setY((float)StackableSnippet.this.screenHeight);
                StackableSnippet.this.overlayRoot.animate().setInterpolator((TimeInterpolator)new OvershootInterpolator(0.6f)).translationY(0.0f).setDuration(300L).start();
            }
        }, (long)(this.position * 70));
    }

    @Override
    protected void onNotificationPressed(View view) {
        view.animate().scaleX(0.95f).scaleY(0.95f).setDuration(50L).start();
    }

    @Override
    protected void onNotificationReleased(View view) {
        view.animate().scaleX(1.0f).scaleY(1.0f).setDuration(50L).start();
    }
}

