/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities.extensions;

import io.intercom.android.sdk.blocks.lib.BlockType;
import io.intercom.android.sdk.blocks.lib.models.Block;
import io.intercom.android.sdk.models.Attachments;
import io.intercom.android.sdk.models.MessageStyle;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.ReplyOption;
import io.intercom.android.sdk.models.UxStyle;
import io.intercom.android.sdk.ui.extension.ContentTypeExtensionKt;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\r\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u001a\f\u0010\t\u001a\u00020\u0004*\u00020\u0006H\u0000\u001a\u001a\u0010\n\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00060\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0001\u001a\u001a\u0010\r\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00060\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u001a\u0010\u000e\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00060\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0001\u001a\u001a\u0010\u000f\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00060\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\f\u0010\u0010\u001a\u00020\u0004*\u00020\u0006H\u0000\u001a\f\u0010\u0011\u001a\u00020\u0004*\u00020\u0006H\u0000\u001a\f\u0010\u0012\u001a\u00020\u0004*\u00020\u0006H\u0000\u001a\f\u0010\u0013\u001a\u00020\u0004*\u00020\u0006H\u0000\u001a\u0014\u0010\u0014\u001a\u00020\u0004*\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0002H\u0002\u001a\f\u0010\u0016\u001a\u00020\u0004*\u00020\u0006H\u0002\u001a\f\u0010\u0017\u001a\u00020\u0004*\u00020\u0006H\u0000\u001a\u0014\u0010\u0018\u001a\u00020\u0004*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"textBlockTypes", "", "Lio/intercom/android/sdk/blocks/lib/BlockType;", "shouldConcatenate", "", "part", "Lio/intercom/android/sdk/models/Part;", "nextPart", "shouldConcatenateNewStyle", "hasNewMessengerStyle", "hasNextConcatPart", "index", "", "hasNextConcatPartNewStyle", "hasPreviousConcatPart", "hasPreviousConcatPartNewStyle", "hasTextBlock", "isAttributeCollector", "isLinkCard", "isQuickReplyOnly", "isSingleBlockPartOfType", "type", "isSingleVideoAttachment", "isTypingPart", "nextPartFromSameParticipant", "intercom-sdk-base_release"})
@SourceDebugExtension(value={"SMAP\nPartExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PartExtensions.kt\nio/intercom/android/sdk/utilities/extensions/PartExtensionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1755#2,3:83\n*S KotlinDebug\n*F\n+ 1 PartExtensions.kt\nio/intercom/android/sdk/utilities/extensions/PartExtensionsKt\n*L\n17#1:83,3\n*E\n"})
public final class PartExtensionsKt {
    @NotNull
    private static final List<BlockType> textBlockTypes;

    public static final boolean hasTextBlock(@NotNull Part $this$hasTextBlock) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$hasTextBlock, (String)"<this>");
            List<Block> list = $this$hasTextBlock.getBlocks();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getBlocks(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Block it = (Block)element$iv;
                    boolean bl2 = false;
                    if (!textBlockTypes.contains((Object)it.getType())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean nextPartFromSameParticipant(@NotNull Part $this$nextPartFromSameParticipant, @NotNull Part nextPart) {
        Intrinsics.checkNotNullParameter((Object)$this$nextPartFromSameParticipant, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)nextPart, (String)"nextPart");
        return Intrinsics.areEqual((Object)$this$nextPartFromSameParticipant.getParticipantId(), (Object)nextPart.getParticipantId());
    }

    public static final boolean isTypingPart(@NotNull Part $this$isTypingPart) {
        Intrinsics.checkNotNullParameter((Object)$this$isTypingPart, (String)"<this>");
        return $this$isTypingPart.getMessageStyle() == MessageStyle.ADMIN_IS_TYPING_STYLE;
    }

    public static final boolean isAttributeCollector(@NotNull Part $this$isAttributeCollector) {
        Intrinsics.checkNotNullParameter((Object)$this$isAttributeCollector, (String)"<this>");
        return $this$isAttributeCollector.getMessageStyle() == MessageStyle.ATTRIBUTE_COLLECTOR && !((Collection)$this$isAttributeCollector.getForm().getAttributes()).isEmpty();
    }

    public static final boolean isLinkCard(@NotNull Part $this$isLinkCard) {
        Intrinsics.checkNotNullParameter((Object)$this$isLinkCard, (String)"<this>");
        return PartExtensionsKt.isSingleBlockPartOfType($this$isLinkCard, BlockType.LINK) && MessageStyle.CHAT == $this$isLinkCard.getMessageStyle();
    }

    public static final boolean isQuickReplyOnly(@NotNull Part $this$isQuickReplyOnly) {
        Intrinsics.checkNotNullParameter((Object)$this$isQuickReplyOnly, (String)"<this>");
        List<ReplyOption> list = $this$isQuickReplyOnly.getReplyOptions();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getReplyOptions(...)");
        return !((Collection)list).isEmpty() && $this$isQuickReplyOnly.getBlocks().isEmpty();
    }

    private static final boolean isSingleBlockPartOfType(Part $this$isSingleBlockPartOfType, BlockType type2) {
        return $this$isSingleBlockPartOfType.getBlocks().size() == 1 && $this$isSingleBlockPartOfType.getBlocks().get(0).getType() == type2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isSingleVideoAttachment(Part $this$isSingleVideoAttachment) {
        if (!$this$isSingleVideoAttachment.getBlocks().isEmpty()) return false;
        List<Attachments> list = $this$isSingleVideoAttachment.getAttachments();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAttachments(...)");
        Attachments attachments = (Attachments)CollectionsKt.singleOrNull(list);
        Object object = attachments;
        if (attachments == null) return false;
        String string2 = ((Attachments)object).getContentType();
        object = string2;
        if (string2 == null) return false;
        if (!ContentTypeExtensionKt.isVideo((String)object)) return false;
        return true;
    }

    @Deprecated(message="Old grouping logic", replaceWith=@ReplaceWith(expression="hasPreviousConcatPartNewStyle", imports={}))
    public static final boolean hasPreviousConcatPart(@NotNull List<? extends Part> $this$hasPreviousConcatPart, int index) {
        Intrinsics.checkNotNullParameter($this$hasPreviousConcatPart, (String)"<this>");
        return (1 <= index ? index <= CollectionsKt.getLastIndex($this$hasPreviousConcatPart) : false) && PartExtensionsKt.shouldConcatenate($this$hasPreviousConcatPart.get(index - 1), $this$hasPreviousConcatPart.get(index));
    }

    @Deprecated(message="Old grouping logic", replaceWith=@ReplaceWith(expression="hasNextConcatPartNewStyle", imports={}))
    public static final boolean hasNextConcatPart(@NotNull List<? extends Part> $this$hasNextConcatPart, int index) {
        Intrinsics.checkNotNullParameter($this$hasNextConcatPart, (String)"<this>");
        return (0 <= index ? index < CollectionsKt.getLastIndex($this$hasNextConcatPart) : false) && PartExtensionsKt.shouldConcatenate($this$hasNextConcatPart.get(index), $this$hasNextConcatPart.get(index + 1));
    }

    private static final boolean shouldConcatenate(Part part, Part nextPart) {
        return PartExtensionsKt.nextPartFromSameParticipant(part, nextPart) && Math.abs(nextPart.getCreatedAt() - part.getCreatedAt()) < TimeUnit.MINUTES.toSeconds(3L) && !PartExtensionsKt.isTypingPart(part) && !PartExtensionsKt.isTypingPart(nextPart) && !PartExtensionsKt.isLinkCard(part) && !PartExtensionsKt.isLinkCard(nextPart) && part.isEvent() == false && nextPart.isEvent() == false && !PartExtensionsKt.isAttributeCollector(part) && !PartExtensionsKt.isAttributeCollector(nextPart) && !PartExtensionsKt.isQuickReplyOnly(part) && !PartExtensionsKt.isQuickReplyOnly(nextPart) && part.getMessageStyle() != MessageStyle.POST && nextPart.getMessageStyle() != MessageStyle.POST && part.getMessageStyle() != MessageStyle.NOTE && nextPart.getMessageStyle() != MessageStyle.NOTE;
    }

    public static final boolean hasPreviousConcatPartNewStyle(@NotNull List<? extends Part> $this$hasPreviousConcatPartNewStyle, int index) {
        Intrinsics.checkNotNullParameter($this$hasPreviousConcatPartNewStyle, (String)"<this>");
        return (1 <= index ? index <= CollectionsKt.getLastIndex($this$hasPreviousConcatPartNewStyle) : false) && PartExtensionsKt.shouldConcatenateNewStyle($this$hasPreviousConcatPartNewStyle.get(index - 1), $this$hasPreviousConcatPartNewStyle.get(index));
    }

    public static final boolean hasNextConcatPartNewStyle(@NotNull List<? extends Part> $this$hasNextConcatPartNewStyle, int index) {
        Intrinsics.checkNotNullParameter($this$hasNextConcatPartNewStyle, (String)"<this>");
        return (0 <= index ? index < CollectionsKt.getLastIndex($this$hasNextConcatPartNewStyle) : false) && PartExtensionsKt.shouldConcatenateNewStyle($this$hasNextConcatPartNewStyle.get(index), $this$hasNextConcatPartNewStyle.get(index + 1));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean shouldConcatenateNewStyle(Part part, Part nextPart) {
        if (!PartExtensionsKt.shouldConcatenate(part, nextPart)) return false;
        UxStyle uxStyle = part.getUxStyle();
        UxStyle uxStyle2 = nextPart.getUxStyle();
        if ((uxStyle != null ? uxStyle.getContainer() : null) != (uxStyle2 != null ? uxStyle2.getContainer() : null)) return false;
        return true;
    }

    public static final boolean hasNewMessengerStyle(@NotNull Part $this$hasNewMessengerStyle) {
        Intrinsics.checkNotNullParameter((Object)$this$hasNewMessengerStyle, (String)"<this>");
        return $this$hasNewMessengerStyle.getUxStyle() != null;
    }

    static {
        BlockType[] blockTypeArray = new BlockType[]{BlockType.PARAGRAPH, BlockType.HEADING, BlockType.SUBHEADING};
        textBlockTypes = CollectionsKt.listOf((Object[])blockTypeArray);
    }
}

