/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.annotation.SuppressLint;
import android.app.Application;
import android.app.TaskStackBuilder;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import com.intercom.twig.Twig;
import io.intercom.android.nexus.NexusClient;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.IntercomContent;
import io.intercom.android.sdk.IntercomError;
import io.intercom.android.sdk.IntercomPushManager;
import io.intercom.android.sdk.IntercomSpace;
import io.intercom.android.sdk.IntercomStatusCallback;
import io.intercom.android.sdk.IntercomStatusCallbackKt;
import io.intercom.android.sdk.LateInitializationPreparer;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.ResetManager;
import io.intercom.android.sdk.UnreadConversationCountListener;
import io.intercom.android.sdk.UserAttributes;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.activities.IntercomCarouselActivity;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.DeDuper;
import io.intercom.android.sdk.api.UserUpdateRequest;
import io.intercom.android.sdk.api.UserUpdater;
import io.intercom.android.sdk.errorreporting.ErrorReporter;
import io.intercom.android.sdk.helpcenter.api.CollectionContentRequestCallback;
import io.intercom.android.sdk.helpcenter.api.CollectionRequestCallback;
import io.intercom.android.sdk.helpcenter.api.HelpCenterApiWrapper;
import io.intercom.android.sdk.helpcenter.api.SearchRequestCallback;
import io.intercom.android.sdk.helpcenter.articles.ArticleActivity;
import io.intercom.android.sdk.helpcenter.utils.HelpCenterUrlUtilsKt;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.Registration;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.m5.ConversationScreenOpenerKt;
import io.intercom.android.sdk.m5.navigation.IntercomRootActivityLauncher;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.overlay.LauncherOpenBehaviour;
import io.intercom.android.sdk.overlay.OverlayPresenter;
import io.intercom.android.sdk.push.IntercomLegacyPushClientHandler;
import io.intercom.android.sdk.push.SystemNotificationManager;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.store.UnreadCountTracker;
import io.intercom.android.sdk.survey.ui.IntercomSurveyActivity;
import io.intercom.android.sdk.utilities.ActivityFinisher;
import io.intercom.android.sdk.utilities.AttributeSanitiser;
import io.intercom.android.sdk.utilities.ValidatorUtil;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00f8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 y2\u00020\u0001:\u0003yz{B\u009f\u0001\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0005\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0005\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u0012\u0006\u0010 \u001a\u00020!\u0012\u0006\u0010\"\u001a\u00020#\u00a2\u0006\u0002\u0010$J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,J\u0010\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020/H\u0007J\u0012\u00100\u001a\u00020*2\b\u00101\u001a\u0004\u0018\u00010/H\u0007J\b\u00102\u001a\u00020*H\u0007J\b\u00103\u001a\u00020*H\u0007J\u001a\u00104\u001a\u00020*2\u0010\u00105\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010/\u0018\u000106H\u0007J\u0006\u00107\u001a\u00020*J\u0010\u00107\u001a\u00020*2\b\u00108\u001a\u0004\u0018\u00010/J\b\u00109\u001a\u00020*H\u0007J\u0010\u0010:\u001a\u00020*2\u0006\u0010;\u001a\u00020/H\u0007J\u001a\u0010<\u001a\u00020*2\b\u0010=\u001a\u0004\u0018\u00010/2\b\u0010>\u001a\u0004\u0018\u00010?J\u0010\u0010@\u001a\u00020*2\b\u0010A\u001a\u0004\u0018\u00010BJ\b\u0010C\u001a\u0004\u0018\u00010DJ\u0006\u0010E\u001a\u00020*J\u0010\u0010E\u001a\u00020*2\b\u0010F\u001a\u0004\u0018\u00010GJ\u0006\u0010H\u001a\u00020*J\u0006\u0010I\u001a\u00020JJ\u0010\u0010K\u001a\u00020*2\u0006\u0010L\u001a\u00020/H\u0002J\u000e\u0010M\u001a\u00020*2\u0006\u0010N\u001a\u00020/J$\u0010M\u001a\u00020*2\b\u0010N\u001a\u0004\u0018\u00010/2\u0012\u0010O\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0002\b\u0003\u0018\u00010PJ$\u0010Q\u001a\u00020*2\b\u0010N\u001a\u0004\u0018\u00010/2\u0010\u0010R\u001a\f\u0012\u0004\u0012\u00020/\u0012\u0002\b\u00030PH\u0002J\u0018\u0010S\u001a\u00020*2\u0006\u0010T\u001a\u00020D2\b\b\u0002\u0010U\u001a\u00020VJ\u0010\u0010W\u001a\u00020*2\b\b\u0002\u0010U\u001a\u00020VJ\u0006\u0010X\u001a\u00020*J\b\u0010Y\u001a\u00020JH\u0002J\u001c\u0010Z\u001a\u00020*2\b\u0010[\u001a\u0004\u0018\u00010/2\b\u0010F\u001a\u0004\u0018\u00010GH\u0002J&\u0010\\\u001a\u00020*2\u0014\u0010]\u001a\u0010\u0012\u0004\u0012\u00020/\u0012\u0006\u0012\u0004\u0018\u00010\u00010P2\u0006\u0010U\u001a\u00020VH\u0002J\u0012\u0010^\u001a\u00020*2\b\b\u0002\u0010_\u001a\u00020`H\u0007J\u000e\u0010a\u001a\u00020*2\u0006\u0010b\u001a\u00020cJ\u0012\u0010d\u001a\u00020*2\b\u0010T\u001a\u0004\u0018\u00010DH\u0007J\b\u0010e\u001a\u00020*H\u0007J\u0010\u0010f\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,J\b\u0010g\u001a\u00020*H\u0007J\u001a\u0010h\u001a\u00020*2\b\u0010i\u001a\u0004\u0018\u00010/2\b\u0010j\u001a\u0004\u0018\u00010kJ\u000e\u0010l\u001a\u00020*2\u0006\u0010m\u001a\u00020&J\u0010\u0010n\u001a\u00020*2\b\u0010o\u001a\u0004\u0018\u00010pJ\u0010\u0010q\u001a\u00020*2\b\u0010o\u001a\u0004\u0018\u00010pJ\u000e\u0010r\u001a\u00020*2\u0006\u0010s\u001a\u00020/J\b\u0010t\u001a\u00020JH\u0002J\b\u0010u\u001a\u00020*H\u0002J\u0018\u0010v\u001a\u00020*2\u0006\u0010]\u001a\u00020w2\b\b\u0002\u0010U\u001a\u00020VJ\u0012\u0010v\u001a\u00020*2\b\u0010]\u001a\u0004\u0018\u00010wH\u0007J\u0010\u0010x\u001a\u00020J2\u0006\u0010T\u001a\u00020DH\u0002R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010%\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006|"}, d2={"Lio/intercom/android/sdk/Intercom;", "", "superDeDuper", "Lio/intercom/android/sdk/api/DeDuper;", "apiProvider", "Lio/intercom/android/sdk/Provider;", "Lio/intercom/android/sdk/api/Api;", "nexusClient", "Lio/intercom/android/nexus/NexusClient;", "store", "Lio/intercom/android/sdk/store/Store;", "Lio/intercom/android/sdk/state/State;", "unreadCountTracker", "Lio/intercom/android/sdk/store/UnreadCountTracker;", "metricTracker", "Lio/intercom/android/sdk/metrics/MetricTracker;", "errorReporter", "Lio/intercom/android/sdk/errorreporting/ErrorReporter;", "context", "Landroid/app/Application;", "overlayPresenter", "Lio/intercom/android/sdk/overlay/OverlayPresenter;", "appConfigProvider", "Lio/intercom/android/sdk/identity/AppConfig;", "userIdentity", "Lio/intercom/android/sdk/identity/UserIdentity;", "systemNotificationManager", "Lio/intercom/android/sdk/push/SystemNotificationManager;", "userUpdater", "Lio/intercom/android/sdk/api/UserUpdater;", "resetManager", "Lio/intercom/android/sdk/ResetManager;", "twig", "Lcom/intercom/twig/Twig;", "activityFinisher", "Lio/intercom/android/sdk/utilities/ActivityFinisher;", "(Lio/intercom/android/sdk/api/DeDuper;Lio/intercom/android/sdk/Provider;Lio/intercom/android/nexus/NexusClient;Lio/intercom/android/sdk/store/Store;Lio/intercom/android/sdk/store/UnreadCountTracker;Lio/intercom/android/sdk/metrics/MetricTracker;Lio/intercom/android/sdk/errorreporting/ErrorReporter;Landroid/app/Application;Lio/intercom/android/sdk/overlay/OverlayPresenter;Lio/intercom/android/sdk/Provider;Lio/intercom/android/sdk/identity/UserIdentity;Lio/intercom/android/sdk/push/SystemNotificationManager;Lio/intercom/android/sdk/Provider;Lio/intercom/android/sdk/ResetManager;Lcom/intercom/twig/Twig;Lio/intercom/android/sdk/utilities/ActivityFinisher;)V", "unreadConversationCount", "", "getUnreadConversationCount", "()I", "addUnreadConversationCountListener", "", "listener", "Lio/intercom/android/sdk/UnreadConversationCountListener;", "displayArticle", "articleId", "", "displayCarousel", "carouselId", "displayConversationsList", "displayHelpCenter", "displayHelpCenterCollections", "collectionIds", "", "displayMessageComposer", "initialMessage", "displayMessenger", "displaySurvey", "surveyId", "fetchHelpCenterCollection", "collectionId", "collectionContentRequestCallback", "Lio/intercom/android/sdk/helpcenter/api/CollectionContentRequestCallback;", "fetchHelpCenterCollections", "collectionRequestCallback", "Lio/intercom/android/sdk/helpcenter/api/CollectionRequestCallback;", "fetchLoggedInUserAttributes", "Lio/intercom/android/sdk/identity/Registration;", "handlePushMessage", "customStack", "Landroid/app/TaskStackBuilder;", "hideIntercom", "isUserLoggedIn", "", "logErrorAndOpenInbox", "error", "logEvent", "name", "metaData", "", "logEventWithValidation", "metadata", "loginIdentifiedUser", "userRegistration", "intercomStatusCallback", "Lio/intercom/android/sdk/IntercomStatusCallback;", "loginUnidentifiedUser", "logout", "noUserRegistered", "openIntercomChatPush", "pushDataString", "performUpdate", "userAttributes", "present", "space", "Lio/intercom/android/sdk/IntercomSpace;", "presentContent", "content", "Lio/intercom/android/sdk/IntercomContent;", "registerIdentifiedUser", "registerUnidentifiedUser", "removeUnreadConversationCountListener", "reset", "searchHelpCenter", "searchTerm", "searchRequestCallback", "Lio/intercom/android/sdk/helpcenter/api/SearchRequestCallback;", "setBottomPadding", "bottomPadding", "setInAppMessageVisibility", "visibility", "Lio/intercom/android/sdk/Intercom$Visibility;", "setLauncherVisibility", "setUserHash", "userHash", "shouldDisableErrorReporting", "softRegister", "updateUser", "Lio/intercom/android/sdk/UserAttributes;", "userIsRegistered", "Companion", "LogLevel", "Visibility", "intercom-sdk-base_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nIntercom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Intercom.kt\nio/intercom/android/sdk/Intercom\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1202:1\n1#2:1203\n*E\n"})
public final class Intercom {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DeDuper superDeDuper;
    @NotNull
    private final Provider<Api> apiProvider;
    @NotNull
    private final NexusClient nexusClient;
    @NotNull
    private final Store<State> store;
    @NotNull
    private final UnreadCountTracker unreadCountTracker;
    @NotNull
    private final MetricTracker metricTracker;
    @NotNull
    private final Application context;
    @NotNull
    private final OverlayPresenter overlayPresenter;
    @NotNull
    private final Provider<AppConfig> appConfigProvider;
    @NotNull
    private final UserIdentity userIdentity;
    @NotNull
    private final SystemNotificationManager systemNotificationManager;
    @NotNull
    private final Provider<UserUpdater> userUpdater;
    @NotNull
    private final ResetManager resetManager;
    @NotNull
    private final Twig twig;
    @NotNull
    private final ActivityFinisher activityFinisher;
    public static final int $stable = 8;
    @JvmField
    @NotNull
    public static final Visibility VISIBLE = Visibility.VISIBLE;
    @JvmField
    @NotNull
    public static final Visibility GONE = Visibility.GONE;
    @NotNull
    public static final String PUSH_RECEIVER = "intercom_sdk";
    private static final Twig TWIG = LumberMill.getLogger();
    @SuppressLint(value={"StaticFieldLeak"})
    @Nullable
    private static Intercom instance;

    @VisibleForTesting
    public Intercom(@NotNull DeDuper superDeDuper, @NotNull Provider<Api> apiProvider, @NotNull NexusClient nexusClient, @NotNull Store<State> store, @NotNull UnreadCountTracker unreadCountTracker, @NotNull MetricTracker metricTracker, @NotNull ErrorReporter errorReporter, @NotNull Application context, @NotNull OverlayPresenter overlayPresenter, @NotNull Provider<AppConfig> appConfigProvider2, @NotNull UserIdentity userIdentity, @NotNull SystemNotificationManager systemNotificationManager, @NotNull Provider<UserUpdater> userUpdater, @NotNull ResetManager resetManager, @NotNull Twig twig, @NotNull ActivityFinisher activityFinisher) {
        Intrinsics.checkNotNullParameter((Object)superDeDuper, (String)"superDeDuper");
        Intrinsics.checkNotNullParameter(apiProvider, (String)"apiProvider");
        Intrinsics.checkNotNullParameter((Object)nexusClient, (String)"nexusClient");
        Intrinsics.checkNotNullParameter(store, (String)"store");
        Intrinsics.checkNotNullParameter((Object)unreadCountTracker, (String)"unreadCountTracker");
        Intrinsics.checkNotNullParameter((Object)metricTracker, (String)"metricTracker");
        Intrinsics.checkNotNullParameter((Object)errorReporter, (String)"errorReporter");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)overlayPresenter, (String)"overlayPresenter");
        Intrinsics.checkNotNullParameter(appConfigProvider2, (String)"appConfigProvider");
        Intrinsics.checkNotNullParameter((Object)userIdentity, (String)"userIdentity");
        Intrinsics.checkNotNullParameter((Object)systemNotificationManager, (String)"systemNotificationManager");
        Intrinsics.checkNotNullParameter(userUpdater, (String)"userUpdater");
        Intrinsics.checkNotNullParameter((Object)resetManager, (String)"resetManager");
        Intrinsics.checkNotNullParameter((Object)twig, (String)"twig");
        Intrinsics.checkNotNullParameter((Object)activityFinisher, (String)"activityFinisher");
        this.superDeDuper = superDeDuper;
        this.apiProvider = apiProvider;
        this.nexusClient = nexusClient;
        this.store = store;
        this.unreadCountTracker = unreadCountTracker;
        this.metricTracker = metricTracker;
        this.context = context;
        this.overlayPresenter = overlayPresenter;
        this.appConfigProvider = appConfigProvider2;
        this.userIdentity = userIdentity;
        this.systemNotificationManager = systemNotificationManager;
        this.userUpdater = userUpdater;
        this.resetManager = resetManager;
        this.twig = twig;
        this.activityFinisher = activityFinisher;
        IntercomPushManager.IntercomPushIntegrationType intercomPushIntegrationType = IntercomPushManager.getInstalledModuleType();
        if ((intercomPushIntegrationType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[intercomPushIntegrationType.ordinal()]) == 1) {
            this.twig.i("Enabling FCM for cloud messaging", new Object[0]);
            IntercomLegacyPushClientHandler.Companion.setUpNotificationChannels(this.systemNotificationManager, (Context)this.context);
            IntercomPushManager.initializeFcmService(this.context);
        } else {
            this.twig.internal("No FCM integration detected");
        }
        if (this.shouldDisableErrorReporting()) {
            errorReporter.disableExceptionHandler();
        } else {
            errorReporter.enableExceptionHandler();
        }
    }

    private final boolean shouldDisableErrorReporting() {
        return this.appConfigProvider.get().hasFeature("disable-error-reporting");
    }

    @JvmOverloads
    public final void present(@NotNull IntercomSpace space) {
        Intrinsics.checkNotNullParameter((Object)((Object)space), (String)"space");
        if (this.noUserRegistered()) {
            TWIG.e("Intercom was presented but there was no user registered on this device.Please call registerUnidentifiedUser() or registerIdentifiedUser(Registration).", new Object[0]);
        } else {
            Injector.get().getMetricTracker().presentAPICall(space);
            switch (WhenMappings.$EnumSwitchMapping$1[space.ordinal()]) {
                case 1: {
                    HelpCenterUrlUtilsKt.openCollections((Context)this.context, CollectionsKt.emptyList(), "api");
                    break;
                }
                case 2: {
                    IntercomRootActivityLauncher.INSTANCE.startHome((Context)this.context);
                    break;
                }
                case 3: {
                    IntercomRootActivityLauncher.INSTANCE.startMessages((Context)this.context);
                    break;
                }
                case 4: {
                    IntercomRootActivityLauncher.INSTANCE.startTickets((Context)this.context);
                }
            }
        }
    }

    public static /* synthetic */ void present$default(Intercom intercom, IntercomSpace intercomSpace, int n, Object object) {
        if ((n & 1) != 0) {
            intercomSpace = IntercomSpace.Home;
        }
        intercom.present(intercomSpace);
    }

    public final void presentContent(@NotNull IntercomContent content) {
        IntercomContent intercomContent;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (!Injector.isNotInitialised() && !this.noUserRegistered()) {
            Injector.get().getMetricTracker().presentContentAPICall(content);
        }
        if ((intercomContent = content) instanceof IntercomContent.Article) {
            this.context.startActivity(ArticleActivity.Companion.buildIntent((Context)this.context, new ArticleActivity.ArticleActivityArguments(((IntercomContent.Article)content).getId(), "api", false, false, 12, null)));
        } else if (intercomContent instanceof IntercomContent.Carousel) {
            this.context.startActivity(IntercomCarouselActivity.buildIntent((Context)this.context, ((IntercomContent.Carousel)content).getId()));
        } else if (intercomContent instanceof IntercomContent.Survey) {
            this.context.startActivity(IntercomSurveyActivity.Companion.buildIntent((Context)this.context, ((IntercomContent.Survey)content).getId()));
        } else if (intercomContent instanceof IntercomContent.HelpCenterCollections) {
            HelpCenterUrlUtilsKt.openCollections((Context)this.context, ((IntercomContent.HelpCenterCollections)content).getIds(), "api");
        } else if (intercomContent instanceof IntercomContent.Conversation) {
            ConversationScreenOpenerKt.openComposer$default((Context)this.context, "", true, null, ((IntercomContent.Conversation)content).getId(), 8, null);
        } else if (intercomContent instanceof IntercomContent.Ticket) {
            IntercomRootActivityLauncher.INSTANCE.startTicketDetails((Context)this.context, ((IntercomContent.Ticket)content).getId(), "from_programmatic");
        }
    }

    @Deprecated(message="Use loginUnidentifiedUser instead.", replaceWith=@ReplaceWith(expression="loginUnidentifiedUser()", imports={}), level=DeprecationLevel.WARNING)
    public final void registerUnidentifiedUser() {
        this.metricTracker.registerUnidentifiedUserAPICall();
        this.loginUnidentifiedUser(IntercomStatusCallbackKt.getNoStatusCallback());
    }

    public final void loginUnidentifiedUser(@NotNull IntercomStatusCallback intercomStatusCallback) {
        Intrinsics.checkNotNullParameter((Object)intercomStatusCallback, (String)"intercomStatusCallback");
        this.metricTracker.loginUnidentifiedUserAPICall();
        if (this.userIdentity.canRegisterUnidentifiedUser()) {
            this.resetManager.hardReset();
            this.userIdentity.registerUnidentifiedUser();
            this.nexusClient.disconnect();
            Boolean isBackgrounded = this.store.select(Selectors.APP_IS_BACKGROUNDED);
            boolean newSession = this.store.select(Selectors.SESSION_STARTED_SINCE_LAST_BACKGROUNDED) == false;
            Intrinsics.checkNotNull((Object)isBackgrounded);
            UserUpdateRequest userUpdateRequest = UserUpdateRequest.create(newSession, isBackgrounded, true);
            this.userUpdater.get().updateUser(userUpdateRequest, intercomStatusCallback);
        } else {
            intercomStatusCallback.onFailure(new IntercomError(3002, "Failed to register user. We already have a registered user. If you are attempting to register a new user, call logout() before this. If you are attempting to register an identified user call: registerIdentifiedUser(Registration)"));
        }
    }

    public static /* synthetic */ void loginUnidentifiedUser$default(Intercom intercom, IntercomStatusCallback intercomStatusCallback, int n, Object object) {
        if ((n & 1) != 0) {
            intercomStatusCallback = IntercomStatusCallbackKt.getNoStatusCallback();
        }
        intercom.loginUnidentifiedUser(intercomStatusCallback);
    }

    @Deprecated(message="Use loginIdentifiedUser with callback instead.", replaceWith=@ReplaceWith(expression="loginIdentifiedUser(userRegistration)", imports={}), level=DeprecationLevel.WARNING)
    public final void registerIdentifiedUser(@Nullable Registration userRegistration) {
        this.metricTracker.registerIdentifiedUserAPICall();
        if (userRegistration == null) {
            LumberMill.getLogger().e("The registration object passed is null. An example successful call is registerIdentifiedUser(Registration.create().withEmail(email));", new Object[0]);
            return;
        }
        this.loginIdentifiedUser(userRegistration, IntercomStatusCallbackKt.getNoStatusCallback());
    }

    public final void loginIdentifiedUser(@NotNull Registration userRegistration, @NotNull IntercomStatusCallback intercomStatusCallback) {
        Intrinsics.checkNotNullParameter((Object)userRegistration, (String)"userRegistration");
        Intrinsics.checkNotNullParameter((Object)intercomStatusCallback, (String)"intercomStatusCallback");
        this.metricTracker.loginIdentifiedUserAPICall();
        String string2 = userRegistration.getUserId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUserId(...)");
        if (((CharSequence)string2).length() == 0) {
            String string3 = userRegistration.getEmail();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getEmail(...)");
            if (((CharSequence)string3).length() == 0) {
                intercomStatusCallback.onFailure(new IntercomError(1007, "Failed to register user. You need to provide unique user identifier, an email address, or both."));
                return;
            }
        }
        if (Intrinsics.areEqual((Object)userRegistration.getEmail(), (Object)this.userIdentity.getEmail()) && Intrinsics.areEqual((Object)userRegistration.getUserId(), (Object)this.userIdentity.getUserId())) {
            this.twig.i("The user is already registered with the same email and user id", new Object[0]);
            if (this.userIdentity.registrationHasAttributes(userRegistration)) {
                UserAttributes userAttributes = userRegistration.getAttributes();
                Map map2 = userAttributes != null ? userAttributes.toMap() : null;
                if (map2 == null) {
                    map2 = MapsKt.emptyMap();
                }
                this.performUpdate(map2, intercomStatusCallback);
            } else {
                intercomStatusCallback.onSuccess();
            }
            return;
        }
        if (this.userIsRegistered(userRegistration)) {
            this.softRegister();
            intercomStatusCallback.onSuccess();
        } else {
            this.resetManager.hardReset();
            if (this.userIdentity.canRegisterIdentifiedUser(userRegistration)) {
                UserUpdateRequest userUpdateRequest;
                UserUpdateRequest userUpdateRequest2;
                this.userIdentity.registerIdentifiedUser(userRegistration);
                this.nexusClient.disconnect();
                boolean newSession = this.store.select(Selectors.SESSION_STARTED_SINCE_LAST_BACKGROUNDED) == false;
                Boolean isInBackground = this.store.select(Selectors.APP_IS_BACKGROUNDED);
                if (userRegistration.getAttributes() != null) {
                    Intrinsics.checkNotNull((Object)isInBackground);
                    boolean bl = isInBackground;
                    UserAttributes userAttributes = userRegistration.getAttributes();
                    Intrinsics.checkNotNull((Object)userAttributes);
                    userUpdateRequest2 = UserUpdateRequest.create(newSession, bl, userAttributes.toMap(), true);
                    Intrinsics.checkNotNull((Object)userUpdateRequest2);
                    userUpdateRequest = userUpdateRequest2;
                } else {
                    Intrinsics.checkNotNull((Object)isInBackground);
                    userUpdateRequest2 = UserUpdateRequest.create(newSession, isInBackground, true);
                    Intrinsics.checkNotNull((Object)userUpdateRequest2);
                    userUpdateRequest = userUpdateRequest2;
                }
                UserUpdateRequest update = userUpdateRequest;
                this.userUpdater.get().updateUser(update, intercomStatusCallback);
            } else if (this.userIdentity.registrationHasAttributes(userRegistration)) {
                this.twig.i("We already have a registered user. Updating this user with the attributes provided.", new Object[0]);
                UserAttributes userAttributes = userRegistration.getAttributes();
                Map map3 = userAttributes != null ? userAttributes.toMap() : null;
                if (map3 == null) {
                    map3 = MapsKt.emptyMap();
                }
                this.performUpdate(map3, intercomStatusCallback);
            } else {
                intercomStatusCallback.onFailure(new IntercomError(3002, "ERROR - Failed to register user. We already have a registered user. If you are attempting to register a new user, call logout() before this."));
            }
        }
    }

    public static /* synthetic */ void loginIdentifiedUser$default(Intercom intercom, Registration registration, IntercomStatusCallback intercomStatusCallback, int n, Object object) {
        if ((n & 2) != 0) {
            intercomStatusCallback = IntercomStatusCallbackKt.getNoStatusCallback();
        }
        intercom.loginIdentifiedUser(registration, intercomStatusCallback);
    }

    public final boolean isUserLoggedIn() {
        return this.userIdentity.identityExists();
    }

    @Nullable
    public final Registration fetchLoggedInUserAttributes() {
        UserIdentity userIdentity;
        UserIdentity userIdentity2;
        UserIdentity it = userIdentity2 = this.userIdentity;
        boolean bl = false;
        UserIdentity userIdentity3 = userIdentity = it.identityExists() ? userIdentity2 : null;
        if (userIdentity != null) {
            it = userIdentity;
            boolean bl2 = false;
            Registration registration = new Registration();
            CharSequence charSequence = it.getUserId();
            if (!(charSequence == null || charSequence.length() == 0)) {
                registration.withUserId(it.getUserId());
            }
            if (!((charSequence = (CharSequence)it.getEmail()) == null || charSequence.length() == 0)) {
                registration.withEmail(it.getEmail());
            }
            if (!((charSequence = (CharSequence)it.getAnonymousId()) == null || charSequence.length() == 0)) {
                registration.withUserId(it.getAnonymousId());
            }
            return registration;
        }
        return null;
    }

    private final boolean userIsRegistered(Registration userRegistration) {
        return this.userIdentity.isSoftReset() && this.userIdentity.isSameUser(userRegistration);
    }

    private final void softRegister() {
        this.nexusClient.connect(this.appConfigProvider.get().getRealTimeConfig(), true);
        this.userIdentity.softRestart();
        this.resetManager.clear();
        Runnable runnable = () -> Intercom.softRegister$lambda$2(this);
        if (Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper())) {
            runnable.run();
        } else {
            new Handler(Looper.getMainLooper()).post(runnable);
        }
    }

    public final void setUserHash(@NotNull String userHash) {
        Intrinsics.checkNotNullParameter((Object)userHash, (String)"userHash");
        this.metricTracker.setUserHashAPICall();
        if (((CharSequence)userHash).length() == 0) {
            this.twig.w("The user hash you sent us to verify was empty, we will not be able to authenticate your requests without a valid user hash.", new Object[0]);
        } else if (Intrinsics.areEqual((Object)this.userIdentity.getHmac(), (Object)userHash)) {
            this.twig.i("The user hash set matches the existing user identity hash value", new Object[0]);
        } else {
            if (this.userIdentity.softUserIdentityHmacDiffers(userHash)) {
                this.resetManager.hardReset();
            }
            this.userIdentity.setUserHash(userHash);
        }
    }

    @Deprecated(message="Use updateUser with callback instead.", replaceWith=@ReplaceWith(expression="updateUser(userAttributes, statusCallback)", imports={}), level=DeprecationLevel.WARNING)
    public final void updateUser(@Nullable UserAttributes userAttributes) {
        this.metricTracker.updateUserAPICall();
        if (userAttributes == null) {
            LumberMill.getLogger().e("updateUser method failed: the UserAttributes object provided is null", new Object[0]);
        } else {
            this.updateUser(userAttributes, IntercomStatusCallbackKt.getNoStatusCallback());
        }
    }

    public final void updateUser(@NotNull UserAttributes userAttributes, @NotNull IntercomStatusCallback intercomStatusCallback) {
        Intrinsics.checkNotNullParameter((Object)userAttributes, (String)"userAttributes");
        Intrinsics.checkNotNullParameter((Object)intercomStatusCallback, (String)"intercomStatusCallback");
        this.metricTracker.updateUserCallbackAPICall();
        Map<String, Object> map2 = userAttributes.toMap();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"toMap(...)");
        this.performUpdate(map2, intercomStatusCallback);
    }

    public static /* synthetic */ void updateUser$default(Intercom intercom, UserAttributes userAttributes, IntercomStatusCallback intercomStatusCallback, int n, Object object) {
        if ((n & 2) != 0) {
            intercomStatusCallback = IntercomStatusCallbackKt.getNoStatusCallback();
        }
        intercom.updateUser(userAttributes, intercomStatusCallback);
    }

    private final void performUpdate(Map<String, ? extends Object> userAttributes, IntercomStatusCallback intercomStatusCallback) {
        if (this.userIdentity.isUnidentified()) {
            AttributeSanitiser.anonymousSanitisation(userAttributes);
        }
        if (this.superDeDuper.shouldUpdateUser(userAttributes)) {
            this.superDeDuper.update(userAttributes);
            Boolean isBackgrounded = this.store.select(Selectors.APP_IS_BACKGROUNDED);
            Intrinsics.checkNotNull((Object)isBackgrounded);
            UserUpdateRequest userUpdateRequest = UserUpdateRequest.create(false, isBackgrounded, userAttributes, false);
            this.userUpdater.get().updateUser(userUpdateRequest, intercomStatusCallback);
            this.twig.internal("dupe", "updated user");
        } else {
            intercomStatusCallback.onSuccess();
            this.twig.internal("dupe", "dropped dupe");
        }
    }

    public final void logEvent(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.metricTracker.logEventAPICall();
        this.logEventWithValidation(name, MapsKt.emptyMap());
    }

    public final void logEvent(@Nullable String name, @Nullable Map<String, ?> metaData) {
        this.metricTracker.logEventMetadataAPICall();
        if (metaData == null) {
            this.twig.i("The metadata provided is null, logging event with no metadata", new Object[0]);
        } else if (metaData.isEmpty()) {
            this.twig.i("The metadata provided is empty, logging event with no metadata", new Object[0]);
        }
        Map<String, ?> map2 = metaData;
        Map map3 = map2 != null ? MapsKt.toMap(map2) : null;
        if (map3 == null) {
            map3 = MapsKt.emptyMap();
        }
        this.logEventWithValidation(name, map3);
    }

    private final void logEventWithValidation(String name, Map<String, ?> metadata) {
        CharSequence charSequence = name;
        if (charSequence == null || charSequence.length() == 0) {
            this.twig.e("The event name is null or empty. We can't log an event with this string.", new Object[0]);
        } else {
            this.apiProvider.get().logEvent(name, metadata);
        }
    }

    @Deprecated(message="Use present() instead.")
    public final void displayMessenger() {
        this.metricTracker.displayMessengerAPICall();
        if (this.noUserRegistered()) {
            this.logErrorAndOpenInbox("The messenger was opened but there was no user registered on this device.Please call registerUnidentifiedUser() or registerIdentifiedUser(Registration).");
        } else {
            new LauncherOpenBehaviour().openMessenger((Context)this.context);
        }
    }

    public final void displayMessageComposer() {
        this.metricTracker.displayMessageComposerAPICall();
        this.displayMessageComposer("");
    }

    public final void displayMessageComposer(@Nullable String initialMessage) {
        CharSequence charSequence = initialMessage;
        if (!(charSequence == null || charSequence.length() == 0)) {
            this.metricTracker.displayMessageComposerInitialMessageAPICall();
        }
        if (this.noUserRegistered()) {
            this.logErrorAndOpenInbox("The messenger was opened but there was no user registered on this device. Please call registerUnidentifiedUser() or registerIdentifiedUser(Registration).");
        } else if (!this.appConfigProvider.get().isReceivedFromServer()) {
            this.logErrorAndOpenInbox("It appears your app has not received a successful response from Intercom. Please check if you are using the correct Android app ID and API Key from the Intercom settings.");
        } else if (!this.appConfigProvider.get().isInboundMessages()) {
            this.logErrorAndOpenInbox("It appears your app is not on a plan that allows message composing. As a fallback we are calling present(IntercomSpace.Messages)");
        } else {
            this.metricTracker.openedMessengerNewConversation(LauncherOpenBehaviour.LauncherType.CUSTOM);
            Context context = (Context)this.context;
            String string2 = initialMessage;
            if (string2 == null) {
                string2 = "";
            }
            ConversationScreenOpenerKt.openComposer$default(context, string2, true, null, null, 24, null);
        }
    }

    private final boolean noUserRegistered() {
        return !this.userIdentity.identityExists() || this.userIdentity.isSoftReset();
    }

    private final void logErrorAndOpenInbox(String error) {
        this.twig.e(error, new Object[0]);
        this.present(IntercomSpace.Messages);
    }

    @Deprecated(message="Use present(IntercomSpace.Messages) instead.")
    public final void displayConversationsList() {
        this.metricTracker.displayConversationsListAPICall();
        this.metricTracker.openedMessengerConversationList(LauncherOpenBehaviour.LauncherType.CUSTOM);
        IntercomRootActivityLauncher.INSTANCE.startMessages((Context)this.context);
    }

    @Deprecated(message="Use present(IntercomSpace.HelpCenter) instead.")
    public final void displayHelpCenter() {
        this.metricTracker.displayHelpCenterAPICall();
        this.displayHelpCenterCollections(CollectionsKt.emptyList());
    }

    @Deprecated(message="Use presentContent(IntercomContent.HelpCenterCollections(ids)) instead.")
    public final void displayHelpCenterCollections(@Nullable List<String> collectionIds) {
        this.metricTracker.displayHelpCenterCollectionsAPICall();
        Context context = (Context)this.context;
        List<String> list = collectionIds;
        List list2 = list != null ? CollectionsKt.filterNotNull((Iterable)list) : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        HelpCenterUrlUtilsKt.openCollections(context, list2, "api");
    }

    @Deprecated(message="Use presentContent(IntercomContent.Carousel(id)) instead.")
    public final void displayCarousel(@Nullable String carouselId) {
        this.metricTracker.displayCarouselAPICall();
        this.context.startActivity(IntercomCarouselActivity.buildIntent((Context)this.context, carouselId));
    }

    @Deprecated(message="Use presentContent(IntercomContent.Survey(id)) instead.")
    public final void displaySurvey(@NotNull String surveyId) {
        Intrinsics.checkNotNullParameter((Object)surveyId, (String)"surveyId");
        this.metricTracker.displaySurveyAPICall();
        this.context.startActivity(IntercomSurveyActivity.Companion.buildIntent((Context)this.context, surveyId));
    }

    public final void setBottomPadding(int bottomPadding) {
        this.metricTracker.setBottomPaddingAPICall();
        this.store.dispatch(Actions.setBottomPadding(bottomPadding));
    }

    public final void setInAppMessageVisibility(@Nullable Visibility visibility) {
        this.metricTracker.setInAppMessageVisibilityAPICall();
        this.store.dispatch(Actions.setInAppNotificationVisibility(visibility));
    }

    public final void setLauncherVisibility(@Nullable Visibility visibility) {
        this.metricTracker.setLauncherVisibilityAPICall();
        this.store.dispatch(Actions.setLauncherVisibility(visibility));
    }

    public final void hideIntercom() {
        this.metricTracker.hideIntercomAPICall();
        this.activityFinisher.finishActivities();
    }

    public final void handlePushMessage() {
        this.metricTracker.handlePushMessageAPICall();
        this.handlePushMessage(null);
    }

    public final void handlePushMessage(@Nullable TaskStackBuilder customStack) {
        SharedPreferences preferences;
        String pushDataString;
        CharSequence charSequence;
        if (customStack != null) {
            this.metricTracker.handlePushMessageCustomStackAPICall();
        }
        if ((charSequence = (CharSequence)(pushDataString = (preferences = this.context.getSharedPreferences("INTERCOM_SDK_PUSH_PREFS", 0)).getString("intercom_push_notification_path", ""))) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            this.twig.internal("No Uri found");
        } else {
            this.openIntercomChatPush(pushDataString, customStack);
            preferences.edit().clear().apply();
        }
    }

    private final void openIntercomChatPush(String pushDataString, TaskStackBuilder customStack) {
        if (Intrinsics.areEqual((Object)pushDataString, (Object)"multiple_notifications")) {
            IntercomRootActivityLauncher.INSTANCE.startMessages((Context)this.context);
        } else {
            Intent conversationScreenIntent = ConversationScreenOpenerKt.getConversationIntent$default((Context)this.context, pushDataString, false, 4, null);
            if (customStack != null) {
                customStack.addNextIntent(conversationScreenIntent);
                this.context.startActivities(customStack.getIntents());
            } else {
                this.context.startActivity(conversationScreenIntent);
            }
        }
        this.metricTracker.viewedPushNotification(pushDataString);
        IntercomLegacyPushClientHandler.Companion.clear(this.systemNotificationManager, (Context)this.context);
    }

    @Deprecated(message="call {@link #logout()} instead")
    public final void reset() {
        this.metricTracker.resetAPICall();
        this.logout();
    }

    public final void logout() {
        this.metricTracker.logoutAPICall();
        if (!this.userIdentity.isSoftReset()) {
            this.resetManager.softReset();
        }
    }

    public final int getUnreadConversationCount() {
        this.metricTracker.unreadConversationCountAPICall();
        return this.store.state().unreadConversationIds().size();
    }

    public final void addUnreadConversationCountListener(@NotNull UnreadConversationCountListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.metricTracker.addUnreadConversationCountListenerAPICall();
        this.unreadCountTracker.addListener(listener2);
    }

    public final void removeUnreadConversationCountListener(@Nullable UnreadConversationCountListener listener2) {
        block0: {
            this.metricTracker.removeUnreadConversationCountListenerAPICall();
            UnreadConversationCountListener unreadConversationCountListener = listener2;
            if (unreadConversationCountListener == null) break block0;
            UnreadConversationCountListener unreadConversationCountListener2 = unreadConversationCountListener;
            UnreadCountTracker unreadCountTracker = this.unreadCountTracker;
            UnreadConversationCountListener p0 = unreadConversationCountListener2;
            boolean bl = false;
            unreadCountTracker.removeListener(p0);
        }
    }

    @Deprecated(message="Use presentContent(IntercomContent.Article(id)) instead.")
    public final void displayArticle(@NotNull String articleId) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        this.metricTracker.displayArticleAPICall();
        Intent intent = ArticleActivity.Companion.buildIntent((Context)this.context, new ArticleActivity.ArticleActivityArguments(articleId, "api", false, false, 12, null));
        this.context.startActivity(intent);
    }

    public final void fetchHelpCenterCollections(@Nullable CollectionRequestCallback collectionRequestCallback) {
        this.metricTracker.fetchHelpCenterCollectionsAPICall();
        CollectionRequestCallback collectionRequestCallback2 = collectionRequestCallback;
        Intrinsics.checkNotNull((Object)collectionRequestCallback2);
        HelpCenterApiWrapper.INSTANCE.fetchHelpCenterCollections(this.metricTracker, collectionRequestCallback2);
    }

    public final void fetchHelpCenterCollection(@Nullable String collectionId, @Nullable CollectionContentRequestCallback collectionContentRequestCallback) {
        this.metricTracker.fetchHelpCenterCollectionAPICall();
        String string2 = collectionId;
        Intrinsics.checkNotNull((Object)string2);
        CollectionContentRequestCallback collectionContentRequestCallback2 = collectionContentRequestCallback;
        Intrinsics.checkNotNull((Object)collectionContentRequestCallback2);
        HelpCenterApiWrapper.INSTANCE.fetchHelpCenterCollection(this.metricTracker, string2, collectionContentRequestCallback2);
    }

    public final void searchHelpCenter(@Nullable String searchTerm, @Nullable SearchRequestCallback searchRequestCallback) {
        this.metricTracker.searchHelpCenterAPICall();
        String string2 = searchTerm;
        Intrinsics.checkNotNull((Object)string2);
        SearchRequestCallback searchRequestCallback2 = searchRequestCallback;
        Intrinsics.checkNotNull((Object)searchRequestCallback2);
        HelpCenterApiWrapper.INSTANCE.fetchHelpCenterResultsForSearchTerm(this.metricTracker, string2, searchRequestCallback2);
    }

    @JvmOverloads
    public final void present() {
        Intercom.present$default(this, null, 1, null);
    }

    private static final void softRegister$lambda$2(Intercom this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.overlayPresenter.refreshStateBecauseUserIdentityIsNotInStoreYet();
    }

    @JvmStatic
    public static final synchronized void initialize(@Nullable Application application, @Nullable String apiKey, @Nullable String appId) {
        Companion.initialize(application, apiKey, appId);
    }

    @JvmStatic
    public static final synchronized void registerForLaterInitialisation(@Nullable Application application) {
        Companion.registerForLaterInitialisation(application);
    }

    @JvmStatic
    public static final void unregisterForLateInitialisation(@Nullable Application application) {
        Companion.unregisterForLateInitialisation(application);
    }

    @JvmStatic
    @NotNull
    public static final synchronized Intercom client() {
        return Companion.client();
    }

    @JvmStatic
    public static final void setLogLevel(@LogLevel int logLevel) {
        Companion.setLogLevel(logLevel);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\fH\u0007J$\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u0002J&\u0010\u0013\u001a\u00020\u00142\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u0007J\u0012\u0010\u0015\u001a\u00020\u00142\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J\u0012\u0010\u0016\u001a\u00020\u00142\b\b\u0001\u0010\u0017\u001a\u00020\u0018H\u0007J\u0012\u0010\u0019\u001a\u00020\u00142\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/intercom/android/sdk/Intercom$Companion;", "", "()V", "GONE", "Lio/intercom/android/sdk/Intercom$Visibility;", "PUSH_RECEIVER", "", "TWIG", "Lcom/intercom/twig/Twig;", "kotlin.jvm.PlatformType", "VISIBLE", "instance", "Lio/intercom/android/sdk/Intercom;", "client", "create", "application", "Landroid/app/Application;", "apiKey", "appId", "initialize", "", "registerForLaterInitialisation", "setLogLevel", "logLevel", "", "unregisterForLateInitialisation", "intercom-sdk-base_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final synchronized void initialize(@Nullable Application application, @Nullable String apiKey, @Nullable String appId) {
            if (instance != null) {
                TWIG.i("Intercom has already been initialized", new Object[0]);
                return;
            }
            if (ValidatorUtil.isValidConstructorParams(application, apiKey, appId)) {
                Application application2 = application;
                Intrinsics.checkNotNull((Object)application2);
                instance = this.create(application2, apiKey, appId);
                LateInitializationPreparer.getInstance().handlePastLifecycleEvents(application, Injector.get());
                Injector.get().getMetricTracker().initialiseAPICall();
            } else {
                TWIG.e("Intercom has been initialized incorrectly. Please make sure that you're passing in the correct app ID and API key", new Object[0]);
            }
        }

        @JvmStatic
        public final synchronized void registerForLaterInitialisation(@Nullable Application application) {
            if (instance != null) {
                TWIG.i("Intercom has already been initialized", new Object[0]);
                return;
            }
            if (application == null) {
                throw new NullPointerException("Cannot call registerForLaterInitialisation() with a null Application");
            }
            LateInitializationPreparer.getInstance().register(application);
        }

        @JvmStatic
        public final void unregisterForLateInitialisation(@Nullable Application application) {
            Injector.get().getMetricTracker().unRegisterForLateInitialisationAPICall();
            if (application == null) {
                throw new NullPointerException("Cannot call unregisterForLateInitialisation() with a null Application");
            }
            LateInitializationPreparer.getInstance().unregister(application);
        }

        @JvmStatic
        @NotNull
        public final synchronized Intercom client() {
            Intercom intercom = instance;
            if (intercom == null) {
                boolean bl = false;
                String string = "Intercom has been initialized incorrectly. Please make sure the first Intercom method you call is initialize() and that you're passing in the correct app ID and API key";
                throw new IllegalStateException(string.toString());
            }
            return intercom;
        }

        @JvmStatic
        public final void setLogLevel(@LogLevel int logLevel) {
            Injector.get().getMetricTracker().setLogLevelAPICall();
            LumberMill.setLogLevel(logLevel);
        }

        private final Intercom create(Application application, String apiKey, String appId) {
            Injector.initWithAppCredentials(application, apiKey, appId);
            Injector injector2 = Injector.get();
            UserIdentity userIdentity = injector2.getUserIdentity();
            Store<State> store = injector2.getStore();
            DeDuper deDuper = injector2.getDeDuper();
            Intrinsics.checkNotNullExpressionValue((Object)deDuper, (String)"getDeDuper(...)");
            Provider<Api> provider = injector2.getApiProvider();
            Intrinsics.checkNotNullExpressionValue(provider, (String)"getApiProvider(...)");
            NexusClient nexusClient = injector2.getNexusClient();
            Intrinsics.checkNotNullExpressionValue((Object)nexusClient, (String)"getNexusClient(...)");
            Intrinsics.checkNotNull(store);
            UnreadCountTracker unreadCountTracker = new UnreadCountTracker(store);
            MetricTracker metricTracker = injector2.getMetricTracker();
            Intrinsics.checkNotNullExpressionValue((Object)metricTracker, (String)"getMetricTracker(...)");
            ErrorReporter errorReporter = injector2.getErrorReporter();
            Intrinsics.checkNotNullExpressionValue((Object)errorReporter, (String)"getErrorReporter(...)");
            OverlayPresenter overlayPresenter = injector2.getOverlayPresenter();
            Intrinsics.checkNotNullExpressionValue((Object)overlayPresenter, (String)"getOverlayPresenter(...)");
            Provider<AppConfig> provider2 = injector2.getAppConfigProvider();
            Intrinsics.checkNotNullExpressionValue(provider2, (String)"getAppConfigProvider(...)");
            Intrinsics.checkNotNull((Object)userIdentity);
            SystemNotificationManager systemNotificationManager = injector2.getSystemNotificationManager();
            Intrinsics.checkNotNullExpressionValue((Object)systemNotificationManager, (String)"getSystemNotificationManager(...)");
            Provider<UserUpdater> provider3 = injector2.getUserUpdaterProvider();
            Intrinsics.checkNotNullExpressionValue(provider3, (String)"getUserUpdaterProvider(...)");
            ResetManager resetManager = injector2.getResetManager();
            Intrinsics.checkNotNullExpressionValue((Object)resetManager, (String)"getResetManager(...)");
            Twig twig = LumberMill.getLogger();
            Intrinsics.checkNotNullExpressionValue((Object)twig, (String)"getLogger(...)");
            ActivityFinisher activityFinisher = injector2.getActivityFinisher();
            Intrinsics.checkNotNullExpressionValue((Object)activityFinisher, (String)"getActivityFinisher(...)");
            return new Intercom(deDuper, provider, nexusClient, store, unreadCountTracker, metricTracker, errorReporter, application, overlayPresenter, provider2, userIdentity, systemNotificationManager, provider3, resetManager, twig, activityFinisher);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0002\b\u0002\b\u0086\u0002\u0018\u0000 \u00022\u00020\u0001:\u0001\u0002B\u0000\u00a8\u0006\u0003"}, d2={"Lio/intercom/android/sdk/Intercom$LogLevel;", "", "Companion", "intercom-sdk-base_release"})
    public static @interface LogLevel {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;
        public static final int VERBOSE = 2;
        public static final int DEBUG = 3;
        public static final int INFO = 4;
        public static final int WARN = 5;
        public static final int ERROR = 6;
        public static final int ASSERT = 7;
        public static final int DISABLED = 8;

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/intercom/android/sdk/Intercom$LogLevel$Companion;", "", "()V", "ASSERT", "", "DEBUG", "DISABLED", "ERROR", "INFO", "VERBOSE", "WARN", "intercom-sdk-base_release"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            public static final int VERBOSE = 2;
            public static final int DEBUG = 3;
            public static final int INFO = 4;
            public static final int WARN = 5;
            public static final int ERROR = 6;
            public static final int ASSERT = 7;
            public static final int DISABLED = 8;

            private Companion() {
            }

            static {
                $$INSTANCE = new Companion();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lio/intercom/android/sdk/Intercom$Visibility;", "", "(Ljava/lang/String;I)V", "GONE", "VISIBLE", "intercom-sdk-base_release"})
    public static final class Visibility
    extends Enum<Visibility> {
        public static final /* enum */ Visibility GONE = new Visibility();
        public static final /* enum */ Visibility VISIBLE = new Visibility();
        private static final /* synthetic */ Visibility[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Visibility[] values() {
            return (Visibility[])$VALUES.clone();
        }

        public static Visibility valueOf(String value2) {
            return Enum.valueOf(Visibility.class, value2);
        }

        @NotNull
        public static EnumEntries<Visibility> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = visibilityArray = new Visibility[]{Visibility.GONE, Visibility.VISIBLE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[IntercomPushManager.IntercomPushIntegrationType.values().length];
            try {
                nArray[IntercomPushManager.IntercomPushIntegrationType.FCM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[IntercomSpace.values().length];
            try {
                nArray[IntercomSpace.HelpCenter.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IntercomSpace.Home.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IntercomSpace.Messages.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IntercomSpace.Tickets.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

