/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.Nullable;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.logger.LumberMill;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class IntercomPushManager {
    private static final String PREFS_SENDER_ID = "intercom_sender_id";
    public static final String MULTIPLE_NOTIFICATIONS = "multiple_notifications";
    public static final String PUSH_ONLY_CONVO_ID = "push_only_convo_id";
    public static final String PUSH_ONLY_INSTANCE_ID = "push_only_instance_id";
    public static final String INTERCOM_PUSH_KEY = "intercom_push_key";
    public static final String HOST_APP_INTENT = "host_app_intent";
    public static final String INTERCOM_PUSH_PATH = "intercom_push_notification_path";
    private static final Twig TWIG = LumberMill.getLogger();

    public static IntercomPushIntegrationType getInstalledModuleType() {
        IntercomPushIntegrationType integrationType = IntercomPushIntegrationType.NONE;
        if (IntercomPushManager.fcmModuleInstalled()) {
            TWIG.internal("FCM is installed");
            integrationType = IntercomPushIntegrationType.FCM;
        }
        return integrationType;
    }

    public static void initializeFcmService(Application application) {
        Class fcmServiceClass = IntercomPushManager.getFcmServiceClass();
        if (fcmServiceClass != null) {
            try {
                Method initialize = fcmServiceClass.getDeclaredMethod("initialize", Application.class);
                initialize.invoke(null, application);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                TWIG.internal("FCM is installed but initialize method was not found");
            }
        }
    }

    private static boolean fcmModuleInstalled() {
        return IntercomPushManager.getFcmServiceClass() != null;
    }

    public static void cacheSenderId(Context context, String senderId) {
        SharedPreferences prefs = context.getSharedPreferences("INTERCOM_SDK_PREFS", 0);
        prefs.edit().putString(PREFS_SENDER_ID, senderId).apply();
    }

    @Nullable
    private static Class getFcmServiceClass() {
        try {
            return Class.forName("io.intercom.android.sdk.fcm.IntercomFcmMessengerService");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static enum IntercomPushIntegrationType {
        FCM,
        NONE;

    }
}

