/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.app.Activity;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.VisibleForTesting;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;

class ActivityLifecycleHandler
extends Handler {
    static final int RESUMED_CODE = 0;
    static final int READY_FOR_VIEW_CODE = 1;
    static final int PAUSED_CODE = 2;
    static final int STOPPED_CODE = 3;
    private static final int ESTIMATED_ACTIVITY_TRANSITION_DURATION_MS = 500;
    private final Store<State> store;
    private final long readyForViewDelayMs;

    ActivityLifecycleHandler(Looper looper, Store<State> store, float transitionScale) {
        super(looper);
        this.store = store;
        this.readyForViewDelayMs = (long)(transitionScale * 500.0f);
    }

    public void handleMessage(Message msg) {
        Activity activity = (Activity)msg.obj;
        switch (msg.what) {
            case 0: {
                this.sendMessageAfterDelay(ActivityLifecycleHandler.getMessage(1, activity), this.readyForViewDelayMs);
                break;
            }
            case 1: {
                this.store.dispatch(Actions.activityReadyForViewAttachment(activity));
                break;
            }
            case 2: {
                this.store.dispatch(Actions.activityPaused(activity));
                break;
            }
            case 3: {
                this.store.dispatch(Actions.activityStopped(activity));
                break;
            }
        }
    }

    @VisibleForTesting
    void sendMessageAfterDelay(Message message, long delayMs) {
        this.sendMessageDelayed(message, delayMs);
    }

    static Message getMessage(int code, Activity activity) {
        Message message = Message.obtain();
        message.what = code;
        message.obj = activity;
        return message;
    }
}

