/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.push.ui;

import android.app.Notification;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.text.SpannableStringBuilder;
import android.text.SpannedString;
import android.text.style.StyleSpan;
import androidx.core.app.NotificationCompat;
import androidx.core.app.Person;
import androidx.core.content.pm.ShortcutInfoCompat;
import androidx.core.graphics.drawable.IconCompat;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.m5.push.ConversationActionHandlerKt;
import io.intercom.android.sdk.m5.push.ConversationDeepLinkRouterKt;
import io.intercom.android.sdk.m5.push.IntercomPushData;
import io.intercom.android.sdk.m5.push.NotificationChannel;
import io.intercom.android.sdk.m5.push.ui.BasePushUIKt;
import io.intercom.android.sdk.m5.push.ui.BubbleMetaDataKt;
import io.intercom.android.sdk.m5.push.ui.IntercomPushConversation;
import io.intercom.android.sdk.utilities.Phrase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a:\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a&\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0018\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0003H\u0002\u001a,\u0010\u0017\u001a\u00020\u0018*\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"KEY_GROUP_CONVERSATION", "", "SUMMARY_NOTIFICATION_ID", "", "buildConversationStyleNotification", "Landroid/app/Notification;", "context", "Landroid/content/Context;", "conversation", "Lio/intercom/android/sdk/m5/push/ui/IntercomPushConversation;", "shortcutInfo", "Landroidx/core/content/pm/ShortcutInfoCompat;", "conversationPushData", "Lio/intercom/android/sdk/m5/push/IntercomPushData$ConversationPushData;", "notificationChannel", "Lio/intercom/android/sdk/m5/push/NotificationChannel;", "isSilent", "", "buildConversationStyleSummaryNotification", "conversations", "", "getMessagesContentText", "messagesCount", "toMessage", "Lio/intercom/android/sdk/m5/push/ui/IntercomPushConversation$Message;", "timestamp", "", "avatarBitmap", "Landroid/graphics/Bitmap;", "contentImageUri", "Landroid/net/Uri;", "intercom-sdk-base_release"})
@SourceDebugExtension(value={"SMAP\nConversationStylePushUI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConversationStylePushUI.kt\nio/intercom/android/sdk/m5/push/ui/ConversationStylePushUIKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 SpannableStringBuilder.kt\nandroidx/core/text/SpannableStringBuilderKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,162:1\n1855#2,2:163\n1360#2:165\n1446#2,5:166\n1855#2:171\n1855#2:172\n1856#2:182\n1856#2:183\n41#3,2:173\n87#3:176\n74#3,4:177\n43#3:181\n1#4:175\n*S KotlinDebug\n*F\n+ 1 ConversationStylePushUI.kt\nio/intercom/android/sdk/m5/push/ui/ConversationStylePushUIKt\n*L\n40#1:163,2\n86#1:165\n86#1:166,5\n89#1:171\n90#1:172\n90#1:182\n89#1:183\n91#1:173,2\n92#1:176\n92#1:177,4\n91#1:181\n*E\n"})
public final class ConversationStylePushUIKt {
    public static final int SUMMARY_NOTIFICATION_ID = 9999997;
    @NotNull
    public static final String KEY_GROUP_CONVERSATION = "io.intercom.android.sdk.INTERCOM_KEY_GROUP_CONVERSATION";

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Notification buildConversationStyleNotification(@NotNull Context context, @NotNull IntercomPushConversation conversation, @Nullable ShortcutInfoCompat shortcutInfo, @NotNull IntercomPushData.ConversationPushData conversationPushData, @NotNull NotificationChannel notificationChannel, boolean isSilent) {
        NotificationCompat.Builder builder;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)conversation, (String)"conversation");
        Intrinsics.checkNotNullParameter((Object)conversationPushData, (String)"conversationPushData");
        Intrinsics.checkNotNullParameter((Object)((Object)notificationChannel), (String)"notificationChannel");
        String string2 = context.getString(R.string.intercom_new_notifications);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(R.stri\u2026tercom_new_notifications)");
        String contentTitle = string2;
        String contentText = ConversationStylePushUIKt.getMessagesContentText(context, conversation.getMessages().size());
        String string3 = context.getString(R.string.intercom_you);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.getString(R.string.intercom_you)");
        String userName = string3;
        NotificationCompat.MessagingStyle messagingStyle = new NotificationCompat.MessagingStyle(new Person.Builder().setName((CharSequence)userName).build());
        Iterable $this$forEach$iv = conversation.getMessages();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NotificationCompat.MessagingStyle.Message message;
            IntercomPushConversation.Message it = (IntercomPushConversation.Message)element$iv;
            boolean bl = false;
            NotificationCompat.MessagingStyle.Message message2 = message = new NotificationCompat.MessagingStyle.Message((CharSequence)it.getMessage(), it.getTimestamp(), it.getPerson());
            NotificationCompat.MessagingStyle messagingStyle2 = messagingStyle;
            boolean bl2 = false;
            if (it.getContentImageUri() != null) {
                Uri uri;
                void $this$buildConversationStyleNotification_u24lambda_u242_u24lambda_u241;
                boolean bl3 = false;
                $this$buildConversationStyleNotification_u24lambda_u242_u24lambda_u241.setData("image/", uri);
            }
            messagingStyle2.addMessage(message);
        }
        NotificationCompat.Builder $this$buildConversationStyleNotification_u24lambda_u243 = builder = BasePushUIKt.createBaseNotificationBuilder(context, contentTitle, contentText, notificationChannel).setStyle((NotificationCompat.Style)messagingStyle).setShortcutInfo(shortcutInfo).setBubbleMetadata(BubbleMetaDataKt.getBubbleMetaData(context, conversation)).setContentIntent(ConversationDeepLinkRouterKt.buildIntentForConversationScreen(context, conversation.getConversationId()));
        boolean bl = false;
        if (Build.VERSION.SDK_INT >= 24) {
            $this$buildConversationStyleNotification_u24lambda_u243.addAction(ConversationActionHandlerKt.buildReplyAction(context, conversation.getConversationId()));
            if (conversationPushData.getMessageData() instanceof IntercomPushData.ConversationPushData.MessageData.Attachment) {
                $this$buildConversationStyleNotification_u24lambda_u243.addAction(ConversationActionHandlerKt.buildContextualAction(context, ((IntercomPushData.ConversationPushData.MessageData.Attachment)conversationPushData.getMessageData()).getUrl()));
            }
        }
        Notification notification = builder.setGroup(KEY_GROUP_CONVERSATION).setSilent(isSilent).build();
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"createBaseNotificationBu\u2026sSilent)\n        .build()");
        return notification;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Notification buildConversationStyleSummaryNotification(@NotNull Context context, @NotNull List<IntercomPushConversation> conversations, @NotNull NotificationChannel notificationChannel) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(conversations, (String)"conversations");
        Intrinsics.checkNotNullParameter((Object)((Object)notificationChannel), (String)"notificationChannel");
        String string2 = context.getString(R.string.intercom_new_notifications);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(R.stri\u2026tercom_new_notifications)");
        String contentTitle = string2;
        Iterable iterable = conversations;
        Context context2 = context;
        boolean $i$f$flatMap = false;
        void var7_8 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            IntercomPushConversation it = (IntercomPushConversation)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getMessages();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        String contentText = ConversationStylePushUIKt.getMessagesContentText(context2, ((List)destination$iv$iv).size());
        NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle().setBigContentTitle((CharSequence)contentTitle);
        Intrinsics.checkNotNullExpressionValue((Object)inboxStyle, (String)"InboxStyle().setBigContentTitle(contentTitle)");
        NotificationCompat.InboxStyle inboxStyle2 = inboxStyle;
        Iterable $this$forEach$iv = conversations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IntercomPushConversation conversation = (IntercomPushConversation)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = conversation.getMessages();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                SpannableStringBuilder builder$iv;
                IntercomPushConversation.Message message = (IntercomPushConversation.Message)element$iv2;
                boolean bl2 = false;
                boolean $i$f$buildSpannedString = false;
                SpannableStringBuilder $this$buildConversationStyleSummaryNotification_u24lambda_u249_u24lambda_u248_u24lambda_u247 = builder$iv = new SpannableStringBuilder();
                boolean bl3 = false;
                Object object = message.getPerson();
                if (object != null && (object = object.getName()) != null) {
                    void $this$inSpans$iv$iv;
                    Object it = object;
                    boolean bl4 = false;
                    SpannableStringBuilder $this$bold$iv = $this$buildConversationStyleSummaryNotification_u24lambda_u249_u24lambda_u248_u24lambda_u247;
                    boolean $i$f$bold = false;
                    SpannableStringBuilder spannableStringBuilder = $this$bold$iv;
                    StyleSpan span$iv$iv = new StyleSpan(1);
                    boolean $i$f$inSpans = false;
                    int start$iv$iv = $this$inSpans$iv$iv.length();
                    void $this$buildConversationStyleSummaryNotification_u24lambda_u249_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245 = $this$inSpans$iv$iv;
                    boolean bl5 = false;
                    $this$buildConversationStyleSummaryNotification_u24lambda_u249_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245.append((CharSequence)("" + it + ' '));
                    $this$inSpans$iv$iv.setSpan((Object)span$iv$iv, start$iv$iv, $this$inSpans$iv$iv.length(), 17);
                }
                $this$buildConversationStyleSummaryNotification_u24lambda_u249_u24lambda_u248_u24lambda_u247.append((CharSequence)message.getMessage());
                SpannedString messageWithAuthor = new SpannedString((CharSequence)builder$iv);
                inboxStyle2.addLine((CharSequence)messageWithAuthor);
            }
        }
        Notification notification = BasePushUIKt.createBaseNotificationBuilder(context, contentTitle, contentText, notificationChannel).setContentIntent(ConversationDeepLinkRouterKt.buildIntentForMessagesScreen(context)).setGroup(KEY_GROUP_CONVERSATION).setGroupSummary(true).setStyle((NotificationCompat.Style)inboxStyle2).build();
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"createBaseNotificationBu\u2026oxStyle)\n        .build()");
        return notification;
    }

    private static final String getMessagesContentText(Context context, int messagesCount) {
        String string2 = messagesCount == 1 ? context.getString(R.string.intercom_one_new_message) : ((Object)Phrase.from(context, R.string.intercom_new_messages).put("n", messagesCount).format()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"if (messagesCount == 1) \u2026t()\n        .toString()\n}");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IntercomPushConversation.Message toMessage(@NotNull IntercomPushData.ConversationPushData $this$toMessage, long timestamp, @Nullable Bitmap avatarBitmap, @Nullable Uri contentImageUri) {
        String string2;
        Person person;
        Intrinsics.checkNotNullParameter((Object)$this$toMessage, (String)"<this>");
        if ($this$toMessage.isCurrentUser()) {
            person = null;
        } else {
            IconCompat iconCompat;
            Person.Builder builder = new Person.Builder().setName((CharSequence)$this$toMessage.getAuthorName()).setKey($this$toMessage.getAuthorName() + $this$toMessage.getAvatarUrl());
            Bitmap bitmap = avatarBitmap;
            if (bitmap != null) {
                void it;
                Bitmap bitmap2 = bitmap;
                Person.Builder builder2 = builder;
                boolean bl = false;
                iconCompat = IconCompat.createWithBitmap((Bitmap)it);
                builder = builder2;
            } else {
                iconCompat = null;
            }
            person = builder.setIcon(iconCompat).build();
        }
        IntercomPushData.ConversationPushData.MessageData messageData = $this$toMessage.getMessageData();
        if (messageData instanceof IntercomPushData.ConversationPushData.MessageData.Text) {
            string2 = ((IntercomPushData.ConversationPushData.MessageData.Text)$this$toMessage.getMessageData()).getMessage();
        } else if (messageData instanceof IntercomPushData.ConversationPushData.MessageData.Image) {
            string2 = ((IntercomPushData.ConversationPushData.MessageData.Image)$this$toMessage.getMessageData()).getTitle();
        } else if (messageData instanceof IntercomPushData.ConversationPushData.MessageData.Attachment) {
            string2 = ((IntercomPushData.ConversationPushData.MessageData.Attachment)$this$toMessage.getMessageData()).getTitle();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Uri uri = contentImageUri;
        String string3 = string2;
        long l = timestamp;
        Person person2 = person;
        return new IntercomPushConversation.Message(person2, l, string3, uri);
    }

    public static /* synthetic */ IntercomPushConversation.Message toMessage$default(IntercomPushData.ConversationPushData conversationPushData, long l, Bitmap bitmap, Uri uri, int n, Object object) {
        if ((n & 2) != 0) {
            bitmap = null;
        }
        if ((n & 4) != 0) {
            uri = null;
        }
        return ConversationStylePushUIKt.toMessage(conversationPushData, l, bitmap, uri);
    }
}

