/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.push.ui;

import android.app.Notification;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.text.SpannableStringBuilder;
import android.text.SpannedString;
import android.text.style.StyleSpan;
import androidx.core.app.NotificationCompat;
import androidx.core.app.Person;
import androidx.core.content.pm.ShortcutInfoCompat;
import androidx.core.graphics.drawable.IconCompat;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.m5.push.ConversationActionHandlerKt;
import io.intercom.android.sdk.m5.push.ConversationDeepLinkRouterKt;
import io.intercom.android.sdk.m5.push.IntercomPushData;
import io.intercom.android.sdk.m5.push.NotificationChannel;
import io.intercom.android.sdk.m5.push.ui.BasePushUIKt;
import io.intercom.android.sdk.m5.push.ui.BubbleMetaDataKt;
import io.intercom.android.sdk.m5.push.ui.IntercomPushConversation;
import io.intercom.android.sdk.utilities.Phrase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a2\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a&\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u00122\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u0018\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0003H\u0002\u001a \u0010\u0015\u001a\u00020\u0016*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"KEY_GROUP_CONVERSATION", "", "SUMMARY_NOTIFICATION_ID", "", "buildConversationStyleNotification", "Landroid/app/Notification;", "context", "Landroid/content/Context;", "conversation", "Lio/intercom/android/sdk/m5/push/ui/IntercomPushConversation;", "shortcutInfo", "Landroidx/core/content/pm/ShortcutInfoCompat;", "notificationChannel", "Lio/intercom/android/sdk/m5/push/NotificationChannel;", "isSilent", "", "buildConversationStyleSummaryNotification", "conversations", "", "getMessagesContentText", "messagesCount", "toMessage", "Lio/intercom/android/sdk/m5/push/ui/IntercomPushConversation$Message;", "Lio/intercom/android/sdk/m5/push/IntercomPushData$ConversationPushData;", "timestamp", "", "icon", "Landroid/graphics/Bitmap;", "intercom-sdk-base_release"})
@SourceDebugExtension(value={"SMAP\nConversationStylePushUI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConversationStylePushUI.kt\nio/intercom/android/sdk/m5/push/ui/ConversationStylePushUIKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 SpannableStringBuilder.kt\nandroidx/core/text/SpannableStringBuilderKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n1855#2,2:143\n1360#2:145\n1446#2,5:146\n1855#2:151\n1855#2:152\n1856#2:162\n1856#2:163\n41#3,2:153\n87#3:156\n74#3,4:157\n43#3:161\n1#4:155\n*S KotlinDebug\n*F\n+ 1 ConversationStylePushUI.kt\nio/intercom/android/sdk/m5/push/ui/ConversationStylePushUIKt\n*L\n36#1:143,2\n73#1:145\n73#1:146,5\n76#1:151\n77#1:152\n77#1:162\n76#1:163\n78#1:153,2\n79#1:156\n79#1:157,4\n78#1:161\n*E\n"})
public final class ConversationStylePushUIKt {
    public static final int SUMMARY_NOTIFICATION_ID = 9999997;
    @NotNull
    public static final String KEY_GROUP_CONVERSATION = "io.intercom.android.sdk.INTERCOM_KEY_GROUP_CONVERSATION";

    @NotNull
    public static final Notification buildConversationStyleNotification(@NotNull Context context, @NotNull IntercomPushConversation conversation, @Nullable ShortcutInfoCompat shortcutInfo, @NotNull NotificationChannel notificationChannel, boolean isSilent) {
        NotificationCompat.Builder builder;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)conversation, (String)"conversation");
        Intrinsics.checkNotNullParameter((Object)((Object)notificationChannel), (String)"notificationChannel");
        String string2 = context.getString(R.string.intercom_new_notifications);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(R.stri\u2026tercom_new_notifications)");
        String contentTitle = string2;
        String contentText = ConversationStylePushUIKt.getMessagesContentText(context, conversation.getMessages().size());
        String string3 = context.getString(R.string.intercom_you);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.getString(R.string.intercom_you)");
        String userName = string3;
        NotificationCompat.MessagingStyle messagingStyle = new NotificationCompat.MessagingStyle(new Person.Builder().setName((CharSequence)userName).build());
        Iterable $this$forEach$iv = conversation.getMessages();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IntercomPushConversation.Message it = (IntercomPushConversation.Message)element$iv;
            boolean bl = false;
            messagingStyle.addMessage(new NotificationCompat.MessagingStyle.Message((CharSequence)it.getMessage(), it.getTimestamp(), it.getPerson()));
        }
        NotificationCompat.Builder $this$buildConversationStyleNotification_u24lambda_u241 = builder = BasePushUIKt.createBaseNotificationBuilder(context, contentTitle, contentText, notificationChannel).setStyle((NotificationCompat.Style)messagingStyle).setShortcutInfo(shortcutInfo).setBubbleMetadata(BubbleMetaDataKt.getBubbleMetaData(context, conversation)).setContentIntent(ConversationDeepLinkRouterKt.buildIntentForConversationScreen(context, conversation.getConversationId()));
        boolean bl = false;
        if (Build.VERSION.SDK_INT >= 24) {
            $this$buildConversationStyleNotification_u24lambda_u241.addAction(ConversationActionHandlerKt.buildReplyAction(context, conversation.getConversationId()));
        }
        Notification notification = builder.setGroup(KEY_GROUP_CONVERSATION).setSilent(isSilent).build();
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"createBaseNotificationBu\u2026sSilent)\n        .build()");
        return notification;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Notification buildConversationStyleSummaryNotification(@NotNull Context context, @NotNull List<IntercomPushConversation> conversations, @NotNull NotificationChannel notificationChannel) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(conversations, (String)"conversations");
        Intrinsics.checkNotNullParameter((Object)((Object)notificationChannel), (String)"notificationChannel");
        String string2 = context.getString(R.string.intercom_new_notifications);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(R.stri\u2026tercom_new_notifications)");
        String contentTitle = string2;
        Iterable iterable = conversations;
        Context context2 = context;
        boolean $i$f$flatMap = false;
        void var7_8 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            IntercomPushConversation it = (IntercomPushConversation)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getMessages();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        String contentText = ConversationStylePushUIKt.getMessagesContentText(context2, ((List)destination$iv$iv).size());
        NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle().setBigContentTitle((CharSequence)contentTitle);
        Intrinsics.checkNotNullExpressionValue((Object)inboxStyle, (String)"InboxStyle().setBigContentTitle(contentTitle)");
        NotificationCompat.InboxStyle inboxStyle2 = inboxStyle;
        Iterable $this$forEach$iv = conversations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IntercomPushConversation conversation = (IntercomPushConversation)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = conversation.getMessages();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                SpannableStringBuilder builder$iv;
                IntercomPushConversation.Message message = (IntercomPushConversation.Message)element$iv2;
                boolean bl2 = false;
                boolean $i$f$buildSpannedString = false;
                SpannableStringBuilder $this$buildConversationStyleSummaryNotification_u24lambda_u247_u24lambda_u246_u24lambda_u245 = builder$iv = new SpannableStringBuilder();
                boolean bl3 = false;
                Object object = message.getPerson();
                if (object != null && (object = object.getName()) != null) {
                    void $this$inSpans$iv$iv;
                    Object it = object;
                    boolean bl4 = false;
                    SpannableStringBuilder $this$bold$iv = $this$buildConversationStyleSummaryNotification_u24lambda_u247_u24lambda_u246_u24lambda_u245;
                    boolean $i$f$bold = false;
                    SpannableStringBuilder spannableStringBuilder = $this$bold$iv;
                    StyleSpan span$iv$iv = new StyleSpan(1);
                    boolean $i$f$inSpans = false;
                    int start$iv$iv = $this$inSpans$iv$iv.length();
                    void $this$buildConversationStyleSummaryNotification_u24lambda_u247_u24lambda_u246_u24lambda_u245_u24lambda_u244_u24lambda_u243 = $this$inSpans$iv$iv;
                    boolean bl5 = false;
                    $this$buildConversationStyleSummaryNotification_u24lambda_u247_u24lambda_u246_u24lambda_u245_u24lambda_u244_u24lambda_u243.append((CharSequence)("" + it + ' '));
                    $this$inSpans$iv$iv.setSpan((Object)span$iv$iv, start$iv$iv, $this$inSpans$iv$iv.length(), 17);
                }
                $this$buildConversationStyleSummaryNotification_u24lambda_u247_u24lambda_u246_u24lambda_u245.append((CharSequence)message.getMessage());
                SpannedString messageWithAuthor = new SpannedString((CharSequence)builder$iv);
                inboxStyle2.addLine((CharSequence)messageWithAuthor);
            }
        }
        Notification notification = BasePushUIKt.createBaseNotificationBuilder(context, contentTitle, contentText, notificationChannel).setContentIntent(ConversationDeepLinkRouterKt.buildIntentForMessagesScreen(context)).setGroup(KEY_GROUP_CONVERSATION).setGroupSummary(true).setStyle((NotificationCompat.Style)inboxStyle2).build();
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"createBaseNotificationBu\u2026oxStyle)\n        .build()");
        return notification;
    }

    private static final String getMessagesContentText(Context context, int messagesCount) {
        String string2 = messagesCount == 1 ? context.getString(R.string.intercom_one_new_message) : ((Object)Phrase.from(context, R.string.intercom_new_messages).put("n", messagesCount).format()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"if (messagesCount == 1) \u2026t()\n        .toString()\n}");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IntercomPushConversation.Message toMessage(@NotNull IntercomPushData.ConversationPushData $this$toMessage, long timestamp, @Nullable Bitmap icon) {
        Person person;
        Intrinsics.checkNotNullParameter((Object)$this$toMessage, (String)"<this>");
        if ($this$toMessage.isCurrentUser()) {
            person = null;
        } else {
            IconCompat iconCompat;
            Person.Builder builder = new Person.Builder().setName((CharSequence)$this$toMessage.getAuthorName()).setKey($this$toMessage.getAuthorName() + $this$toMessage.getAvatarUrl());
            Bitmap bitmap = icon;
            if (bitmap != null) {
                void it;
                Bitmap bitmap2 = bitmap;
                Person.Builder builder2 = builder;
                boolean bl = false;
                iconCompat = IconCompat.createWithBitmap((Bitmap)it);
                builder = builder2;
            } else {
                iconCompat = null;
            }
            person = builder.setIcon(iconCompat).build();
        }
        String string2 = $this$toMessage.getMessage();
        long l = timestamp;
        Person person2 = person;
        return new IntercomPushConversation.Message(person2, l, string2);
    }

    public static /* synthetic */ IntercomPushConversation.Message toMessage$default(IntercomPushData.ConversationPushData conversationPushData, long l, Bitmap bitmap, int n, Object object) {
        if ((n & 2) != 0) {
            bitmap = null;
        }
        return ConversationStylePushUIKt.toMessage(conversationPushData, l, bitmap);
    }
}

