/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views.decoration;

import android.content.Context;
import android.graphics.Rect;
import android.view.View;
import androidx.annotation.VisibleForTesting;
import androidx.recyclerview.widget.RecyclerView;
import com.intercom.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.blocks.lib.BlockType;
import io.intercom.android.sdk.models.Part;
import java.util.List;

public class ConversationItemDecoration
extends RecyclerView.ItemDecoration {
    private static final int MESSAGE_ROW_SHADOW_SPACING = 4;
    private static final int SPACING = 16;
    private static final int TOP_SPACING = 24;
    private static final int DIVIDER_TOP_SPACING = 16;
    private static final int DIVIDER_BOTTOM_SPACING = 10;
    private static final int CONCAT_SPACING = 4;
    private static final int SHADOW_SPACING = 12;
    private static final int SHADOW_CONCAT_SPACING = 0;
    private static final int TEAM_PRESENCE_SPACING = 48;
    private static final int COMPOSER_SUGGESTIONS_SPACING = 48;
    private final List<Part> parts;
    private final int spacing;
    private final int topSpacing;
    private final int concatSpacing;
    private final int dividerTopSpacing;
    private final int dividerBottomSpacing;
    private final int shadowSpacing;
    private final int shadowConcatSpacing;
    private final int teamPresenceSpacing;
    private final int composerSuggestionsSpacing;

    public ConversationItemDecoration(Context context, List<Part> parts) {
        this.parts = parts;
        this.spacing = ScreenUtils.dpToPx((float)16.0f, (Context)context);
        this.topSpacing = ScreenUtils.dpToPx((float)24.0f, (Context)context);
        this.concatSpacing = ScreenUtils.dpToPx((float)4.0f, (Context)context);
        this.dividerTopSpacing = ScreenUtils.dpToPx((float)16.0f, (Context)context);
        this.dividerBottomSpacing = ScreenUtils.dpToPx((float)10.0f, (Context)context);
        this.shadowSpacing = ScreenUtils.dpToPx((float)12.0f, (Context)context);
        this.shadowConcatSpacing = ScreenUtils.dpToPx((float)0.0f, (Context)context);
        this.teamPresenceSpacing = ScreenUtils.dpToPx((float)48.0f, (Context)context);
        this.composerSuggestionsSpacing = ScreenUtils.dpToPx((float)48.0f, (Context)context);
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView recyclerView, RecyclerView.State state) {
        int position = recyclerView.getChildLayoutPosition(view);
        if (position != -1 && position < this.parts.size()) {
            Part currentPart = this.parts.get(position);
            if ("day_divider_style".equals(currentPart.getMessageStyle())) {
                outRect.set(0, this.dividerTopSpacing, 0, this.dividerBottomSpacing);
            } else if ("big_ticket".equals(currentPart.getMessageStyle())) {
                outRect.set(0, this.cardTopSpacingAtPosition(position), 0, 0);
            } else if (this.isSingleBlockPartWithShadow(currentPart)) {
                outRect.set(0, this.shadowTopSpacingAtPosition(position), 0, 0);
            } else if (this.shouldConcatenate(currentPart, position) && this.nextPartIsSingleBlockPartWithShadow(position)) {
                outRect.set(0, this.topSpacingAtPosition(position), 0, this.shadowConcatSpacing);
            } else if (this.shouldConcatenate(currentPart, position)) {
                outRect.set(0, this.topSpacingAtPosition(position), 0, this.concatSpacing);
            } else if (this.nextPartIsDivider(position) && !"team_presence_style".equals(currentPart.getMessageStyle())) {
                outRect.set(0, this.topSpacingAtPosition(position), 0, 0);
            } else if (this.nextPartIsSingleBlockPartWithShadow(position)) {
                outRect.set(0, this.topSpacingAtPosition(position), 0, this.shadowSpacing);
            } else if ("team_presence_style".equals(currentPart.getMessageStyle())) {
                outRect.set(0, this.teamPresenceTopSpacingAtPosition(position), 0, this.spacing);
            } else if ("composer_suggestions_style".equals(currentPart.getMessageStyle())) {
                outRect.set(0, this.composerSuggestionsTopSpacingAtPosition(position), 0, this.spacing);
            } else if (currentPart.isLinkCard()) {
                outRect.set(0, this.cardTopSpacingAtPosition(position), 0, this.spacing);
            } else {
                outRect.set(0, this.topSpacingAtPosition(position), 0, this.spacing);
            }
        }
    }

    private boolean isSingleBlockPartWithShadow(Part conversationPart) {
        return conversationPart.isSingleBlockPartOfType(BlockType.MESSENGERCARD) || conversationPart.isSingleBlockPartOfType(BlockType.CREATETICKETCARD);
    }

    private boolean nextPartIsSingleBlockPartWithShadow(int position) {
        if (position + 1 < this.parts.size()) {
            return this.isSingleBlockPartWithShadow(this.parts.get(position + 1));
        }
        return false;
    }

    private int topSpacingAtPosition(int position) {
        return position == 0 ? this.topSpacing : 0;
    }

    private int teamPresenceTopSpacingAtPosition(int position) {
        return position == 0 ? this.teamPresenceSpacing : this.teamPresenceSpacing - this.spacing;
    }

    private int shadowTopSpacingAtPosition(int position) {
        return position == 0 ? this.shadowSpacing : 0;
    }

    private int composerSuggestionsTopSpacingAtPosition(int position) {
        return position == 0 ? this.composerSuggestionsSpacing : this.composerSuggestionsSpacing - this.spacing;
    }

    private int cardTopSpacingAtPosition(int position) {
        return position == 0 ? this.topSpacing : this.topSpacing - this.spacing;
    }

    @VisibleForTesting
    boolean shouldConcatenate(Part conversationPart, int position) {
        if (position + 1 < this.parts.size()) {
            Part nextPart = this.parts.get(position + 1);
            return Part.shouldConcatenate(conversationPart, nextPart);
        }
        return false;
    }

    private boolean nextPartIsDivider(int position) {
        return position + 1 < this.parts.size() && "day_divider_style".equals(this.parts.get(position + 1).getMessageStyle());
    }
}

