/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import coil.request.ErrorResult;
import coil.request.ImageRequest;
import coil.request.SuccessResult;
import coil.transform.Transformation;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.utilities.IntercomCoilKt;
import io.intercom.android.sdk.utilities.coil.AvatarShapeTransformation;
import io.intercom.android.sdk.views.AvatarDefaultDrawable;
import io.intercom.android.sdk.views.AvatarInitialsDrawable;
import org.jetbrains.annotations.NotNull;

public class AvatarUtils {
    public static void preloadAvatar(Avatar avatar, final Runnable runnable, Activity activity) {
        if (avatar.getImageUrl().isEmpty()) {
            runnable.run();
        } else {
            ImageRequest imageRequest = new ImageRequest.Builder((Context)activity).data((Object)avatar.getImageUrl()).listener(new ImageRequest.Listener(){

                public void onStart(@NotNull ImageRequest imageRequest) {
                }

                public void onCancel(@NotNull ImageRequest imageRequest) {
                }

                public void onError(@NonNull ImageRequest imageRequest, @NonNull ErrorResult errorResult) {
                    runnable.run();
                }

                public void onSuccess(@NonNull ImageRequest imageRequest, @NonNull SuccessResult successResult) {
                    runnable.run();
                }
            }).build();
            IntercomCoilKt.loadIntercomImage((Context)activity, imageRequest);
        }
    }

    public static void loadAvatarIntoView(Avatar avatar, ImageView imageView, AppConfig appConfig2) {
        AvatarUtils.createAvatar(avatar, imageView, 0, appConfig2);
    }

    public static void createAvatar(Avatar avatar, ImageView imageView, int size, AppConfig appConfig2) {
        Context context = imageView.getContext();
        ImageRequest avatarImageRequest = AvatarUtils.getAvatarImageRequestBuilder(context, avatar, appConfig2).target(imageView).build();
        IntercomCoilKt.loadIntercomImage(context, avatarImageRequest);
    }

    public static ImageRequest.Builder getAvatarImageRequestBuilder(Context context, Avatar avatar, AppConfig appConfig2) {
        Drawable backupDrawable = AvatarUtils.getPlaceHolderDrawable(context, avatar, appConfig2);
        return new ImageRequest.Builder(context).data((Object)avatar.getImageUrl()).placeholder(backupDrawable).error(backupDrawable).crossfade(true).transformations(new Transformation[]{new AvatarShapeTransformation(avatar.getShape())});
    }

    public static Drawable getPlaceHolderDrawable(Context context, Avatar avatar, AppConfig appConfig2) {
        return avatar.getInitials().isEmpty() ? AvatarUtils.getDefaultDrawable(context, appConfig2) : AvatarUtils.getInitialsDrawable(avatar.getInitials(), appConfig2);
    }

    public static AvatarInitialsDrawable getInitialsDrawable(String initials, AppConfig appConfig2) {
        return new AvatarInitialsDrawable(initials.toUpperCase(), appConfig2.getSecondaryColorDark());
    }

    public static AvatarDefaultDrawable getDefaultDrawable(Context context, AppConfig appConfig2) {
        return new AvatarDefaultDrawable(context, appConfig2.getSecondaryColorDark());
    }
}

