/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.components.intercombadge;

import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.m5.components.intercombadge.IntercomBadgeLocation;
import io.intercom.android.sdk.m5.components.intercombadge.IntercomBadgeState;
import io.intercom.android.sdk.m5.components.intercombadge.IntercomLinkSolution;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lio/intercom/android/sdk/m5/components/intercombadge/IntercomBadgeStateReducer;", "", "config", "Lio/intercom/android/sdk/identity/AppConfig;", "appIdentity", "Lio/intercom/android/sdk/identity/AppIdentity;", "userIdentity", "Lio/intercom/android/sdk/identity/UserIdentity;", "(Lio/intercom/android/sdk/identity/AppConfig;Lio/intercom/android/sdk/identity/AppIdentity;Lio/intercom/android/sdk/identity/UserIdentity;)V", "getAppIdentity", "()Lio/intercom/android/sdk/identity/AppIdentity;", "getConfig", "()Lio/intercom/android/sdk/identity/AppConfig;", "getUserIdentity", "()Lio/intercom/android/sdk/identity/UserIdentity;", "computeIntercomBadgeState", "Lio/intercom/android/sdk/m5/components/intercombadge/IntercomBadgeState;", "intercomBadgeLocation", "Lio/intercom/android/sdk/m5/components/intercombadge/IntercomBadgeLocation;", "solution", "Lio/intercom/android/sdk/m5/components/intercombadge/IntercomLinkSolution;", "getCompanyForUrl", "", "companyName", "intercom-sdk-base_release"})
public final class IntercomBadgeStateReducer {
    @NotNull
    private final AppConfig config;
    @NotNull
    private final AppIdentity appIdentity;
    @NotNull
    private final UserIdentity userIdentity;

    public IntercomBadgeStateReducer(@NotNull AppConfig config, @NotNull AppIdentity appIdentity, @NotNull UserIdentity userIdentity2) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)appIdentity, (String)"appIdentity");
        Intrinsics.checkNotNullParameter((Object)userIdentity2, (String)"userIdentity");
        this.config = config;
        this.appIdentity = appIdentity;
        this.userIdentity = userIdentity2;
    }

    public /* synthetic */ IntercomBadgeStateReducer(AppConfig appConfig, AppIdentity appIdentity, UserIdentity userIdentity2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            AppConfig appConfig2 = Injector.get().getAppConfigProvider().get();
            Intrinsics.checkNotNullExpressionValue((Object)appConfig2, (String)"get().appConfigProvider.get()");
            appConfig = appConfig2;
        }
        if ((n & 2) != 0) {
            AppIdentity appIdentity2 = Injector.get().getAppIdentity();
            Intrinsics.checkNotNullExpressionValue((Object)appIdentity2, (String)"get().appIdentity");
            appIdentity = appIdentity2;
        }
        if ((n & 4) != 0) {
            UserIdentity userIdentity3 = Injector.get().getUserIdentity();
            Intrinsics.checkNotNullExpressionValue((Object)userIdentity3, (String)"get().userIdentity");
            userIdentity2 = userIdentity3;
        }
        this(appConfig, appIdentity, userIdentity2);
    }

    @NotNull
    public final AppConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final AppIdentity getAppIdentity() {
        return this.appIdentity;
    }

    @NotNull
    public final UserIdentity getUserIdentity() {
        return this.userIdentity;
    }

    @NotNull
    public final IntercomBadgeState computeIntercomBadgeState(@NotNull IntercomBadgeLocation intercomBadgeLocation, @NotNull IntercomLinkSolution solution) {
        IntercomBadgeState intercomBadgeState;
        Intrinsics.checkNotNullParameter((Object)intercomBadgeLocation, (String)"intercomBadgeLocation");
        Intrinsics.checkNotNullParameter((Object)((Object)solution), (String)"solution");
        if (!this.config.shouldShowIntercomLink()) {
            return IntercomBadgeState.Hidden.INSTANCE;
        }
        if (intercomBadgeLocation instanceof IntercomBadgeLocation.Conversation && ((IntercomBadgeLocation.Conversation)intercomBadgeLocation).getLaunchedProgrammatically() || intercomBadgeLocation instanceof IntercomBadgeLocation.Home) {
            String string2;
            IntercomBadgeLocation intercomBadgeLocation2 = intercomBadgeLocation;
            if (intercomBadgeLocation2 instanceof IntercomBadgeLocation.Conversation) {
                string2 = "4+conversation+we-run-on-intercom";
            } else if (Intrinsics.areEqual((Object)intercomBadgeLocation2, (Object)IntercomBadgeLocation.Home.INSTANCE)) {
                string2 = "4+home-screen+we-run-on-intercom";
            } else {
                throw new NoWhenBranchMatchedException();
            }
            String content = string2;
            StringBuilder stringBuilder = new StringBuilder().append("https://www.intercom.io/intercom-link?user_id=").append(this.userIdentity.getUserId()).append("&powered_by_app_id=").append(this.appIdentity.appId()).append("&company=");
            String string3 = this.config.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"config.name");
            intercomBadgeState = new IntercomBadgeState.Shown(stringBuilder.append(this.getCompanyForUrl(string3)).append("&solution=").append(solution.getType()).append("&utm_source=android-sdk&utm_campaign=intercom-link&utm_content=").append(content).append("&utm_medium=messenger").toString());
        } else {
            intercomBadgeState = IntercomBadgeState.Hidden.INSTANCE;
        }
        return intercomBadgeState;
    }

    private final String getCompanyForUrl(String companyName) {
        String string2;
        try {
            String string3 = URLEncoder.encode(companyName, "UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n            URLEncoder\u2026yName, \"UTF-8\")\n        }");
            string2 = string3;
        }
        catch (UnsupportedEncodingException e) {
            LumberMill.getLogger().i("Could not url encode the app name", new Object[0]);
            string2 = "";
        }
        return string2;
    }

    public IntercomBadgeStateReducer() {
        this(null, null, null, 7, null);
    }
}

