/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.conversation.reducers;

import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.m5.conversation.states.ContentRow;
import io.intercom.android.sdk.m5.conversation.states.ConversationClientState;
import io.intercom.android.sdk.m5.conversation.states.SharpCornersShape;
import io.intercom.android.sdk.m5.conversation.utils.ConversationExtensionsKt;
import io.intercom.android.sdk.m5.conversation.utils.PartExtensionsKt;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.ReplyOption;
import io.intercom.android.sdk.models.Ticket;
import io.intercom.android.sdk.tickets.TicketDetailReducerKt;
import io.intercom.android.sdk.views.compose.MessageRowKt;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a&\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a8\u0006\u0011"}, d2={"getSharpCornersShape", "Lio/intercom/android/sdk/m5/conversation/states/SharpCornersShape;", "parts", "", "Lio/intercom/android/sdk/models/Part;", "index", "", "isAdminOrAltParticipant", "", "reduceMessages", "Lio/intercom/android/sdk/m5/conversation/states/ContentRow;", "clientState", "Lio/intercom/android/sdk/m5/conversation/states/ConversationClientState;", "userIdentity", "Lio/intercom/android/sdk/identity/UserIdentity;", "config", "Lio/intercom/android/sdk/identity/AppConfig;", "intercom-sdk-base_release"})
public final class ConversationPartsReducerKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ContentRow> reduceMessages(@NotNull ConversationClientState clientState, @NotNull UserIdentity userIdentity, @NotNull AppConfig config) {
        void $this$forEach$iv;
        Calendar cal;
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv;
        int index$iv$iv;
        void $this$filterIndexedTo$iv$iv;
        Iterable $this$filterIndexed$iv;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        List list;
        Intrinsics.checkNotNullParameter((Object)clientState, (String)"clientState");
        Intrinsics.checkNotNullParameter((Object)userIdentity, (String)"userIdentity");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Conversation conversation = clientState.getConversation();
        if (conversation == null) {
            return CollectionsKt.emptyList();
        }
        Conversation conversation2 = conversation;
        if (!Intrinsics.areEqual((Object)conversation2.getTicket(), (Object)Ticket.Companion.getNULL()) && !ConversationExtensionsKt.hasNonTicketParts(conversation2) && clientState.getPendingMessages().isEmpty()) {
            Ticket ticket = conversation2.getTicket();
            Intrinsics.checkNotNullExpressionValue((Object)ticket, (String)"conversation.ticket");
            return CollectionsKt.listOf((Object)new ContentRow.BigTicketRow(TicketDetailReducerKt.computeTicketViewState$default(ticket, userIdentity, null, 4, null)));
        }
        List $this$reduceMessages_u24lambda_u2d6 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        List<Part> list2 = conversation2.getParts();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"conversation.parts");
        Iterable iterable = list2;
        boolean $i$f$filterNot = false;
        Iterator iterator = $this$filterNot$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Part it = (Part)element$iv$iv;
            boolean bl2 = false;
            List<ReplyOption> list3 = it.getReplyOptions();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"it.replyOptions");
            if (!((Collection)list3).isEmpty() && conversation2.shouldPreventEndUserReplies()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterIndexed = false;
        $this$filterNotTo$iv$iv = $this$filterIndexed$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIndexedTo = false;
        Iterator $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        Iterator bl2 = $this$forEachIndexed$iv$iv$iv.iterator();
        while (bl2.hasNext()) {
            void part;
            void element$iv$iv;
            int n;
            Object item$iv$iv$iv = bl2.next();
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            index$iv$iv = n;
            boolean bl3 = false;
            Part part2 = (Part)element$iv$iv;
            int index = index$iv$iv;
            boolean bl4 = false;
            if (!(!Intrinsics.areEqual((Object)part.getMessageStyle(), (Object)"quick_reply") || index == CollectionsKt.getLastIndex((List)$this$reduceMessages_u24lambda_u2d6))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIndexed$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterIndexedTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Part it = (Part)element$iv$iv;
            boolean bl5 = false;
            Intrinsics.checkNotNullExpressionValue((Object)Calendar.getInstance(), (String)"getInstance()");
            cal.setTime(new Date(it.getCreatedAt() * (long)1000));
            Integer key$iv$iv = cal.get(6);
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl6 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            List it = (List)element$iv;
            boolean bl7 = false;
            $this$reduceMessages_u24lambda_u2d6.add(new ContentRow.DayDividerRow(((Part)CollectionsKt.first((List)it)).getCreatedAt()));
            Iterable element$iv$iv = it;
            List list4 = $this$reduceMessages_u24lambda_u2d6;
            boolean $i$f$mapIndexed = false;
            cal = $this$mapIndexed$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                ContentRow contentRow;
                void part;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Part bl4 = (Part)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv2;
                boolean bl8 = false;
                if (part.isInitialMessage() && part.isLinkCard()) {
                    Intrinsics.checkNotNullExpressionValue((Object)part, (String)"part");
                    contentRow = new ContentRow.AskedAboutRow((Part)part);
                } else {
                    Boolean bl9 = part.isEvent();
                    Intrinsics.checkNotNullExpressionValue((Object)bl9, (String)"part.isEvent");
                    if (bl9.booleanValue()) {
                        Intrinsics.checkNotNullExpressionValue((Object)part, (String)"part");
                        contentRow = new ContentRow.EventRow((Part)part);
                    } else {
                        boolean isLastPart;
                        void index;
                        boolean isAdminOrAltParticipant = part.isAdmin() || !part.getParticipant().isUserWithId(userIdentity.getIntercomId());
                        boolean showAvatarIfAvailable = !Intrinsics.areEqual((Object)part.getMessageStyle(), (Object)"quick_reply") && !PartExtensionsKt.hasNextConcatPart(it, (int)index);
                        boolean isGrouped = PartExtensionsKt.hasPreviousConcatPart(it, (int)index);
                        String string2 = part.getId();
                        List<Part> list5 = conversation2.getParts();
                        Intrinsics.checkNotNullExpressionValue(list5, (String)"conversation.parts");
                        boolean bl10 = isLastPart = Intrinsics.areEqual((Object)string2, (Object)((Part)CollectionsKt.last(list5)).getId()) && clientState.getPendingMessages().isEmpty();
                        Integer metaString = isLastPart && !isAdminOrAltParticipant ? Integer.valueOf(Intrinsics.areEqual((Object)part.getSeenByAdmin(), (Object)"seen") ? R.string.intercom_message_seen : R.string.intercom_message_unseen) : (Integer)null;
                        String string3 = part;
                        void $this$reduceMessages_u24lambda_u2d6_u24lambda_u2d5_u24lambda_u2d4_u24lambda_u2d3 = string3;
                        boolean bl11 = false;
                        $this$reduceMessages_u24lambda_u2d6_u24lambda_u2d5_u24lambda_u2d4_u24lambda_u2d3.setParentConversation(conversation2);
                        void var35_54 = string3;
                        string3 = config.getName();
                        String string4 = clientState.getFailedAttributeIdentifier();
                        SharpCornersShape sharpCornersShape = ConversationPartsReducerKt.getSharpCornersShape(it, (int)index, isAdminOrAltParticipant);
                        Intrinsics.checkNotNullExpressionValue((Object)var35_54, (String)"apply {\n                \u2026                        }");
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name");
                        ContentRow.MessageRow.PartWrapper partWrapper = new ContentRow.MessageRow.PartWrapper((Part)var35_54, isLastPart, metaString, isAdminOrAltParticipant, showAvatarIfAvailable, string3, false, isGrouped, sharpCornersShape, null, string4, 512, null);
                        contentRow = new ContentRow.MessageRow(partWrapper);
                    }
                }
                collection.add(contentRow);
            }
            list4.addAll((List)destination$iv$iv2);
        }
        return CollectionsKt.build((List)list);
    }

    @NotNull
    public static final SharpCornersShape getSharpCornersShape(@NotNull List<? extends Part> parts, int index, boolean isAdminOrAltParticipant) {
        SharpCornersShape sharpCornersShape;
        Intrinsics.checkNotNullParameter(parts, (String)"parts");
        Part part = (Part)CollectionsKt.getOrNull(parts, (int)index);
        boolean bl = part != null ? MessageRowKt.hasTextBlock(part) : false;
        if (bl) {
            boolean bl2 = PartExtensionsKt.hasPreviousConcatPart(parts, index) && isAdminOrAltParticipant;
            boolean bl3 = PartExtensionsKt.hasNextConcatPart(parts, index) && isAdminOrAltParticipant;
            boolean bl4 = PartExtensionsKt.hasPreviousConcatPart(parts, index) && !isAdminOrAltParticipant;
            boolean bl5 = PartExtensionsKt.hasNextConcatPart(parts, index) && !isAdminOrAltParticipant;
            sharpCornersShape = new SharpCornersShape(bl2, bl4, bl5, bl3);
        } else {
            sharpCornersShape = new SharpCornersShape(false, false, false, false, 15, null);
        }
        return sharpCornersShape;
    }
}

