/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.intercom.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.lib.interfaces.AttachmentListBlock;
import io.intercom.android.sdk.blocks.lib.interfaces.LocalAttachmentBlock;
import io.intercom.android.sdk.blocks.lib.models.BlockAttachment;
import io.intercom.android.sdk.blocks.lib.models.BlockMetadata;
import io.intercom.android.sdk.blocks.views.AttachmentView;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.views.ProgressLinearLayout;
import io.intercom.android.sdk.views.UploadProgressBar;
import java.util.List;

class Attachment
implements AttachmentListBlock,
LocalAttachmentBlock {
    private static final int ATTACHMENT_LINE_SPACING_DP = 12;
    private static final int LOCAL_ICON_SIZE_DP = 20;
    private static final int DIVIDER_MARGIN_DP = 6;
    private static final int DIVIDER_WIDTH_DP = 1;
    private final StyleType style;
    private final Provider<AppConfig> appConfigProvider;

    public Attachment(StyleType style2, Provider<AppConfig> appConfigProvider2) {
        this.style = style2;
        this.appConfigProvider = appConfigProvider2;
    }

    @Override
    public View addAttachmentList(List<BlockAttachment> attachments, BlockMetadata blockMetadata, ViewGroup parent) {
        Context context = parent.getContext();
        LinearLayout layout2 = this.getAttachmentListView(context);
        int primaryColor = this.appConfigProvider.get().getPrimaryColor();
        int whiteColor = ContextCompat.getColor((Context)context, (int)R.color.intercom_white);
        int blackColor = ContextCompat.getColor((Context)context, (int)R.color.intercom_accessibility_black);
        int baseColour = ColorUtils.isComparedColorsLowerThanAccessibilityContrastRatio(primaryColor, whiteColor) ? blackColor : primaryColor;
        int count = attachments.size();
        for (int i = 0; i < count; ++i) {
            AttachmentView attachmentLayout = new AttachmentView(context, this.style, baseColour, attachments.get(i));
            if (i < count - 1) {
                attachmentLayout.setPadding(attachmentLayout.getPaddingLeft(), attachmentLayout.getPaddingTop(), attachmentLayout.getPaddingRight(), ScreenUtils.dpToPx((float)12.0f, (Context)context));
            }
            layout2.addView((View)attachmentLayout);
        }
        BlockUtils.setLayoutMarginsAndGravity((View)layout2, 0x800003, blockMetadata.isLastObject());
        return layout2;
    }

    private LinearLayout getAttachmentListView(Context context) {
        LinearLayout layout2 = new LinearLayout(context);
        layout2.setOrientation(1);
        layout2.setBackgroundResource(R.color.intercom_full_transparent_full_black);
        BlockUtils.createLayoutParams((View)layout2, -2, -2);
        BlockUtils.setDefaultMarginBottom((View)layout2);
        return layout2;
    }

    @Override
    public View addAttachment(BlockAttachment blockAttachment, BlockMetadata blockMetadata, ViewGroup parent) {
        Context context = parent.getContext();
        ProgressLinearLayout rootView = this.getLocalAttachmentView(context);
        FrameLayout frame = this.getIconHolder(context);
        ImageView attachmentIcon = this.getAttachmentIcon(context);
        UploadProgressBar uploadProgressBar = this.getUploadProgressBar(context);
        View divider = this.getDivider(context);
        TextView textView = this.getTextView(blockAttachment.getName(), context);
        frame.addView((View)uploadProgressBar);
        frame.addView((View)attachmentIcon);
        rootView.setUploadProgressBar(uploadProgressBar);
        rootView.setAttachmentIcon(attachmentIcon);
        rootView.addView((View)textView);
        BlockUtils.setLayoutMarginsAndGravity((View)rootView, 0x800003, blockMetadata.isLastObject());
        return rootView;
    }

    private ProgressLinearLayout getLocalAttachmentView(Context context) {
        ProgressLinearLayout root = new ProgressLinearLayout(context);
        BlockUtils.createLayoutParams((View)root, -2, -2);
        BlockUtils.setDefaultMarginBottom((View)root);
        root.setOrientation(0);
        return root;
    }

    private FrameLayout getIconHolder(Context context) {
        int localIconSizeDp = ScreenUtils.dpToPx((float)20.0f, (Context)context);
        FrameLayout frame = new FrameLayout(context);
        BlockUtils.createLayoutParams((View)frame, localIconSizeDp, localIconSizeDp);
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)frame.getLayoutParams();
        params.gravity = 8388627;
        return frame;
    }

    private UploadProgressBar getUploadProgressBar(Context context) {
        UploadProgressBar uploadProgressBar = new UploadProgressBar(context);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        uploadProgressBar.setLayoutParams((ViewGroup.LayoutParams)params);
        return uploadProgressBar;
    }

    private ImageView getAttachmentIcon(Context context) {
        ImageView attachmentIcon = new ImageView(context);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        attachmentIcon.setLayoutParams((ViewGroup.LayoutParams)params);
        attachmentIcon.setVisibility(8);
        attachmentIcon.setImageResource(R.drawable.intercom_icn_attachment);
        return attachmentIcon;
    }

    private View getDivider(Context context) {
        int dividerMarginDp = ScreenUtils.dpToPx((float)6.0f, (Context)context);
        int dividerWidthDp = ScreenUtils.dpToPx((float)1.0f, (Context)context);
        View view = new View(context);
        view.setBackgroundResource(R.color.intercom_white);
        BlockUtils.createLayoutParams(view, dividerWidthDp, -1);
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)view.getLayoutParams();
        params.leftMargin = dividerMarginDp;
        params.rightMargin = dividerMarginDp;
        return view;
    }

    private TextView getTextView(String name, Context context) {
        TextView textView = new TextView(context);
        BlockUtils.createLayoutParams((View)textView, -2, -2);
        BlockUtils.setSmallLineSpacing(textView);
        textView.setGravity(8388627);
        textView.setEllipsize(TextUtils.TruncateAt.END);
        textView.setTextSize(15.0f);
        textView.setTextColor(ContextCompat.getColor((Context)context, (int)R.color.intercom_white));
        textView.setBackgroundResource(R.color.intercom_full_transparent_full_black);
        textView.setText((CharSequence)name);
        return textView;
    }
}

