/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.content.res.Resources;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.utilities.TimeFormatter;

public class PartMetadataFormatter {
    private final TimeFormatter timeFormatter;

    public PartMetadataFormatter(TimeFormatter timeFormatter2) {
        this.timeFormatter = timeFormatter2;
    }

    public String getMetadataString(Part conversationPart, boolean isLastItem, Resources resources) {
        switch (conversationPart.getMessageState()) {
            case SENDING: {
                return resources.getString(R.string.intercom_message_state_sending);
            }
            case FAILED: 
            case UPLOAD_FAILED: {
                return resources.getString(R.string.intercom_message_failed_try_again);
            }
        }
        return isLastItem ? this.formatLastPart(conversationPart, resources) : this.formatPart(conversationPart);
    }

    private String formatLastPart(Part part, Resources resources) {
        StringBuilder sb = new StringBuilder();
        if (part.isDisplayDelivered()) {
            sb.append(resources.getString(R.string.intercom_delivered));
        } else {
            sb.append(this.timeFormatter.getFormattedTime(part.getCreatedAt()));
        }
        if ("seen".equalsIgnoreCase(part.getSeenByAdmin())) {
            sb.append(". ").append(resources.getString(R.string.intercom_message_seen));
        } else if ("unseen".equalsIgnoreCase(part.getSeenByAdmin())) {
            sb.append(". ").append(resources.getString(R.string.intercom_message_unseen));
        }
        return sb.toString();
    }

    private String formatPart(Part conversationPart) {
        if (conversationPart.isDisplayDelivered()) {
            return "";
        }
        return this.timeFormatter.getAbsoluteTime(conversationPart.getCreatedAt());
    }
}

