/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation.attribute;

import android.app.DatePickerDialog;
import android.widget.DatePicker;
import io.intercom.android.sdk.conversation.attribute.AttributeInputListener;
import io.intercom.android.sdk.utilities.TimeFormatter;
import io.intercom.android.sdk.views.holder.ConversationListener;
import java.util.Calendar;
import java.util.TimeZone;

public class OnDateAttributeSetListener
implements DatePickerDialog.OnDateSetListener {
    private final String partId;
    private final String identifier;
    private final String formType;
    private final ConversationListener conversationListener;
    private final AttributeInputListener attributeInputListener;

    public OnDateAttributeSetListener(String partId, String identifier, String formType, ConversationListener conversationListener, AttributeInputListener attributeInputListener) {
        this.partId = partId;
        this.identifier = identifier;
        this.formType = formType;
        this.conversationListener = conversationListener;
        this.attributeInputListener = attributeInputListener;
    }

    public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.clear();
        calendar.set(1, year);
        calendar.set(2, monthOfYear);
        calendar.set(5, dayOfMonth);
        long timestampInMillis = calendar.getTimeInMillis();
        long unixTimestamp = timestampInMillis / 1000L;
        this.conversationListener.onSubmitAttribute(this.partId, this.identifier, unixTimestamp, this.formType);
        String formattedDate = TimeFormatter.formatTimeInMillisAsDate(timestampInMillis);
        this.attributeInputListener.populateSelectedValue(formattedDate);
    }
}

