/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.homescreen;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.gson.Gson;
import com.intercom.commons.utilities.TimeProvider;
import com.squareup.otto.Bus;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.conversation.IntercomLinkPresenter;
import io.intercom.android.sdk.homescreen.HomeClickListener;
import io.intercom.android.sdk.homescreen.HomeFragmentBase;
import io.intercom.android.sdk.homescreen.HomePresenter;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.imageloader.WallpaperLoader;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.StoreUtils;
import io.intercom.android.sdk.utilities.WindowUtils;
import io.intercom.android.sdk.views.HomeToolbar;
import io.intercom.android.sdk.views.IntercomLinkView;
import io.intercom.android.sdk.views.decoration.HomeItemDecoration;
import java.util.ArrayList;
import java.util.List;

public class HomeFragment
extends HomeFragmentBase
implements IntercomLinkPresenter.IntercomLinkHost {
    private static final int OFFSCREEN_ITEM_CACHE = 4;
    private WallpaperLoader wallpaperLoader;
    private Store<State> store;
    private Provider<AppConfig> appConfigProvider;
    private Api api;
    private TimeProvider timeProvider;
    private Bus bus;
    private Gson gson;
    private MetricTracker metricTracker;
    private UserIdentity userIdentity;
    @Nullable
    private Store.Subscription subscription;
    private HomePresenter homePresenter;
    private HomeClickListener listener;
    private HomeToolbar toolbar;
    private View toolbarContent;
    private View closeBackground;
    private View linkContainer;
    private IntercomLinkView linkView;
    private RecyclerView recyclerView;
    private List<Object> cardList = new ArrayList<Object>();
    private int statusHeight;
    private int startLocationY;

    public static HomeFragment newInstance() {
        return new HomeFragment();
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        try {
            this.listener = (HomeClickListener)context;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(context + " must implement ConversationCardClickListener");
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        Injector injector2 = Injector.get();
        this.api = injector2.getApi();
        this.appConfigProvider = injector2.getAppConfigProvider();
        this.store = injector2.getStore();
        this.timeProvider = injector2.getTimeProvider();
        this.bus = injector2.getBus();
        this.gson = injector2.getGson();
        this.metricTracker = injector2.getMetricTracker();
        this.userIdentity = injector2.getUserIdentity();
        View rootView = inflater.inflate(R.layout.intercom_fragment_home, container, false);
        this.statusHeight = WindowUtils.getStatusBarHeight(this.getResources());
        this.toolbar = (HomeToolbar)rootView.findViewById(R.id.intercom_toolbar);
        this.toolbarContent = rootView.findViewById(R.id.toolbar_content_container);
        this.recyclerView = (RecyclerView)rootView.findViewById(R.id.card_list);
        this.closeBackground = rootView.findViewById(R.id.intercom_close_background);
        this.closeBackground.setBackground(ColorUtils.getCloseBackground(this.requireContext(), this.appConfigProvider.get()));
        this.setUpToolbar(this.appConfigProvider);
        this.setUpScrollListener();
        this.setUpCloseButton(this.appConfigProvider.get(), rootView.findViewById(R.id.intercom_home_close_container));
        rootView.findViewById(R.id.intercom_toolbar_close).setOnClickListener(v -> this.listener.onCloseClicked());
        this.setUpLinkView(this.appConfigProvider, this.api, rootView, injector2.getAppIdentity().appId(), this.userIdentity.getIntercomId());
        this.setUpCardList(this.appConfigProvider, this.store, this.timeProvider, this.bus, this.gson, this.metricTracker, this.userIdentity);
        return rootView;
    }

    public void onStart() {
        super.onStart();
        this.subscription = this.store.subscribeToChanges(Selectors.INBOX, Selectors.TEAM_PRESENCE, this);
    }

    public void onResume() {
        this.store.dispatch(Actions.homeOpened());
        super.onResume();
    }

    public void onStop() {
        StoreUtils.safeUnsubscribe(this.subscription);
        super.onStop();
    }

    public void onDestroyView() {
        this.toolbar.closeWallpaperLoader(this.wallpaperLoader);
        super.onDestroyView();
    }

    private void setUpScrollListener() {
        if (Build.VERSION.SDK_INT >= 23) {
            this.recyclerView.setOnScrollChangeListener(new View.OnScrollChangeListener(){

                public void onScrollChange(View v, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
                    HomeFragment.this.homePresenter.renderHeaderScrollChange(HomeFragment.this.recyclerView, HomeFragment.this.startLocationY, HomeFragment.this.closeBackground, HomeFragment.this.toolbarContent);
                }
            });
        } else {
            this.recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

                public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                    super.onScrolled(recyclerView, dx, dy);
                    HomeFragment.this.homePresenter.renderHeaderScrollChange(recyclerView, HomeFragment.this.startLocationY, HomeFragment.this.closeBackground, HomeFragment.this.toolbarContent);
                }
            });
        }
    }

    private void setUpCloseButton(AppConfig appConfig, View close) {
        ColorUtils.setImageColorWhiteOrBlack((ImageView)close.findViewById(R.id.intercom_toolbar_close), appConfig.secondaryColorRenderDarkText());
        close.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                HomeFragment.this.listener.onCloseClicked();
            }
        });
        close.setPadding(close.getPaddingLeft(), close.getPaddingTop() + this.statusHeight, close.getPaddingRight(), close.getPaddingBottom());
        ViewGroup.LayoutParams params = close.getLayoutParams();
        params.height += this.statusHeight;
        close.setLayoutParams(params);
    }

    private void setUpCardList(Provider<AppConfig> appConfigProvider2, Store<State> store, TimeProvider timeProvider, Bus bus, Gson gson, MetricTracker metricTracker, UserIdentity userIdentity) {
        this.homePresenter = new HomePresenter(store, appConfigProvider2, this.cardList, metricTracker);
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new HomeItemDecoration(this.getContext(), this.cardList));
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.recyclerView.setItemViewCacheSize(4);
        this.recyclerView.setItemAnimator(null);
    }

    private void setUpLinkView(Provider<AppConfig> appConfigProvider2, Api api, View rootView, String appId, String userId) {
        this.linkView = (IntercomLinkView)rootView.findViewById(R.id.intercom_link);
        this.linkContainer = rootView.findViewById(R.id.intercom_home_link_container);
        IntercomLinkPresenter linkPresenter = new IntercomLinkPresenter(this.linkView, appConfigProvider2, api, "", appId, userId, true);
        linkPresenter.setup(this);
        if (appConfigProvider2.get().shouldShowIntercomLink()) {
            this.linkContainer.setVisibility(0);
            this.recyclerView.setPadding(this.recyclerView.getPaddingLeft(), this.recyclerView.getPaddingTop(), this.recyclerView.getPaddingRight(), this.recyclerView.getPaddingBottom() + this.getResources().getDimensionPixelSize(R.dimen.intercom_link_height));
        } else {
            this.linkContainer.setVisibility(8);
        }
    }

    private void setUpToolbar(Provider<AppConfig> appConfigProvider2) {
        int backgroundColor = appConfigProvider2.get().getSecondaryColor();
        this.toolbar.setBackgroundColor(backgroundColor);
        this.wallpaperLoader = WallpaperLoader.create(this.getContext(), appConfigProvider2);
        this.toolbar.loadWallpaper(this.wallpaperLoader);
        this.toolbar.setBackgroundColor(backgroundColor);
        this.toolbar.updateToolbarColors(appConfigProvider2.get());
        this.toolbarContent.setPadding(this.toolbarContent.getPaddingLeft(), this.toolbarContent.getPaddingTop() + this.statusHeight, this.toolbarContent.getPaddingRight(), this.toolbarContent.getPaddingBottom());
        this.toolbar.updateContent(appConfigProvider2.get());
        this.animateHeaderIn();
        this.updateRecyclerViewPosition();
    }

    private void animateHeaderIn() {
        this.toolbar.animateIn(this.toolbarContent);
    }

    private void updateRecyclerViewPosition() {
        this.startLocationY = this.recyclerView.getPaddingTop() + this.toolbar.getContentHeight(this.toolbarContent) - this.getResources().getDimensionPixelSize(R.dimen.intercom_home_screen_overlap);
        this.recyclerView.setPadding(this.recyclerView.getPaddingLeft(), this.startLocationY, this.recyclerView.getPaddingRight(), this.recyclerView.getPaddingBottom());
    }

    @Override
    public void addBottomPadding(int extraBottomPadding) {
    }

    @Override
    public boolean isAtBottom() {
        return false;
    }
}

