/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.metrics;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.intercom.commons.utilities.DeviceUtils;
import com.intercom.commons.utilities.TimeProvider;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.metrics.MetricObject;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.overlay.LauncherOpenBehaviour;
import io.intercom.android.sdk.profile.ProfilePresenter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class MetricTracker {
    static final String METADATA_BADGE_VALUE = "badge_value";
    static final String METADATA_IS_ATTACHMENT = "is_attachment";
    static final String METADATA_IS_GIF = "is_gif";
    static final String METADATA_MESSAGE_ID = "message_id";
    static final String METADATA_CONVERSATION_ID = "conversation_id";
    static final String METADATA_PART_ID = "part_id";
    static final String METADATA_QUICK_REPLY_ID = "quick_reply_id";
    static final String METADATA_COMMENT_ID = "comment_id";
    static final String METADATA_REACTION_INDEX = "reaction_index";
    static final String METADATA_MESSAGE_TYPE = "message_type";
    static final String METADATA_PUSH_TYPE = "push_type";
    static final String METADATA_HAS_ARTICLE_CARD = "has_article_card";
    static final String METADATA_SEARCH_QUERY = "search_query";
    static final String METADATA_TEAMMATE_STATUS = "teammate_status";
    static final String METADATA_TIME_SINCE_LAST_ACTIVE = "time_since_last_active";
    static final String METADATA_WITHIN_OFFICE_HOURS = "within_office_hours";
    static final String METADATA_SUGGESTION_ID = "suggestion_id";
    static final String METADATA_INSTANCE_ID = "instance_id";
    static final String METADATA_REQUEST_CONTENT_ID = "requested_content_id";
    static final String METADATA_REQUEST_ERROR_CODE = "error_code";
    static final String METADATA_CLOSED_CONVERSATION_ID = "closed_conversation_id";
    static final String METADATA_SOURCE = "source";
    static final String METADATA_ERROR = "error";
    static final String METADATA_FILTERED = "filtered";
    static final String METADATA_URL = "url";
    static final String METADATA_VIDEO_URL = "video_url";
    static final String METADATA_VIDEO_WIDTH = "video_width";
    static final String METADATA_VIDEO_HEIGHT = "video_height";
    static final String METADATA_SCREENS_IN_MESSAGE = "screens_in_message";
    static final String METADATA_SCREENS_SHOWN = "screens_shown";
    static final String METADATA_SCREENS_SEEN = "screens_seen";
    static final String METADATA_PERMISSION_GRANTED = "permission_granted";
    static final String METADATA_HOME_SCREEN_INDEX = "home_screen_index";
    static final String METADATA_SURVEY_ID = "survey_id";
    static final String METADATA_SURVEY_FORMAT = "format";
    static final String METADATA_PLATFORM = "platform";
    static final String METADATA_STEPS_COMPLETE = "steps_complete";
    static final String QUESTIONS_SEEN = "questions_seen";
    static final String METADATA_MAX_STEPS = "max_steps";
    static final String VALUE_MESSAGE = "message";
    static final String VALUE_NOTIFICATION = "notification";
    static final String VALUE_ACTIVE = "active";
    static final String VALUE_AWAY = "away";
    static final String VALUE_ANDROID_SDK = "android-sdk";
    private final UserIdentity userIdentity;
    private final TimeProvider timeProvider;
    private final MetricsStore store;
    private final String sdkVersion;
    private final String appVersion;

    public MetricTracker(UserIdentity userIdentity, MetricsStore store, android.content.Context androidContext) {
        this(userIdentity, store, TimeProvider.SYSTEM, androidContext);
    }

    @VisibleForTesting
    MetricTracker(UserIdentity userIdentity, MetricsStore store, TimeProvider timeProvider, android.content.Context androidContext) {
        this.userIdentity = userIdentity;
        this.timeProvider = timeProvider;
        this.store = store;
        this.sdkVersion = "12.2.2";
        this.appVersion = DeviceUtils.getAppVersion((android.content.Context)androidContext);
    }

    public void openedMessengerConversationList(LauncherOpenBehaviour.LauncherType launcherType) {
        this.track(this.newMetric("opened", "conversation_list", "messenger", MetricTracker.contextFrom(launcherType)));
    }

    public void openedMessengerConversation(String conversationId, LauncherOpenBehaviour.LauncherType launcherType) {
        this.track(this.newMetric("opened", "conversation", "messenger", MetricTracker.contextFrom(launcherType)).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void openedMessengerNewConversation(LauncherOpenBehaviour.LauncherType launcherType) {
        this.track(this.newMetric("opened", "new_conversation", "messenger", MetricTracker.contextFrom(launcherType)));
    }

    private static String contextFrom(LauncherOpenBehaviour.LauncherType launcherType) {
        return LauncherOpenBehaviour.LauncherType.DEFAULT == launcherType ? "from_launcher" : "from_custom_launcher";
    }

    public void closedMessengerBackButton() {
        this.track(this.newMetric("closed", "messenger", "messenger", "from_android_back_button"));
    }

    public void closedMessengerCloseButton() {
        this.track(this.newMetric("closed", "messenger", "messenger", "from_close_button"));
    }

    void typeInNewConversation() {
        this.track(this.newMetric("typed", VALUE_MESSAGE, "messenger", "in_new_conversation"));
    }

    void typeInNewFollowUpConversation(String closedConversationId) {
        this.track(this.newMetric("typed", VALUE_MESSAGE, "messenger", "from_closed_conversation").addMetaData(METADATA_CLOSED_CONVERSATION_ID, closedConversationId));
    }

    void typeInConversation(String conversationId) {
        this.track(this.newMetric("typed", "reply", "messenger", "in_conversation").addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void sentInNewConversation(boolean isAttachment, boolean isGif, String partId, String conversationId, boolean withinOfficeHours) {
        this.track(this.newMetric("sent", VALUE_MESSAGE, "messenger", "in_new_conversation").addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_IS_GIF, isGif).addMetaData(METADATA_MESSAGE_ID, partId).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_WITHIN_OFFICE_HOURS, withinOfficeHours));
    }

    public void sentInNewFollowupConversation(boolean isAttachment, boolean isGif, String partId, String conversationId, boolean withinOfficeHours, String closedConversationId) {
        this.track(this.newMetric("sent", VALUE_MESSAGE, "messenger", "in_followup_conversation").addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_IS_GIF, isGif).addMetaData(METADATA_MESSAGE_ID, partId).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_WITHIN_OFFICE_HOURS, withinOfficeHours).addMetaData(METADATA_CLOSED_CONVERSATION_ID, closedConversationId));
    }

    public void sentInConversation(boolean isAttachment, boolean isGif, String partId, String conversationId, boolean withinOfficeHours, boolean isTeamMateActive, String timeSinceLastActive) {
        this.track(this.newMetric("sent", "reply", "messenger", "in_conversation").addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_IS_GIF, isGif).addMetaData(METADATA_MESSAGE_ID, partId).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_WITHIN_OFFICE_HOURS, withinOfficeHours).addMetaData(METADATA_TEAMMATE_STATUS, isTeamMateActive ? VALUE_ACTIVE : VALUE_AWAY).addMetaData(METADATA_TIME_SINCE_LAST_ACTIVE, timeSinceLastActive));
    }

    public void openConversationsListFromNewConversation() {
        this.track(this.newMetric("opened", "conversation_list", "messenger", "from_new_conversation"));
    }

    public void startConversation(String conversationId) {
        this.track(this.newMetric("opened", "conversation", "messenger", "from_new_conversation").addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void startFollowupConversation(String conversationId, String closedConverastionId) {
        this.track(this.newMetric("opened", "conversation", "messenger", "in_followup_conversation").addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_CLOSED_CONVERSATION_ID, closedConverastionId));
    }

    public void openConversationsListFromConversation(String conversationId) {
        this.track(this.newMetric("opened", "conversation_list", "messenger", "from_conversation").addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void openedConversationFromFull(String conversationId, String commentId) {
        this.track(this.newMetric("opened", "conversation", "messenger", "from_full").addMetaData(METADATA_COMMENT_ID, commentId).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void openedConversationFromSnippet(String conversationId, String commentId) {
        this.track(this.newMetric("opened", "conversation", "messenger", "from_snippet").addMetaData(METADATA_COMMENT_ID, commentId).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void receivedReply(boolean isAttachment, boolean hasArticle, String partId, String conversationId) {
        this.track(this.newMetric("received", "reply", "messenger", "in_conversation").addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_HAS_ARTICLE_CARD, hasArticle).addMetaData(METADATA_COMMENT_ID, partId).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void viewedReply(boolean isAttachment, boolean hasArticle, String partId, String conversationId) {
        this.track(this.newMetric("viewed", "reply", "messenger", "from_snippet").addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_HAS_ARTICLE_CARD, hasArticle).addMetaData(METADATA_COMMENT_ID, partId).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void sentReaction(String conversationId, String messageId, int reactionIndex, ReactionLocation reactionLocation) {
        if (ReactionLocation.CONVERSATION == reactionLocation) {
            this.track(this.newMetric("sent", "reaction", "messenger", "in_conversation").addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_REACTION_INDEX, reactionIndex).addMetaData(METADATA_CONVERSATION_ID, conversationId));
        } else if (ReactionLocation.LINK == reactionLocation) {
            this.track(this.newEducateMetric("sent", "reaction", "messenger", "on_article").addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId));
        } else {
            this.track(this.newMetric("sent", "reaction", "in_app", "from_full").addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId));
        }
    }

    public void profileClickedOpen(String conversationId, ProfilePresenter.ProfileType profileType) {
        this.track(this.newMetric("opened", MetricTracker.objectFrom(profileType), "messenger", "from_clicking").addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void profileAutoOpen(String conversationId, ProfilePresenter.ProfileType profileType) {
        this.track(this.newMetric("opened", MetricTracker.objectFrom(profileType), "messenger", "from_auto").addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void profileScrolledOpen(String conversationId, ProfilePresenter.ProfileType profileType) {
        this.track(this.newMetric("opened", MetricTracker.objectFrom(profileType), "messenger", "from_scrolling").addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    private static String objectFrom(ProfilePresenter.ProfileType profileType) {
        return ProfilePresenter.ProfileType.TEAMMATE == profileType ? "teammate_profile" : "team_profile";
    }

    public void openConversationFromConversationList(String conversationId, boolean withinOfficeHours, boolean isTeamMateActive, String timeSinceLastActive) {
        this.track(this.newMetric("opened", "conversation", "messenger", "from_conversation_list").addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_WITHIN_OFFICE_HOURS, withinOfficeHours).addMetaData(METADATA_TEAMMATE_STATUS, isTeamMateActive ? VALUE_ACTIVE : VALUE_AWAY).addMetaData(METADATA_TIME_SINCE_LAST_ACTIVE, timeSinceLastActive));
    }

    public void receivedPushNotification(String conversationId) {
        this.track(this.newMetric("received", VALUE_MESSAGE, "push", "from_push").addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_PUSH_TYPE, VALUE_NOTIFICATION));
    }

    public void receivedPushOnlyNotification(String conversationId, String instanceId) {
        this.track(this.newMetric("received", VALUE_MESSAGE, "push", "from_push").addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_INSTANCE_ID, instanceId).addMetaData(METADATA_PUSH_TYPE, VALUE_MESSAGE));
    }

    public void viewedPushNotification(String conversationId) {
        this.track(this.newMetric("viewed", VALUE_MESSAGE, "in_app", "from_push").addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_PUSH_TYPE, VALUE_NOTIFICATION));
    }

    public void openedPushOnlyNotification(String conversationId) {
        this.track(this.newMetric("opened", VALUE_MESSAGE, "in_app", "from_push").addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_PUSH_TYPE, VALUE_MESSAGE));
    }

    public void dismissedPushNotification(String conversationId) {
        this.track(this.newMetric("dismissed", VALUE_MESSAGE, "in_app", "from_push").addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_PUSH_TYPE, VALUE_NOTIFICATION));
    }

    public void dismissedPushOnlyNotification(String conversationId, String instanceId) {
        this.track(this.newMetric("dismissed", VALUE_MESSAGE, "in_app", "from_push").addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_INSTANCE_ID, instanceId).addMetaData(METADATA_PUSH_TYPE, VALUE_MESSAGE));
    }

    public void receivedMessageFromSnippetWhenClosed(boolean isAttachment, boolean hasArticle, String conversationId, String messageId, String messageStyle) {
        this.track(this.newMetric("received", VALUE_MESSAGE, "in_app", "from_snippet").addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_MESSAGE_TYPE, messageStyle).addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_HAS_ARTICLE_CARD, hasArticle));
    }

    public void receivedReplyFromSnippetWhenClosed(boolean isAttachment, boolean hasArticle, String conversationId, String commentId) {
        this.track(this.newMetric("received", "reply", "in_app", "from_snippet").addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_COMMENT_ID, commentId).addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_HAS_ARTICLE_CARD, hasArticle));
    }

    public void receivedMessageFromFullWhenClosed(boolean isAttachment, boolean hasArticle, String conversationId, String messageId, String messageStyle) {
        this.track(this.newMetric("received", VALUE_MESSAGE, "in_app", "from_full").addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_MESSAGE_TYPE, messageStyle).addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_HAS_ARTICLE_CARD, hasArticle));
    }

    public void receivedQuickReply(String quickReplyId, String conversationId, String partId) {
        this.track(this.newMetric("received", "quick_replies", "messenger", "in_conversation").addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_PART_ID, partId).addMetaData(METADATA_QUICK_REPLY_ID, quickReplyId));
    }

    public void clickedQuickReply(String quickReplyId, String conversationId, String partId) {
        this.track(this.newMetric("clicked", "quick_reply", "messenger", "in_conversation").addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_PART_ID, partId).addMetaData(METADATA_QUICK_REPLY_ID, quickReplyId));
    }

    public void receivedComposerSuggestions(String suggestionId, String conversationId, String partId) {
        this.track(this.newMetric("received", "composer_suggestions", "messenger", "in_conversation").addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_PART_ID, partId).addMetaData(METADATA_SUGGESTION_ID, suggestionId));
    }

    public void clickedComposerSuggestion(String suggestionId, String conversationId, String partId) {
        this.track(this.newMetric("clicked", "suggestion", "messenger", "in_conversation").addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_PART_ID, partId).addMetaData(METADATA_SUGGESTION_ID, suggestionId));
    }

    public void dismissInAppMessageSnippet(String conversationId, String messageId) {
        this.track(this.newMetric("dismissed", VALUE_MESSAGE, "in_app", "from_snippet").addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_MESSAGE_ID, messageId));
    }

    public void dismissInAppCommentSnippet(String conversationId, String commentId) {
        this.track(this.newMetric("dismissed", "reply", "in_app", "from_snippet").addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_COMMENT_ID, commentId));
    }

    public void viewedInAppFromMessenger(String conversationId, String messageId, String messageStyle) {
        this.track(this.newMetric("viewed", VALUE_MESSAGE, "messenger", "from_full").addMetaData(METADATA_MESSAGE_TYPE, messageStyle).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void viewedInApp(String conversationId, String messageId, @InAppMessageViewContext int context) {
        this.track(this.newMetric("viewed", VALUE_MESSAGE, "in_app", MetricTracker.contextForInApp(context)).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    private static String contextForInApp(@InAppMessageViewContext int context) {
        return context == 0 ? "from_snippet" : "from_full";
    }

    public void closedInAppFromFull(String conversationId, String messageId) {
        this.track(this.newMetric("closed", VALUE_MESSAGE, "in_app", "from_full").addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void receivedNotificationFromBadgeWhenMessengerClosed(String badgeValue) {
        this.track(this.newMetric("received", "badge", "in_app", "from_launcher").addMetaData(METADATA_BADGE_VALUE, badgeValue));
    }

    public void receivedOperatorReply(String conversationId) {
        this.track(this.newEducateMetric("received", "operator_reply", "messenger", "from_conversation").addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void openedNativeHelpCenter(String place, @Nullable String context) {
        String metricContext = context;
        if (metricContext == null) {
            metricContext = "no_context";
        }
        this.track(this.newHelpCenterMetric("opened", "help_center", place, metricContext, "search_browse".equals(place)));
    }

    public void searchedNativeHelpCenter(boolean isFromSearchBrowse) {
        this.track(this.newHelpCenterMetric("searched", "help_center", "search_results", "no_context", isFromSearchBrowse));
    }

    public void openedNativeHelpCenterSearchResult(boolean isFromSearchBrowse, String searchQuery) {
        this.track(this.newHelpCenterMetric("clicked", "help_center", "search_results", "no_context", isFromSearchBrowse).addMetaData(METADATA_SEARCH_QUERY, searchQuery));
    }

    public void clickedNewConversation(String place, String context, boolean isFromSearchBrowse) {
        this.track(this.newHelpCenterMetric("clicked", "new_conversation", place, context, isFromSearchBrowse));
    }

    public void sentArticleReaction(String context, @Nullable Boolean conversationShown, boolean isFromSearchBrowse) {
        MetricObject metricObject = this.newHelpCenterMetric("sent", "article_reaction", "article", context, isFromSearchBrowse);
        if (conversationShown != null) {
            metricObject.addMetaData("conversation_shown", conversationShown);
        }
        this.track(metricObject);
    }

    public void failedHelpCenter(String object, String place, @Nullable String code, boolean isFromSearchBrowse) {
        MetricObject metricObject = this.newHelpCenterMetric("failed", object, place, "no_context", isFromSearchBrowse);
        if (code != null) {
            metricObject.addMetaData(METADATA_ERROR, code);
        }
        this.track(metricObject);
    }

    public void requestedHelpCenterData(String place) {
        MetricObject metricObject = this.newEducateMetric("requested", "help_center_data", place, "no_context");
        this.track(metricObject);
    }

    public void viewedNativeHelpCenter(String place, @Nullable Boolean filtered, boolean isFromSearchBrowse) {
        MetricObject metricObject = this.newHelpCenterMetric("viewed", "help_center", place, "no_context", isFromSearchBrowse);
        if (filtered != null) {
            metricObject.addMetaData(METADATA_FILTERED, filtered);
        }
        this.track(metricObject);
    }

    public void viewedSearchBrowseCard(int homeIndex) {
        MetricObject metricObject = this.createMetric("search_browse_event", "messenger", "viewed", "search_browse_card", "home-screen", "messenger");
        metricObject.addMetaData(METADATA_HOME_SCREEN_INDEX, homeIndex);
        this.track(metricObject);
    }

    public void clickedSearchBrowseCard() {
        MetricObject metricObject = this.createMetric("search_browse_event", "messenger", "clicked", "search_browse_card_input", "home-screen", "messenger");
        this.track(metricObject);
    }

    public void clickedArticleSuggestion(String articleId) {
        MetricObject metricObject = this.createMetric("mv4_metric", "messenger", "clicked", "article_suggestion", "search_browse_card", "messenger").addMetaData("article_id", articleId);
        this.track(metricObject);
    }

    public void viewedArticleSuggestions(List<String> articleIds) {
        MetricObject metricObject = this.createMetric("mv4_metric", "messenger", "viewed", "article_suggestions", "search_browse_card", "messenger").addMetaData("articles_count", articleIds.size()).addMetaData("articles_shown", articleIds);
        this.track(metricObject);
    }

    public void clickedInput(String conversationId, String input) {
        this.track(this.newMetric("clicked", input, "messenger", "in_conversation").addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void searchedGifInput(String query) {
        this.track(this.newMetric("searched", "expanded_gif_input", "messenger", "in_conversation").addMetaData(METADATA_SEARCH_QUERY, query));
    }

    public void expandedInput(String conversationId) {
        this.track(this.newMetric("opened", "expanded_gif_input", "messenger", "in_conversation").addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void viewedMessengerSheet(String conversationId, String url, boolean isHomeScreen) {
        String context = isHomeScreen ? "home_screen" : "conversation";
        this.track(this.newMetric("viewed", "messenger_sheet", "messenger", context).addMetaData(METADATA_URL, url).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void closedMessengerSheet(String conversationId, String url, boolean isHomeScreen) {
        String context = isHomeScreen ? "home_screen" : "conversation";
        this.track(this.newMetric("closed", "messenger_sheet", "messenger", context).addMetaData(METADATA_URL, url).addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void messengerCardWebViewEvent(String action, String object, String place, @Nullable Map<String, java.lang.Object> eventMetaData, boolean isHomeScreen) {
        String context = isHomeScreen ? "home_screen" : "conversation";
        MetricObject metricObject = this.newEducateMetric(action, object, place, context);
        this.addMetadataToMetricObject(metricObject, eventMetaData);
        this.track(metricObject);
    }

    public void openedHomeScreen(LauncherOpenBehaviour.LauncherType launcherType) {
        this.track(this.newMetric("opened", "home_screen", "messenger", MetricTracker.contextFrom(launcherType)));
    }

    public void openedNewConversationFromHomeScreen() {
        this.track(this.newMetric("opened", "new_conversation", "messenger", "home_screen"));
    }

    public void openedConversationFromHomeScreen(String conversationId) {
        this.track(this.newMetric("opened", "conversation", "messenger", "home_screen").addMetaData(METADATA_CONVERSATION_ID, conversationId));
    }

    public void startedToPlayVideo() {
        this.track(this.newMetric("started", "video_auto_message", "in_app", "conversation"));
    }

    public void loadedVideo(String videoUrl, int width, int height) {
        this.track(this.newMetric("loaded", "video_auto_message", "in_app", "conversation").addMetaData(METADATA_VIDEO_URL, videoUrl).addMetaData(METADATA_VIDEO_WIDTH, width).addMetaData(METADATA_VIDEO_HEIGHT, height));
    }

    public void failedToPlayVideo(String videoUrl) {
        this.track(this.newMetric("failed", "video_auto_message", "in_app", "conversation").addMetaData(METADATA_VIDEO_URL, videoUrl));
    }

    public void completedVideo() {
        this.track(this.newMetric("completed", "video_auto_message", "in_app", "conversation"));
    }

    public void openedCarousel(String instanceId, String source, int screensInMessage, int screensShown) {
        this.track(this.newCarouselMetric("opened", "carousel_message", "from_carousel", instanceId, source).addMetaData(METADATA_SCREENS_IN_MESSAGE, screensInMessage).addMetaData(METADATA_SCREENS_SHOWN, screensShown));
    }

    public void dismissedCarousel(String context, String instanceId, String source, int screensInMessage, int screensShown, int screensSeen) {
        this.track(this.newCarouselMetric("dismissed", "carousel_message", context, instanceId, source).addMetaData(METADATA_SCREENS_IN_MESSAGE, screensInMessage).addMetaData(METADATA_SCREENS_SHOWN, screensShown).addMetaData(METADATA_SCREENS_SEEN, screensSeen));
    }

    public void dismissedCarouselFetching(String context, String requestId, String source) {
        this.track(this.newCarouselMetric("dismissed", "carousel_message_preload", context, source).addMetaData(METADATA_REQUEST_CONTENT_ID, requestId));
    }

    public void failedCarousel(String requestId, String source, int errorCode) {
        this.track(this.newCarouselMetric("failed", "carousel_message_preload", "from_carousel", source).addMetaData(METADATA_REQUEST_ERROR_CODE, errorCode).addMetaData(METADATA_REQUEST_CONTENT_ID, requestId));
    }

    public void startedCarouselFetching(String requestId, String source) {
        this.track(this.newCarouselMetric("started", "carousel_message_preload", "from_carousel", source).addMetaData(METADATA_REQUEST_CONTENT_ID, requestId));
    }

    public void retriedCarouselFetching(String requestId, String source) {
        this.track(this.newCarouselMetric("clicked", "carousel_message_preload", "from_retry", source).addMetaData(METADATA_REQUEST_CONTENT_ID, requestId));
    }

    public void completedCarousel(String context, String instanceId, String source, int screensInMessage, int screensShown) {
        this.track(this.newCarouselMetric("completed", "carousel_message", context, instanceId, source).addMetaData(METADATA_SCREENS_IN_MESSAGE, screensInMessage).addMetaData(METADATA_SCREENS_SHOWN, screensShown));
    }

    public void skippedPermission(String permissionType, String instanceId, String source) {
        this.track(this.newCarouselMetric("clicked", "carousel_permission_skipped", permissionType, instanceId, source));
    }

    public void requestedPermission(String permissionType, String instanceId, String source, boolean isGranted) {
        this.track(this.newCarouselMetric("clicked", "carousel_permission_dialog", permissionType, instanceId, source).addMetaData(METADATA_PERMISSION_GRANTED, isGranted));
    }

    public void sentToPermissionSettings(String permissionType, String instanceId, String source, boolean isGranted) {
        this.track(this.newCarouselMetric("clicked", "carousel_permission_settings", permissionType, instanceId, source).addMetaData(METADATA_PERMISSION_GRANTED, isGranted));
    }

    public void educateWebviewMetric(String action, String object, String place, @Nullable Map<String, java.lang.Object> eventMetaData, String context) {
        MetricObject metricObject = this.newEducateMetric(action, object, place, context);
        if (context.equals("from_article_on_button")) {
            metricObject.addMetaData(METADATA_SOURCE, "programmatic");
        } else {
            metricObject.addMetaData(METADATA_SOURCE, "automatic");
        }
        this.addMetadataToMetricObject(metricObject, eventMetaData);
        this.track(metricObject);
    }

    public void surveyOpened(String action, String object, String context, String surveyID, String format) {
        MetricObject surveyMetric = this.newSurveyMetric(action, object, context).addMetaData(METADATA_PLATFORM, VALUE_ANDROID_SDK).addMetaData(METADATA_SURVEY_ID, surveyID).addMetaData(METADATA_SURVEY_FORMAT, format);
        this.track(surveyMetric);
    }

    public void surveyCompleted(String action, String object, String context, String surveyID, String format, int stepsCompleted, int maxSteps, int questionsSeen) {
        MetricObject surveyMetric = this.newSurveyMetric(action, object, context).addMetaData(METADATA_PLATFORM, VALUE_ANDROID_SDK).addMetaData(METADATA_SURVEY_ID, surveyID).addMetaData(METADATA_SURVEY_FORMAT, format).addMetaData(METADATA_STEPS_COMPLETE, stepsCompleted).addMetaData(QUESTIONS_SEEN, questionsSeen).addMetaData(METADATA_MAX_STEPS, maxSteps);
        this.track(surveyMetric);
    }

    public void surveyDismissed(String action, String object, String context, String surveyID, String format, int stepsCompleted, int maxSteps, int questionsSeen) {
        MetricObject surveyMetric = this.newSurveyMetric(action, object, context).addMetaData(METADATA_PLATFORM, VALUE_ANDROID_SDK).addMetaData(METADATA_SURVEY_ID, surveyID).addMetaData(METADATA_SURVEY_FORMAT, format).addMetaData(METADATA_STEPS_COMPLETE, stepsCompleted).addMetaData(QUESTIONS_SEEN, questionsSeen).addMetaData(METADATA_MAX_STEPS, maxSteps);
        this.track(surveyMetric);
    }

    private void track(MetricObject metric) {
        this.store.track(metric);
    }

    private MetricObject newMetric(String action, String object, String place, String context) {
        return this.createMetric("mv4_metric", "messenger", action, object, place, context);
    }

    private MetricObject newEducateMetric(String action, String object, String place, String context) {
        return this.createMetric("educate_event", "educate", action, object, place, context);
    }

    private MetricObject newHelpCenterMetric(String action, String object, String place, String context, boolean isSearchBrowse) {
        String name = isSearchBrowse ? "search_browse_event" : "educate_event";
        return this.createMetric(name, "educate", action, object, place, context);
    }

    private MetricObject newCarouselMetric(String action, String object, String context, String instanceId, String source) {
        return this.newCarouselMetric(action, object, context, source).addMetaData(METADATA_INSTANCE_ID, instanceId);
    }

    private MetricObject newCarouselMetric(String action, String object, String context, String source) {
        return this.createMetric("carousel_metric", "messenger", action, object, "carousel_message", context).addMetaData(METADATA_SOURCE, source);
    }

    private MetricObject newSurveyMetric(String action, String object, String context) {
        return this.createMetric("survey_metric", "messenger", action, object, "survey", context);
    }

    private MetricObject createMetric(String name, String owner, String action, String object, String place, String context) {
        return new MetricObject(name, owner, UUID.randomUUID().toString(), this.userIdentity.getIntercomId(), action, object, place, context, this.timeProvider, this.appVersion, this.sdkVersion);
    }

    private void addMetadataToMetricObject(MetricObject metricObject, @Nullable Map<String, java.lang.Object> eventMetaData) {
        if (eventMetaData != null && !eventMetaData.isEmpty()) {
            for (String key : eventMetaData.keySet()) {
                metricObject.addMetaData(key, eventMetaData.get(key));
            }
        }
    }

    public static enum ReactionLocation {
        CONVERSATION,
        IN_APP,
        LINK;

    }

    public static @interface InAppMessageViewContext {
        public static final int SNIPPET = 0;
        public static final int FULL = 1;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CloseActionContext {
        public static final int CLOSE_BUTTON = 0;
        public static final int BACK_BUTTON = 1;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Owner {
        public static final String MESSENGER = "messenger";
        public static final String EDUCATE = "educate";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CarouselSource {
        public static final String AUTOMATIC = "automatic";
        public static final String PROGRAMMATIC = "programmatic";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Context {
        public static final String FROM_LAUNCHER = "from_launcher";
        public static final String FROM_CUSTOM_LAUNCHER = "from_custom_launcher";
        public static final String FROM_ANDROID_BACK_BUTTON = "from_android_back_button";
        public static final String FROM_ONWARD_EXTERNAL_LINK = "from_onward_external_link";
        public static final String FROM_ONWARD_DEEP_LINK = "from_onward_deep_link";
        public static final String FROM_CLOSE_BUTTON = "from_close_button";
        public static final String FROM_CONVERSATION_LIST = "from_conversation_list";
        public static final String IN_NEW_CONVERSATION = "in_new_conversation";
        public static final String FROM_NEW_CONVERSATION = "from_new_conversation";
        public static final String FROM_CONVERSATION = "from_conversation";
        public static final String IN_CONVERSATION = "in_conversation";
        public static final String FROM_SNIPPET = "from_snippet";
        public static final String FROM_FULL = "from_full";
        public static final String FROM_CLICKING = "from_clicking";
        public static final String FROM_SCROLLING = "from_scrolling";
        public static final String FROM_AUTO = "from_auto";
        public static final String FROM_PUSH = "from_push";
        public static final String ON_ARTICLE = "on_article";
        public static final String FROM_HELP_CENTER_WEBVIEW = "from_help_center_webview";
        public static final String FROM_ARTICLE_ON_BUTTON = "from_article_on_button";
        public static final String CONVERSATION = "conversation";
        public static final String HOME_SCREEN = "home_screen";
        public static final String FROM_CLOSED_CONVERSATION = "from_closed_conversation";
        public static final String IN_FOLLOWUP_CONVERSATION = "in_followup_conversation";
        public static final String FROM_CAROUSEL = "from_carousel";
        public static final String FROM_RETRY = "from_retry";
        public static final String FROM_CTA = "from_cta";
        public static final String FROM_PERMISSION = "from_permission";
        public static final String FROM_PERMISSION_SKIPPED = "from_permission_skipped";
        public static final String NO_CONTEXT = "no_context";
        public static final String STYLE_HUMAN = "style_human";
        public static final String STYLE_BOT = "style_bot";
        public static final String REACTION_SAD = "reaction_sad";
        public static final String REACTION_NEUTRAL = "reaction_neutral";
        public static final String REACTION_HAPPY = "reaction_happy";
        public static final String ARTICLE = "article";
        public static final String MESSENGER = "messenger";
        public static final String FROM_PROGRAMMATIC = "from_programmatic";
        public static final String FROM_AUTOMATIC = "from_automatic";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Place {
        public static final String MESSENGER = "messenger";
        public static final String IN_APP = "in_app";
        public static final String PUSH = "push";
        public static final String MESSENGER_CARD = "messenger_card";
        public static final String CAROUSEL_MESSAGE = "carousel_message";
        public static final String SEARCH_RESULTS = "search_results";
        public static final String ARTICLE = "article";
        public static final String COLLECTION_LIST = "collection_list";
        public static final String ARTICLE_LIST = "article_list";
        public static final String API = "api";
        public static final String LEGACY_ARTICLE_SEARCH_APP = "legacy_article_search_app";
        public static final String CONVERSATION = "conversation";
        public static final String MESSENGER_HOME_APP = "messenger_home_app";
        public static final String HOME_SCREEN = "home-screen";
        public static final String SEARCH_BROWSE = "search_browse";
        public static final String SURVEY = "survey";
        public static final String SEARCH_BROWSE_CARD = "search_browse_card";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Object {
        public static final String BADGE = "badge";
        public static final String CONVERSATION_LIST = "conversation_list";
        public static final String CONVERSATION = "conversation";
        public static final String NEW_CONVERSATION = "new_conversation";
        public static final String MESSENGER = "messenger";
        public static final String MESSAGE = "message";
        public static final String REPLY = "reply";
        public static final String REACTION = "reaction";
        public static final String TEAMMATE_PROFILE = "teammate_profile";
        public static final String TEAM_PROFILE = "team_profile";
        public static final String ARTICLE = "article";
        public static final String HELP_CENTER = "help_center";
        public static final String HELP_CENTER_DATA_API = "help_center_data";
        public static final String OPERATOR_REPLY = "operator_reply";
        public static final String EXPANDED_GIF_INPUT = "expanded_gif_input";
        public static final String EXPANDED_IMAGE_INPUT = "expanded_image_input";
        public static final String GIF_INPUT = "gif_input";
        public static final String INPUT = "input";
        public static final String IMAGE_INPUT = "image_input";
        public static final String MESSENGER_SHEET = "messenger_sheet";
        public static final String HOME_SCREEN = "home_screen";
        public static final String QUICK_REPLY = "quick_reply";
        public static final String QUICK_REPLIES = "quick_replies";
        public static final String VIDEO_MESSAGE = "video_auto_message";
        public static final String COMPOSER_SUGGESTIONS = "composer_suggestions";
        public static final String SUGGESTION = "suggestion";
        public static final String CAROUSEL_MESSAGE = "carousel_message";
        public static final String CAROUSEL_MESSAGE_PRELOAD = "carousel_message_preload";
        public static final String CAROUSEL_PERMISSION_SKIPPED = "carousel_permission_skipped";
        public static final String CAROUSEL_PERMISSION_DIALOG = "carousel_permission_dialog";
        public static final String CAROUSEL_PERMISSION_SETTINGS = "carousel_permission_settings";
        public static final String ARTICLE_REACTION = "article_reaction";
        public static final String SEARCH_BROWSE_CARD = "search_browse_card";
        public static final String SEARCH_BROWSE_CARD_INPUT = "search_browse_card_input";
        public static final String SURVEY = "survey";
        public static final String SURVEY_STEP_ERROR = "step_error";
        public static final String SURVEY_STEP_LOADING = "step_load";
        public static final String ARTICLE_SUGGESTIONS = "article_suggestions";
        public static final String ARTICLE_SUGGESTION = "article_suggestion";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Action {
        public static final String OPENED = "opened";
        public static final String CLOSED = "closed";
        public static final String TYPED = "typed";
        public static final String SENT = "sent";
        public static final String RECEIVED = "received";
        public static final String VIEWED = "viewed";
        public static final String DISMISSED = "dismissed";
        public static final String SEARCHED = "searched";
        public static final String CLICKED = "clicked";
        public static final String STARTED = "started";
        public static final String LOADED = "loaded";
        public static final String FAILED = "failed";
        public static final String COMPLETED = "completed";
        public static final String REQUESTED = "requested";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Name {
        public static final String MESSENGER = "mv4_metric";
        public static final String EDUCATE = "educate_event";
        public static final String CAROUSEL = "carousel_metric";
        public static final String SURVEY = "survey_metric";
        public static final String SEARCH_BROWSE = "search_browse_event";
    }
}

