/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import androidx.annotation.Nullable;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.logger.LumberMill;
import java.io.IOException;
import retrofit2.Response;

public class ErrorObject {
    private final Twig twig = LumberMill.getLogger();
    private final Throwable throwable;
    private final int statusCode;
    @Nullable
    private final String errorBody;

    public ErrorObject(Throwable throwable, @Nullable Response response) {
        this.throwable = throwable;
        this.errorBody = this.parseErrorBody(response);
        this.statusCode = this.parseStatusCode(response);
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    @Nullable
    String getErrorBody() {
        return this.errorBody;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    boolean hasErrorBody() {
        return this.errorBody != null;
    }

    private int parseStatusCode(@Nullable Response response) {
        if (response != null) {
            return response.code();
        }
        return -1;
    }

    private String parseErrorBody(@Nullable Response response) {
        if (response != null && response.errorBody() != null) {
            try {
                return response.errorBody().string();
            }
            catch (IOException e) {
                this.twig.internal("Couldn't parse error body: " + e.getMessage());
            }
        }
        return null;
    }
}

