/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.push;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.push.PushPayload;
import io.intercom.android.sdk.push.SystemNotificationManager;
import io.intercom.android.sdk.user.DeviceData;

class PushHandler {
    private static final String TAG = "PushHandler";
    private final Twig twig = LumberMill.getLogger();

    PushHandler() {
    }

    boolean shouldSendDeviceToken(Context context, String token) {
        return !DeviceData.hasCachedDeviceToken(context, token);
    }

    void sendTokenToIntercom(Context context, String token, Api api, UserIdentity userIdentity, Provider<AppConfig> appConfigProvider) {
        if (userIdentity.identityExists() && this.hasUserHashIfNeeded(userIdentity, appConfigProvider.get())) {
            api.setDeviceToken(token);
        }
        DeviceData.cacheDeviceToken(context, token);
    }

    private boolean hasUserHashIfNeeded(UserIdentity userIdentity, AppConfig appConfig) {
        return appConfig.isReceivedFromServer() && (!appConfig.isIdentityVerificationEnabled() || appConfig.isIdentityVerificationEnabled() && !TextUtils.isEmpty((CharSequence)userIdentity.getHmac()));
    }

    void handlePush(Bundle message, UserIdentity userIdentity, SystemNotificationManager systemNotificationManager, boolean appBackgrounded, Context localisedContext, MetricTracker metricTracker, AppConfig appConfig) {
        if (userIdentity.identityExists()) {
            this.sendNotification(message, systemNotificationManager, appBackgrounded, localisedContext, metricTracker, appConfig);
        } else {
            systemNotificationManager.clear();
            this.twig.i("Can't create push message as we have no user identity. This can be caused by messages being sent to a logged out user.", new Object[0]);
        }
    }

    private void sendNotification(Bundle message, SystemNotificationManager systemNotificationManager, boolean appBackgrounded, Context localisedContext, MetricTracker metricTracker, AppConfig appConfig) {
        if (message.isEmpty()) {
            this.twig.e("The push intent contained no data", new Object[0]);
            return;
        }
        this.twig.internal(TAG, "Notification Data Json :" + message.getString("message"));
        PushPayload payload = PushPayload.create(message);
        if (payload.isIntercomPush()) {
            if (payload.isPushOnly()) {
                String conversationId = payload.getPushOnlyConversationId();
                String instanceId = payload.getInstanceId();
                metricTracker.receivedPushOnlyNotification(conversationId, instanceId);
                systemNotificationManager.createPushOnlyNotification(payload, localisedContext, appConfig);
            } else if (appBackgrounded) {
                metricTracker.receivedPushNotification(payload.getConversationId());
                systemNotificationManager.createNotification(payload, localisedContext, appConfig);
            } else {
                this.twig.i("Intercom message received but not displayed in notification bar. This happened because the host app was in the foreground.", new Object[0]);
            }
        } else {
            this.twig.i("This is not a Intercom push message", new Object[0]);
        }
    }
}

