/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.homescreen;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.imageview.ShapeableImageView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.databinding.IntercomArticleSearchCardBinding;
import io.intercom.android.sdk.helpcenter.articles.ArticleViewState;
import io.intercom.android.sdk.homescreen.HomeClickListener;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.utilities.ColorUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lio/intercom/android/sdk/homescreen/ArticleSearchCardViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "binding", "Lio/intercom/android/sdk/databinding/IntercomArticleSearchCardBinding;", "appConfig", "Lio/intercom/android/sdk/identity/AppConfig;", "homeClickListener", "Lio/intercom/android/sdk/homescreen/HomeClickListener;", "(Lio/intercom/android/sdk/databinding/IntercomArticleSearchCardBinding;Lio/intercom/android/sdk/identity/AppConfig;Lio/intercom/android/sdk/homescreen/HomeClickListener;)V", "getAppConfig", "()Lio/intercom/android/sdk/identity/AppConfig;", "getBinding", "()Lio/intercom/android/sdk/databinding/IntercomArticleSearchCardBinding;", "getHomeClickListener", "()Lio/intercom/android/sdk/homescreen/HomeClickListener;", "bindTeamPresence", "", "teamPresence", "Lio/intercom/android/sdk/models/TeamPresence;", "intercom-sdk-base_release"})
public final class ArticleSearchCardViewHolder
extends RecyclerView.ViewHolder {
    @NotNull
    private final IntercomArticleSearchCardBinding binding;
    @NotNull
    private final AppConfig appConfig;
    @NotNull
    private final HomeClickListener homeClickListener;

    public ArticleSearchCardViewHolder(@NotNull IntercomArticleSearchCardBinding binding, @NotNull AppConfig appConfig, @NotNull HomeClickListener homeClickListener) {
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"appConfig");
        Intrinsics.checkNotNullParameter((Object)homeClickListener, (String)"homeClickListener");
        super((View)binding.getRoot());
        this.binding = binding;
        this.appConfig = appConfig;
        this.homeClickListener = homeClickListener;
        IntercomArticleSearchCardBinding intercomArticleSearchCardBinding = this.binding;
        boolean bl = false;
        boolean bl2 = false;
        IntercomArticleSearchCardBinding $this$_init__u24lambda_u2d1 = intercomArticleSearchCardBinding;
        boolean bl3 = false;
        ColorUtils.updateInnerBorderColor(this.getAppConfig(), (View)$this$_init__u24lambda_u2d1.getRoot());
        int searchButtonBorder = ColorUtils.isColorLight(this.getAppConfig().getPrimaryColor()) ? ContextCompat.getColor((Context)$this$_init__u24lambda_u2d1.getRoot().getContext(), (int)R.color.intercom_black_20) : this.getAppConfig().getPrimaryColor();
        BackgroundUtils.setRippleButtonStroke($this$_init__u24lambda_u2d1.getRoot().getContext(), $this$_init__u24lambda_u2d1.articleSearchButton.getBackground(), R.id.background, searchButtonBorder);
        int backgroundColor = ContextCompat.getColor((Context)$this$_init__u24lambda_u2d1.getRoot().getContext(), (int)R.color.intercom_white);
        BackgroundUtils.setRippleButtonBackgroundColor($this$_init__u24lambda_u2d1.articleSearchButton.getBackground(), R.id.background, backgroundColor);
        ColorUtils.updateLeftDrawableColorAccordingToBrightness($this$_init__u24lambda_u2d1.articleSearchButton, this.getAppConfig().getPrimaryColor());
        $this$_init__u24lambda_u2d1.articleSearchButton.setOnClickListener(arg_0 -> ArticleSearchCardViewHolder.lambda-1$lambda-0(this, arg_0));
    }

    @NotNull
    public final IntercomArticleSearchCardBinding getBinding() {
        return this.binding;
    }

    @NotNull
    public final AppConfig getAppConfig() {
        return this.appConfig;
    }

    @NotNull
    public final HomeClickListener getHomeClickListener() {
        return this.homeClickListener;
    }

    /*
     * WARNING - void declaration
     */
    public final void bindTeamPresence(@NotNull TeamPresence teamPresence) {
        boolean shouldShowTeammateHelp;
        Intrinsics.checkNotNullParameter((Object)teamPresence, (String)"teamPresence");
        boolean bl = shouldShowTeammateHelp = this.appConfig.isInboundMessages() && this.appConfig.isAccessToTeammateEnabled() && this.appConfig.isHelpCenterRequireSearchEnabled();
        if (shouldShowTeammateHelp) {
            void $this$forEachIndexed$iv;
            this.binding.articleCardAvatarsLayout.setVisibility(0);
            this.binding.articleSearchTitle.setText(R.string.intercom_get_help);
            List<Participant> list = teamPresence.getActiveAdmins();
            Intrinsics.checkNotNullExpressionValue(list, (String)"teamPresence.activeAdmins");
            List<ArticleViewState.AvatarState> avatarStates = ArticleViewState.Companion.computeAvatarState(list);
            Object object = new ShapeableImageView[]{this.binding.articleCardAvatars.helpCenterArticleAvatar1, this.binding.articleCardAvatars.helpCenterArticleAvatar2, this.binding.articleCardAvatars.helpCenterArticleAvatar3};
            List avatarViews = CollectionsKt.listOf((Object[])object);
            object = CollectionsKt.takeLast(avatarStates, (int)3);
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void avatarState;
                int n = index$iv++;
                boolean bl2 = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                ArticleViewState.AvatarState avatarState2 = (ArticleViewState.AvatarState)item$iv;
                int index = n;
                boolean bl3 = false;
                ((ShapeableImageView)avatarViews.get(index)).setVisibility(avatarState.getVisibility());
                AvatarUtils.loadAvatarIntoView(avatarState.getAvatar(), (ImageView)avatarViews.get(index), this.getAppConfig());
            }
        } else {
            this.binding.articleCardAvatarsLayout.setVisibility(8);
            this.binding.articleSearchTitle.setText(R.string.intercom_search_for_help);
        }
    }

    private static final void lambda-1$lambda-0(ArticleSearchCardViewHolder this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.getHomeClickListener().onArticleSearchClicked();
    }
}

