/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.Context;
import android.view.View;
import com.intercom.commons.utilities.TimeProvider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.models.Location;
import io.intercom.android.sdk.utilities.Phrase;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class LocationFormatter {
    private static final String[] UPPER_CASE_EN_US_AM_PM = new String[]{"AM", "PM"};
    private static final String[] UPPER_CASE_EN_GB_AM_PM = new String[]{"a.m.", "p.m."};
    private static final String[] LOWER_CASE_ENGLISH_AM_PM = new String[]{"am", "pm"};
    private static final long ONE_MINUTE_IN_MILLIS = TimeUnit.MINUTES.toMillis(1L);

    public static CharSequence getLocationString(Context context, Location location, Date date) {
        if (location.getTimezoneOffset() == null) {
            return "";
        }
        Locale locale = context.getResources().getConfiguration().locale;
        SimpleDateFormat dateFormat = new SimpleDateFormat("h:mma", locale);
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        timeZone.setRawOffset((int)TimeUnit.SECONDS.toMillis(location.getTimezoneOffset().intValue()));
        dateFormat.setTimeZone(timeZone);
        DateFormatSymbols symbols = new DateFormatSymbols(locale);
        if (Arrays.equals(symbols.getAmPmStrings(), UPPER_CASE_EN_GB_AM_PM) || Arrays.equals(symbols.getAmPmStrings(), UPPER_CASE_EN_US_AM_PM)) {
            symbols.setAmPmStrings(LOWER_CASE_ENGLISH_AM_PM);
        }
        dateFormat.setDateFormatSymbols(symbols);
        return Phrase.from(context, R.string.intercom_profile_location).put("time", dateFormat.format(date)).put("location", location.getCityName() + ", " + location.getCountryName()).format();
    }

    public static void postOnNextMinute(View view, Runnable runnable, TimeProvider system) {
        long timeInMillis = system.currentTimeMillis();
        long millisPastMinute = timeInMillis % ONE_MINUTE_IN_MILLIS;
        view.postDelayed(runnable, ONE_MINUTE_IN_MILLIS - millisPastMinute);
    }
}

