/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.helpcenter.component;

import android.content.res.ColorStateList;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.imageview.ShapeableImageView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.activities.IntercomMessengerActivity;
import io.intercom.android.sdk.databinding.IntercomViewHelpCenterTeamHelpAvatarsBinding;
import io.intercom.android.sdk.databinding.IntercomViewHelpCenterTeamHelpBinding;
import io.intercom.android.sdk.helpcenter.articles.ArticleViewState;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.utilities.AvatarUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0000\u001a\u0014\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u0001H\u0000\u00a8\u0006\u000e"}, d2={"computeViewState", "Lio/intercom/android/sdk/helpcenter/articles/ArticleViewState$TeamPresenceState;", "articleId", "", "currentState", "appConfig", "Lio/intercom/android/sdk/identity/AppConfig;", "teamPresence", "Lio/intercom/android/sdk/models/TeamPresence;", "metricPlace", "renderTeamPresence", "", "Lio/intercom/android/sdk/databinding/IntercomViewHelpCenterTeamHelpBinding;", "teamPresenceState", "intercom-sdk-base_release"})
public final class TeammateHelpKt {
    /*
     * WARNING - void declaration
     */
    public static final void renderTeamPresence(@NotNull IntercomViewHelpCenterTeamHelpBinding $this$renderTeamPresence, @NotNull ArticleViewState.TeamPresenceState teamPresenceState) {
        Intrinsics.checkNotNullParameter((Object)$this$renderTeamPresence, (String)"$this$renderTeamPresence");
        Intrinsics.checkNotNullParameter((Object)teamPresenceState, (String)"teamPresenceState");
        $this$renderTeamPresence.helpCenterArticleContactTitle.setText(teamPresenceState.getMessageTitleText());
        List avatarViews = CollectionsKt.listOf((Object[])new ShapeableImageView[]{$this$renderTeamPresence.helpCenterArticleAvatars.helpCenterArticleAvatar1, $this$renderTeamPresence.helpCenterArticleAvatars.helpCenterArticleAvatar2, $this$renderTeamPresence.helpCenterArticleAvatars.helpCenterArticleAvatar3});
        IntercomViewHelpCenterTeamHelpAvatarsBinding intercomViewHelpCenterTeamHelpAvatarsBinding = $this$renderTeamPresence.helpCenterArticleAvatars;
        Intrinsics.checkNotNullExpressionValue((Object)intercomViewHelpCenterTeamHelpAvatarsBinding, (String)"helpCenterArticleAvatars");
        FrameLayout frameLayout = intercomViewHelpCenterTeamHelpAvatarsBinding.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"helpCenterArticleAvatars.root");
        frameLayout.setVisibility(teamPresenceState.getAvatarComponentVisibility());
        Iterable $this$forEachIndexed$iv = CollectionsKt.takeLast(teamPresenceState.getAvatars(), (int)3);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void avatarState;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ArticleViewState.AvatarState avatarState2 = (ArticleViewState.AvatarState)item$iv;
            int index = n;
            boolean bl2 = false;
            Object e = avatarViews.get(index);
            Intrinsics.checkNotNullExpressionValue(e, (String)"avatarViews[index]");
            ((ShapeableImageView)e).setVisibility(avatarState.getVisibility());
            Avatar avatar = avatarState.getAvatar();
            ImageView imageView = (ImageView)avatarViews.get(index);
            Injector injector = Injector.get();
            Intrinsics.checkNotNullExpressionValue((Object)injector, (String)"Injector.get()");
            AvatarUtils.loadAvatarIntoView(avatar, imageView, injector.getAppConfigProvider().get());
        }
        ColorStateList colorStateList = ColorStateList.valueOf((int)teamPresenceState.getMessageButtonColor());
        Intrinsics.checkNotNullExpressionValue((Object)colorStateList, (String)"ColorStateList.valueOf(t\u2026State.messageButtonColor)");
        ColorStateList primaryColor = colorStateList;
        MaterialButton materialButton = $this$renderTeamPresence.helpCenterArticleSendMessage;
        boolean bl = false;
        boolean bl3 = false;
        MaterialButton $this$apply = materialButton;
        boolean bl4 = false;
        $this$apply.setText(teamPresenceState.getMessageButtonText());
        $this$apply.setIconResource(teamPresenceState.getMessageButtonIcon());
        $this$apply.setIconTint(primaryColor);
        $this$apply.setRippleColor(primaryColor);
        $this$apply.setOnClickListener(new View.OnClickListener($this$apply, teamPresenceState, primaryColor){
            final /* synthetic */ MaterialButton $this_apply;
            final /* synthetic */ ArticleViewState.TeamPresenceState $teamPresenceState$inlined;
            final /* synthetic */ ColorStateList $primaryColor$inlined;
            {
                this.$this_apply = materialButton;
                this.$teamPresenceState$inlined = teamPresenceState;
                this.$primaryColor$inlined = colorStateList;
            }

            public final void onClick(View it) {
                Injector injector = Injector.get();
                Intrinsics.checkNotNullExpressionValue((Object)injector, (String)"Injector.get()");
                injector.getMetricTracker().clickedNewConversation(this.$teamPresenceState$inlined.getMetricPlace(), this.$teamPresenceState$inlined.getMetricContext());
                this.$this_apply.getContext().startActivity(IntercomMessengerActivity.openComposerFromArticle(this.$this_apply.getContext(), this.$teamPresenceState$inlined.getArticleId()));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ArticleViewState.TeamPresenceState computeViewState(@NotNull String articleId, @NotNull ArticleViewState.TeamPresenceState currentState, @NotNull AppConfig appConfig, @NotNull TeamPresence teamPresence, @NotNull String metricPlace) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)currentState, (String)"currentState");
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"appConfig");
        Intrinsics.checkNotNullParameter((Object)teamPresence, (String)"teamPresence");
        Intrinsics.checkNotNullParameter((Object)metricPlace, (String)"metricPlace");
        int messageButtonText = currentState.getMessageButtonText();
        int messageButtonIcon = currentState.getMessageButtonIcon();
        int messageTitle = currentState.getMessageTitleText();
        int avatarComponentVisibility = 0;
        String metricContext = "style_human";
        if (!appConfig.isAccessToTeammateEnabled()) {
            messageButtonText = R.string.intercom_ask_a_question;
            messageButtonIcon = R.drawable.intercom_conversation_card_question;
            messageTitle = R.string.intercom_bot_expectation_text;
            avatarComponentVisibility = 8;
            metricContext = "style_bot";
        }
        List<Participant> list = teamPresence.getActiveAdmins();
        Intrinsics.checkNotNullExpressionValue(list, (String)"teamPresence.activeAdmins");
        Iterable iterable = CollectionsKt.takeLast(list, (int)3);
        boolean $i$f$map = false;
        void var13_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Participant participant = (Participant)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
            Avatar avatar = v1.getAvatar();
            Intrinsics.checkNotNullExpressionValue((Object)avatar, (String)"it.avatar");
            ArticleViewState.AvatarState avatarState = new ArticleViewState.AvatarState(0, avatar);
            collection.add(avatarState);
        }
        List avatars = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        int n = 3 - avatars.size();
        boolean bl = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int it = n2++;
            boolean bl2 = false;
            Avatar avatar = new Avatar.Builder().build();
            Intrinsics.checkNotNullExpressionValue((Object)avatar, (String)"Avatar.Builder().build()");
            avatars.add(new ArticleViewState.AvatarState(8, avatar));
        }
        n = appConfig.getPrimaryColor();
        String string2 = metricContext;
        String string3 = metricPlace;
        List list2 = avatars;
        int n4 = messageButtonIcon;
        int n5 = messageButtonText;
        int n6 = messageTitle;
        int n7 = avatarComponentVisibility;
        return currentState.copy(articleId, n6, n5, n4, n, n7, list2, string3, string2);
    }
}

