/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.homescreen;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.VisibleForTesting;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.homescreen.BaseConversationCardViewHolder;
import io.intercom.android.sdk.homescreen.ConversationCard;
import io.intercom.android.sdk.homescreen.HomeClickListener;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.FontUtils;
import io.intercom.android.sdk.utilities.TimeFormatter;
import io.intercom.android.sdk.views.InboxRowLayout;
import java.util.List;

public class RecentConversationCardViewHolder
extends BaseConversationCardViewHolder {
    private final LinearLayout inboxLayout;
    private final TextView seePreviousButton;
    private final TextView newConversationButton;
    private final TimeFormatter timeFormatter;
    private final HomeClickListener clickListener;
    @VisibleForTesting
    View.OnClickListener onConversationClicked = new View.OnClickListener(){

        public void onClick(View view) {
            if (view.getTag() instanceof Conversation) {
                Conversation conversation = (Conversation)view.getTag();
                RecentConversationCardViewHolder.this.clickListener.onConversationClicked(conversation);
            }
        }
    };

    RecentConversationCardViewHolder(View itemView, TimeFormatter timeFormatter, Provider<AppConfig> appConfigProvider, HomeClickListener clickListener) {
        super(itemView, appConfigProvider, clickListener);
        this.timeFormatter = timeFormatter;
        this.clickListener = clickListener;
        this.inboxLayout = (LinearLayout)itemView.findViewById(R.id.inbox_layout);
        this.newConversationButton = (TextView)itemView.findViewById(R.id.new_conversation_button);
        this.seePreviousButton = (TextView)itemView.findViewById(R.id.see_previous);
        this.newConversationButton.setOnClickListener(this.onNewConversationClicked);
        this.seePreviousButton.setOnClickListener(this.onSeePreviousClicked);
        ConstraintLayout rootLayout = (ConstraintLayout)itemView.findViewById(R.id.recent_conversation_card_layout);
        this.applyCardBorderStyle((View)rootLayout);
        this.applyNewConversationButtonStyle();
        this.applyAllConversationButtonStyle(this.seePreviousButton);
    }

    private void applyNewConversationButtonStyle() {
        FontUtils.setRobotoMediumTypeface(this.newConversationButton);
        AppConfig appConfig = (AppConfig)this.appConfigProvider.get();
        int primaryColor = appConfig.getPrimaryColor();
        Context context = this.newConversationButton.getContext();
        if (appConfig.primaryColorRenderDarkText()) {
            this.updateButtonBackgroundColor(this.newConversationButton, primaryColor);
        } else {
            Drawable drawable2 = this.newConversationButton.getBackground();
            BackgroundUtils.setRippleButtonStroke(context, drawable2, R.id.background, primaryColor);
        }
        int contentColor = ColorUtils.primaryOrDarkColor(context, appConfig);
        ColorUtils.updateLeftDrawableColor(this.newConversationButton, contentColor);
        this.newConversationButton.setTextColor(contentColor);
    }

    public void bindConversationCard(ConversationCard conversationCard, UserIdentity userIdentity, AppConfig appConfig, TeamPresence teamPresence) {
        Context context = this.inboxLayout.getContext();
        this.inboxLayout.removeAllViews();
        List<Conversation> recentConversations = conversationCard.recentConversations();
        for (int index = 0; index < recentConversations.size() && index <= 2; ++index) {
            InboxRowLayout rowLayout = new InboxRowLayout(context);
            rowLayout.updateVerticalPadding(R.dimen.intercom_home_inbox_vertical_padding);
            Conversation conversation = recentConversations.get(index);
            rowLayout.updateConversation(conversation, userIdentity, appConfig, teamPresence, this.timeFormatter);
            rowLayout.setTag(conversation);
            rowLayout.setOnClickListener(this.onConversationClicked);
            View dividerView = this.createDivider(context);
            if (index > 0) {
                this.inboxLayout.addView(dividerView);
            }
            this.inboxLayout.addView((View)rowLayout);
        }
        boolean hasOlderConversations = conversationCard.hasOlderConversations();
        this.seePreviousButton.setVisibility(hasOlderConversations ? 0 : 8);
        this.showOrHideNewConversationButton(this.newConversationButton);
        this.updateOlderConversationUnreadState(this.seePreviousButton, conversationCard.hasOlderUnreadConversations());
        if (!conversationCard.isTeammateEnabled()) {
            this.newConversationButton.setText(R.string.intercom_ask_a_question);
            this.newConversationButton.setCompoundDrawablesWithIntrinsicBounds(R.drawable.intercom_conversation_card_question, 0, 0, 0);
            this.applyNewConversationButtonStyle();
        }
    }

    private View createDivider(Context context) {
        View dividerView = new View(context);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        int margin = context.getResources().getDimensionPixelSize(R.dimen.intercom_conversation_card_padding);
        params.setMargins(margin, 0, margin, 0);
        dividerView.setLayoutParams((ViewGroup.LayoutParams)params);
        Drawable dividerDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.intercom_list_divider);
        BackgroundUtils.setBackground(dividerView, dividerDrawable);
        return dividerView;
    }
}

