/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.preview;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.api.PollingManager;
import io.intercom.android.sdk.lifecycles.EmptyActivityLifecycleCallbacks;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.MetricType;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Events.ReadEvent;
import io.intercom.android.sdk.models.Events.UnreadConversationsEvent;
import io.intercom.android.sdk.models.Events.realtime.CreateConversationEvent;
import io.intercom.android.sdk.models.Events.realtime.NewCommentEvent;
import io.intercom.android.sdk.preview.IntercomPreviewPosition;
import io.intercom.android.sdk.preview.PreviewDisplayManager;
import io.intercom.android.sdk.utilities.IntercomUtils;
import io.intercom.com.squareup.otto.Bus;
import io.intercom.com.squareup.otto.Subscribe;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=14)
public class PreviewManager
extends EmptyActivityLifecycleCallbacks {
    private final List<Conversation> conversations = new ArrayList<Conversation>();
    private final PreviewDisplayManager displayManager;
    private Activity lastActive;
    private int unreadCount;

    public PreviewManager(Application application, Bus bus, PollingManager pollingManager, PreviewDisplayManager displayManager) {
        this.displayManager = displayManager;
        bus.register((Object)this);
        pollingManager.startPreviewPolling();
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    public void setVisibility(int visibility) {
        this.displayManager.setVisibility(visibility);
        try {
            if (visibility == 0) {
                this.displayManager.conditionallyAddPreview(this.lastActive, this.conversations, this.unreadCount);
            } else {
                this.displayManager.conditionallyRemovePreview(this.lastActive);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setPresentationMode(IntercomPreviewPosition presentationMode) {
        this.displayManager.setPreviewPosition(presentationMode);
    }

    public void reset() {
        this.conversations.clear();
    }

    @Subscribe
    public void unreadConversationsReveived(UnreadConversationsEvent event) {
        IntercomLogger.INTERNAL("chathead", "received unread count update with: " + event.getResponse().getConversations() + " conversations and total unread count of " + event.getResponse().getTotalUnreadCount());
        this.conversations.clear();
        this.conversations.addAll(event.getResponse().getConversations());
        this.unreadCount = event.getResponse().getTotalUnreadCount();
        if (!this.conversations.isEmpty()) {
            Bridge.getMetricsStore().increment(MetricType.CONVERSATION_RECEIVED);
            if (this.displayManager.getVisibility() == 0) {
                Bridge.getMetricsStore().increment(MetricType.CONVERSATION_PREVIEW_SHOWN);
            }
        }
        try {
            this.displayManager.conditionallyAddPreview(this.lastActive, this.conversations, this.unreadCount);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Subscribe
    public void conversationMarkedAsRead(ReadEvent event) {
        for (Conversation conversation : this.conversations) {
            if (!conversation.getId().equals(event.getConversationId())) continue;
            this.conversations.remove(conversation);
            --this.unreadCount;
            break;
        }
        if (this.conversations.size() == 1 && this.unreadCount > this.conversations.size()) {
            this.getUnreadConversations();
        }
    }

    @Subscribe
    public void newComment(NewCommentEvent event) {
        this.realtimeUpdate();
    }

    @Subscribe
    public void newConversation(CreateConversationEvent event) {
        this.realtimeUpdate();
    }

    private void realtimeUpdate() {
        if (!IntercomUtils.isIntercomActivity(this.lastActive)) {
            if (Bridge.getIdentityStore().getAppConfig().isRealTime()) {
                this.getUnreadConversations();
            } else {
                Bridge.getPoller().throttledPreviewPoll();
            }
        }
    }

    private void getUnreadConversations() {
        Bridge.getApi().getUnreadConversations();
        Bridge.getPoller().resetPreviewPoll();
    }

    @Override
    public void onActivityResumed(Activity activity) {
        this.lastActive = activity;
        try {
            this.displayManager.conditionallyAddPreview(activity, this.conversations, this.unreadCount);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onActivityPaused(Activity activity) {
        try {
            this.displayManager.conditionallyRemovePreview(activity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.lastActive = null;
    }
}

