/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import io.intercom.retrofit.RequestInterceptor;

public class HeaderInterceptor
implements RequestInterceptor {
    protected static final String CORDOVA_PREFS = "intercomsdk_cordova_prefs";
    protected static final String CORDOVA_VERSION = "cordova_version";
    protected static final String INTERCOM_AGENT = "X-INTERCOM-AGENT";
    protected static final String INTERCOM_AGENT_WRAPPER = "X-INTERCOM-AGENT-WRAPPER";
    protected static final String ANDROID_HEADER = "intercom-android-sdk/";
    protected static final String CORDOVA_HEADER = "intercom-sdk-cordova/";
    private final String cordovaVersion;

    public HeaderInterceptor(Context context) {
        this.cordovaVersion = context.getSharedPreferences(CORDOVA_PREFS, 0).getString(CORDOVA_VERSION, "");
    }

    public void intercept(RequestInterceptor.RequestFacade request) {
        request.addHeader("Content-Type", "application/json");
        request.addHeader(INTERCOM_AGENT, "intercom-android-sdk/1.1.8");
        if (!this.cordovaVersion.isEmpty()) {
            request.addHeader(INTERCOM_AGENT_WRAPPER, CORDOVA_HEADER + this.cordovaVersion);
        }
    }

    @SuppressLint(value={"CommitPrefEdits"})
    public static void setCordovaVersion(Context context, String cordovaVersion) {
        SharedPreferences prefs = context.getSharedPreferences(CORDOVA_PREFS, 0);
        prefs.edit().putString(CORDOVA_VERSION, cordovaVersion).commit();
    }
}

