/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.BlockAlignment;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.blockInterfaces.ButtonBlock;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.FontUtils;
import io.intercom.android.sdk.utilities.LinkUtil;
import io.intercom.android.sdk.views.ButtonSelector;

public class Button
implements ButtonBlock {
    private final Context context;
    private final LayoutInflater inflater;
    private final StyleType style;

    public Button(Context context, StyleType style) {
        this.context = context;
        this.style = style;
        this.inflater = LayoutInflater.from((Context)context);
    }

    public View addButton(String text, final String buttonUrl, BlockAlignment alignment, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        android.widget.Button button;
        View.OnClickListener clickListener = new View.OnClickListener(){

            public void onClick(View view) {
                LinkUtil.openUrl(buttonUrl, Button.this.context);
            }
        };
        switch (this.style) {
            case ANNOUNCEMENT: {
                button = (android.widget.Button)this.inflater.inflate(R.layout.intercomsdk_blocks_button, parent, false);
                FontUtils.setTypeface((TextView)button, "intercomsdk_roboto_medium.ttf", this.context);
                button.setGravity(17);
                BackgroundUtils.setBackground((View)button, (Drawable)new ButtonSelector(this.context, R.drawable.intercomsdk_button_shape));
                break;
            }
            default: {
                button = StyleType.WELCOME == this.style ? (TextView)this.inflater.inflate(R.layout.intercomsdk_blocks_welcome_button, parent, false) : (TextView)this.inflater.inflate(R.layout.intercomsdk_blocks_admin_paragraph, parent, false);
                button.setTextColor(Color.parseColor((String)Bridge.getIdentityStore().getAppConfig().getBaseColor()));
                button.setPaintFlags(button.getPaintFlags() | 8);
                button.setGravity(alignment.getGravity());
            }
        }
        button.setText((CharSequence)text);
        button.setOnClickListener(clickListener);
        BlockUtils.setLayoutMarginsAndGravity((View)button, alignment.getGravity(), isLastObject);
        return button;
    }
}

