/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.squareup.okhttp.internal.http;

import io.intercom.com.squareup.okhttp.Authenticator;
import io.intercom.com.squareup.okhttp.Challenge;
import io.intercom.com.squareup.okhttp.Credentials;
import io.intercom.com.squareup.okhttp.Request;
import io.intercom.com.squareup.okhttp.Response;
import io.intercom.com.squareup.okhttp.internal.Util;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.util.List;

public final class AuthenticatorAdapter
implements Authenticator {
    public static final Authenticator INSTANCE = new AuthenticatorAdapter();

    @Override
    public Request authenticate(Proxy proxy, Response response) throws IOException {
        List<Challenge> challenges = response.challenges();
        Request request = response.request();
        URL url = request.url();
        int size = challenges.size();
        for (int i = 0; i < size; ++i) {
            PasswordAuthentication auth;
            Challenge challenge = challenges.get(i);
            if (!"Basic".equalsIgnoreCase(challenge.getScheme()) || (auth = java.net.Authenticator.requestPasswordAuthentication(url.getHost(), this.getConnectToInetAddress(proxy, url), Util.getEffectivePort(url), url.getProtocol(), challenge.getRealm(), challenge.getScheme(), url, Authenticator.RequestorType.SERVER)) == null) continue;
            String credential = Credentials.basic(auth.getUserName(), new String(auth.getPassword()));
            return request.newBuilder().header("Authorization", credential).build();
        }
        return null;
    }

    @Override
    public Request authenticateProxy(Proxy proxy, Response response) throws IOException {
        List<Challenge> challenges = response.challenges();
        Request request = response.request();
        URL url = request.url();
        int size = challenges.size();
        for (int i = 0; i < size; ++i) {
            InetSocketAddress proxyAddress;
            PasswordAuthentication auth;
            Challenge challenge = challenges.get(i);
            if (!"Basic".equalsIgnoreCase(challenge.getScheme()) || (auth = java.net.Authenticator.requestPasswordAuthentication((proxyAddress = (InetSocketAddress)proxy.address()).getHostName(), this.getConnectToInetAddress(proxy, url), proxyAddress.getPort(), url.getProtocol(), challenge.getRealm(), challenge.getScheme(), url, Authenticator.RequestorType.PROXY)) == null) continue;
            String credential = Credentials.basic(auth.getUserName(), new String(auth.getPassword()));
            return request.newBuilder().header("Proxy-Authorization", credential).build();
        }
        return null;
    }

    private InetAddress getConnectToInetAddress(Proxy proxy, URL url) throws IOException {
        return proxy != null && proxy.type() != Proxy.Type.DIRECT ? ((InetSocketAddress)proxy.address()).getAddress() : InetAddress.getByName(url.getHost());
    }
}

