/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.Context;
import io.intercom.android.sdk.R;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class TimeUtils {
    public String getFormattedTime(long time, Context context) {
        if (time <= 0L) {
            return context.getResources().getString(R.string.intercomsdk_time_never);
        }
        Date now = new Date();
        Date date = new Date(time * 1000L);
        long diffInMin = TimeUnit.MILLISECONDS.toMinutes(now.getTime() - date.getTime());
        long diffInHours = TimeUnit.MILLISECONDS.toHours(now.getTime() - date.getTime());
        long diffInDays = TimeUnit.MILLISECONDS.toDays(now.getTime() - date.getTime());
        long diffInWeeks = diffInDays / 7L;
        long diffInYears = diffInWeeks / 52L;
        String displayDate = diffInYears > 0L ? context.getResources().getString(R.string.intercomsdk_time_year_ago, new Object[]{diffInYears}) : (diffInWeeks > 0L ? context.getResources().getString(R.string.intercomsdk_time_week_ago, new Object[]{diffInWeeks}) : (diffInDays > 0L ? context.getResources().getString(R.string.intercomsdk_time_day_ago, new Object[]{diffInDays}) : (diffInHours > 0L ? context.getResources().getString(R.string.intercomsdk_time_hour_ago, new Object[]{diffInHours}) : (diffInMin >= 1L ? context.getResources().getString(R.string.intercomsdk_time_minute_ago, new Object[]{diffInMin}) : context.getResources().getString(R.string.intercomsdk_time_just_now)))));
        return displayDate;
    }
}

