/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.view.LayoutInflater;
import android.widget.ImageView;
import com.squareup.picasso.RequestCreator;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.utilities.ImageUtils;

public class Image {
    public static String MIME_TYPE = "image";
    protected final Context context;
    protected final LayoutInflater inflater;
    protected final int maxWidth;

    public Image(Context context) {
        this.context = context;
        this.inflater = LayoutInflater.from((Context)context);
        this.maxWidth = context.getResources().getDimensionPixelSize(R.dimen.intercomsdk_max_image_width);
    }

    protected void setImageViewBounds(int imageWidth, int imageHeight, ImageView imageView, RequestCreator requestCreator) {
        double aspectRatio = ImageUtils.getAspectRatio(imageWidth, imageHeight);
        if (imageWidth > 0 && imageHeight > 0) {
            imageView.setMinimumWidth(Math.min(imageWidth, this.maxWidth));
            imageView.setMinimumHeight((int)Math.min((double)imageHeight, (double)this.maxWidth * aspectRatio));
        }
        requestCreator.resize(this.maxWidth, ImageUtils.getAspectHeight(this.maxWidth, aspectRatio)).onlyScaleDown();
    }

    protected void setBackgroundColor(ImageView imageView) {
        imageView.setBackgroundResource(R.drawable.intercomsdk_rounded_image_preview);
    }
}

