/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.os.Handler;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.Lifecycles;
import io.intercom.android.sdk.logger.Logger;
import java.util.concurrent.TimeUnit;

public class PollingManager {
    private final Handler handler = new Handler();
    private final Handler conversationHandler = new Handler();
    private final Runnable previewPoller = new Runnable(){

        @Override
        public void run() {
            Logger.INTERNAL("polling", "chathead poll");
            Bridge.getApi().getUnreadConversations();
            PollingManager.this.poll(PollingManager.this.handler, PollingManager.this.previewPoller);
        }
    };
    private final Runnable inboxPoller = new Runnable(){

        @Override
        public void run() {
            Logger.INTERNAL("polling", "inbox poll");
            Bridge.getApi().getInbox();
            PollingManager.this.poll(PollingManager.this.handler, PollingManager.this.inboxPoller);
        }
    };
    private Runnable conversationPoller;

    public void startConversationPolling(final String conversationId) {
        Logger.INTERNAL("polling", "starting conversation polling");
        this.conversationPoller = new Runnable(){

            @Override
            public void run() {
                Logger.INTERNAL("polling", "conversation poll");
                Bridge.getApi().getConversation(conversationId);
                PollingManager.this.poll(PollingManager.this.conversationHandler, PollingManager.this.conversationPoller);
            }
        };
        this.poll(this.conversationHandler, this.conversationPoller);
    }

    public void startPreviewPolling() {
        Logger.INTERNAL("polling", "starting chathead polling");
        this.handler.removeCallbacksAndMessages(null);
        this.poll(this.handler, this.previewPoller);
    }

    public void startInboxPolling() {
        Logger.INTERNAL("polling", "starting inbox polling");
        this.handler.removeCallbacksAndMessages(null);
        this.poll(this.handler, this.inboxPoller);
    }

    public void endPolling() {
        Logger.INTERNAL("polling", "ending polling");
        this.handler.removeCallbacksAndMessages(null);
        this.conversationHandler.removeCallbacksAndMessages(null);
    }

    public void endConversationPolling() {
        Logger.INTERNAL("polling", "ending conversation polling");
        this.conversationHandler.removeCallbacks(this.conversationPoller);
    }

    public void resetConversationPoll() {
        Logger.INTERNAL("polling", "resetting conversation poller");
        this.conversationHandler.removeCallbacks(this.conversationPoller);
        this.poll(this.conversationHandler, this.conversationPoller);
    }

    public void resetInboxPoll() {
        Logger.INTERNAL("polling", "resetting inbox poller");
        this.handler.removeCallbacks(this.inboxPoller);
        this.poll(this.handler, this.inboxPoller);
    }

    public void resetPreviewPoll() {
        Logger.INTERNAL("polling", "resetting preview poller");
        this.handler.removeCallbacks(this.previewPoller);
        this.poll(this.handler, this.previewPoller);
    }

    private void poll(Handler handler, Runnable poller) {
        if (!Lifecycles.isAppBackgrounded()) {
            handler.postDelayed(poller, TimeUnit.SECONDS.toMillis(Bridge.getIdentityStore().getAppConfig().getPollingInterval()));
        } else {
            Logger.INTERNAL("polling", "ending polling because app is backgrounded");
        }
    }
}

