/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.content.Context;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Base64;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.squareup.okhttp.Cache;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.CertificatePinner;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.MultipartBuilder;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Transformation;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.annotations.IntercomExclusionStrategy;
import io.intercom.android.sdk.api.BaseCallback;
import io.intercom.android.sdk.api.CallbackHolder;
import io.intercom.android.sdk.api.HeaderInterceptor;
import io.intercom.android.sdk.api.IdentityInterceptor;
import io.intercom.android.sdk.api.IntercomApiInterface;
import io.intercom.android.sdk.api.ProgressRequestBody;
import io.intercom.android.sdk.blocks.Image;
import io.intercom.android.sdk.conversation.UploadProgressListener;
import io.intercom.android.sdk.identity.IdentityStore;
import io.intercom.android.sdk.identity.Registration;
import io.intercom.android.sdk.logger.Logger;
import io.intercom.android.sdk.models.Events.Failure.UploadFailedEvent;
import io.intercom.android.sdk.models.Events.UploadEvent;
import io.intercom.android.sdk.models.api.response.Part;
import io.intercom.android.sdk.models.api.response.ReadResponse;
import io.intercom.android.sdk.models.api.response.Upload;
import io.intercom.android.sdk.models.api.response.UsersResponse;
import io.intercom.android.sdk.transforms.RoundedCornersTransform;
import io.intercom.android.sdk.user.DeviceData;
import io.intercom.android.sdk.utilities.ImageUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.json.JSONObject;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.RetrofitError;
import retrofit.client.Client;
import retrofit.client.OkClient;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;

public class Api {
    private static final String CACHE_NAME = "Intercom_SDK/HttpCache";
    private static final String BASE_URL = "https://mobileapi-v2.intercom.io/oreo";
    private static final String HOSTNAME = "mobileapi-v2.intercom.io";
    private static final int MAX_RETRY_COUNT = 3;
    private static final int INITIAL_RETRY_COUNT = 1;
    private static final int CACHE_SIZE = 0xA00000;
    private static final String USER = "user";
    private static final String DEVICE_TOKEN = "device_token";
    private static final String USER_ATTRIBUTES = "user_attributes";
    private static final String DEVICE_DATA = "device_data";
    private static final String NEW_SESSION = "new_session";
    private static final String HMAC = "hmac";
    private static final String DATA = "data";
    private static final String UPLOAD = "upload";
    private final CallbackHolder callbacks;
    private final Handler retryHandler;
    private IntercomApiInterface intercomApiInterface;
    private boolean synchronous;

    public Api(Context context, boolean synchronous) {
        this.synchronous = synchronous;
        this.intercomApiInterface = (IntercomApiInterface)this.configureRestAdapter(context, synchronous).create(IntercomApiInterface.class);
        this.callbacks = new CallbackHolder();
        this.retryHandler = new Handler();
    }

    public void configureRequestSynchronicity(Context context, boolean hasIntercomId) {
        if (hasIntercomId == this.synchronous) {
            this.synchronous = !hasIntercomId;
            this.intercomApiInterface = (IntercomApiInterface)this.configureRestAdapter(context, this.synchronous).create(IntercomApiInterface.class);
        }
    }

    private RestAdapter configureRestAdapter(Context context, boolean synchronousRequests) {
        File cacheDirectory = new File(context.getCacheDir().getAbsolutePath(), CACHE_NAME);
        OkHttpClient client = new OkHttpClient();
        client.interceptors().add(new IdentityInterceptor());
        client.setCache(new Cache(cacheDirectory, 0xA00000L));
        CertificatePinner certificatePinner = new CertificatePinner.Builder().add(HOSTNAME, new String[]{"sha1/UA4GILe/aHSG/Rz3kv9TYrkQOQk="}).add(HOSTNAME, new String[]{"sha1/UbxPdxcIz+UJ3enqpVSOkcBneFM="}).add(HOSTNAME, new String[]{"sha1/1S4TwavjSdrotJWU73w4Q2BkZr0="}).build();
        client.setCertificatePinner(certificatePinner);
        Gson gson = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new IntercomExclusionStrategy()}).create();
        RestAdapter.Builder a = new RestAdapter.Builder().setEndpoint(BASE_URL).setClient((Client)new OkClient(client)).setConverter((Converter)new GsonConverter(gson)).setRequestInterceptor((RequestInterceptor)new HeaderInterceptor(context));
        if (synchronousRequests) {
            ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
            a.setExecutors((Executor)executorService, (Executor)executorService);
        }
        return a.build();
    }

    public void registerUnidentifiedUser() {
        this.retriableUpdateUser(this.generateUpdateUserParams(DeviceData.generateDeviceData(Bridge.getContext()), true), Bridge.getIdentityStore().getUserIdentityFingerprint(), 1);
    }

    public void registerIdentifiedUser(Registration registration) {
        HashMap<String, Object> deviceData = DeviceData.generateDeviceData(Bridge.getContext());
        if (!registration.getRegistrationId().isEmpty()) {
            deviceData.put(DEVICE_TOKEN, registration.getRegistrationId());
        }
        Map<String, Object> params = this.generateUpdateUserParams(deviceData, true);
        params.put(USER_ATTRIBUTES, registration.getAttributes());
        this.retriableUpdateUser(params, Bridge.getIdentityStore().getUserIdentityFingerprint(), 1);
    }

    public void ping() {
        IdentityStore identityStore = Bridge.getIdentityStore();
        if (identityStore.userIdentityExists() && identityStore.appIdentityExists()) {
            this.retriableUpdateUser(this.generateUpdateUserParams(DeviceData.generateDeviceData(Bridge.getContext()), true), identityStore.getUserIdentityFingerprint(), 1);
        }
    }

    public void setGCMPushKey(String gcmRegistrationId) {
        HashMap<String, Object> deviceData = DeviceData.generateDeviceData(Bridge.getContext());
        deviceData.put(DEVICE_TOKEN, gcmRegistrationId);
        this.retriableUpdateUser(this.generateUpdateUserParams(deviceData, false), Bridge.getIdentityStore().getUserIdentityFingerprint(), 1);
    }

    public void updateUser(Map<String, Object> attributes) {
        Map<String, Object> params = this.generateUpdateUserParams(DeviceData.generateDeviceData(Bridge.getContext()), false);
        params.put(USER_ATTRIBUTES, attributes);
        this.retriableUpdateUser(params, Bridge.getIdentityStore().getUserIdentityFingerprint(), 1);
    }

    private void retriableUpdateUser(final Map<String, Object> params, final String fingerprint, final int retryCount) {
        this.intercomApiInterface.updateUser(this.getBasicAuth(), params, (retrofit.Callback<UsersResponse.Builder>)new BaseCallback<UsersResponse.Builder>(){

            public void success(UsersResponse.Builder builder, retrofit.client.Response response) {
                if (fingerprint.equals(Bridge.getIdentityStore().getUserIdentityFingerprint())) {
                    Logger.INFO("Successfully registered or updated user");
                    Api.this.callbacks.unreadCallback().success((Object)builder, response);
                }
            }

            @Override
            public void failure(RetrofitError error) {
                1.logError(error.getResponse(), "Failed to register or update user.");
                Map user = (Map)params.get(Api.USER);
                if (Api.isUserNotFound(error, user)) {
                    user.remove("intercom_id");
                    params.put(Api.USER, user);
                    Api.this.retriableUpdateUser(params, fingerprint, retryCount);
                } else if (retryCount <= 3 && Api.isRetriable(error)) {
                    Api.this.retryHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            Api.this.retriableUpdateUser(params, fingerprint, retryCount + 1);
                        }
                    }, (long)Api.getRetryTimer(retryCount));
                }
            }
        });
    }

    public void logEvent(String name, Map<String, Object> metaData) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        params.put(USER, Bridge.getIdentityStore().getUserMap());
        eventParams.put("event_name", name);
        if (!metaData.isEmpty()) {
            eventParams.put("metadata", metaData);
        }
        params.put("event", eventParams);
        this.addSecureHash(params);
        this.retriableLogEvent(params, Bridge.getIdentityStore().getUserIdentityFingerprint(), 1);
    }

    private void retriableLogEvent(final Map<String, Object> params, final String fingerprint, final int retryCount) {
        this.intercomApiInterface.logEvent(this.getBasicAuth(), params, (retrofit.Callback<UsersResponse.Builder>)new BaseCallback<UsersResponse.Builder>(){

            public void success(UsersResponse.Builder builder, retrofit.client.Response response) {
                if (fingerprint.equals(Bridge.getIdentityStore().getUserIdentityFingerprint())) {
                    Logger.INFO("Successfully logged event");
                    Api.this.callbacks.unreadCallback().success((Object)builder, response);
                }
            }

            @Override
            public void failure(RetrofitError error) {
                2.logError(error.getResponse(), "Failed to log event");
                if (retryCount <= 3 && Api.isRetriable(error)) {
                    Api.this.retryHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            Api.this.retriableLogEvent(params, fingerprint, retryCount + 1);
                        }
                    }, (long)Api.getRetryTimer(retryCount));
                }
            }
        });
    }

    public void markConversationAsRead(String conversationId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", Bridge.getIdentityStore().getAppId());
        params.put(USER, Bridge.getIdentityStore().getUserMap());
        this.addSecureHash(params);
        this.retriableMarkAsRead(conversationId, params, Bridge.getIdentityStore().getUserIdentityFingerprint(), 1);
    }

    private void retriableMarkAsRead(final String conversationId, final Map<String, Object> params, final String fingerprint, final int retryCount) {
        this.intercomApiInterface.markAsRead(conversationId, this.getBasicAuth(), params, (retrofit.Callback<ReadResponse.Builder>)new BaseCallback<ReadResponse.Builder>(){

            public void success(ReadResponse.Builder builder, retrofit.client.Response response) {
                if (fingerprint.equals(Bridge.getIdentityStore().getUserIdentityFingerprint())) {
                    Logger.INTERNAL("API Success", "Successfully marked as read");
                    Api.this.callbacks.readCallback(conversationId).success((Object)builder, response);
                }
            }

            @Override
            public void failure(RetrofitError error) {
                super.failure(error);
                if (retryCount <= 3 && Api.isRetriable(error)) {
                    Api.this.retryHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            Api.this.retriableMarkAsRead(conversationId, params, fingerprint, retryCount + 1);
                        }
                    }, (long)Api.getRetryTimer(retryCount));
                }
            }
        });
    }

    public void sendLWRResponse(String conversationId, String replyType, String replyOption) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("reply_type", replyType);
        params.put("reply_option", replyOption);
        params.put(USER, Bridge.getIdentityStore().getUserMap());
        this.addSecureHash(params);
        this.retriableSendLwrResponse(conversationId, params, 1);
    }

    private void retriableSendLwrResponse(final String conversationId, final Map<String, Object> params, final int retryCount) {
        this.intercomApiInterface.replyToConversation(conversationId, this.getBasicAuth(), params, (retrofit.Callback<Part.Builder>)new BaseCallback<Part.Builder>(){

            public void success(Part.Builder builder, retrofit.client.Response response) {
                Logger.INTERNAL("API Success", "Successfully sent LWR");
            }

            @Override
            public void failure(RetrofitError error) {
                super.failure(error);
                if (retryCount <= 3 && Api.isRetriable(error)) {
                    Api.this.retryHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            Api.this.retriableSendLwrResponse(conversationId, params, retryCount + 1);
                        }
                    }, (long)Api.getRetryTimer(retryCount));
                }
            }
        });
    }

    public void getInbox() {
        Map<String, Object> params = Bridge.getIdentityStore().getUserMap();
        params.put("per_page", "20");
        this.addSecureHash(params);
        this.intercomApiInterface.getConversations(this.getBasicAuth(), params, this.callbacks.inboxCallback());
    }

    public void getInboxBefore(long before) {
        Map<String, Object> params = Bridge.getIdentityStore().getUserMap();
        params.put("before", String.valueOf(before));
        params.put("per_page", "20");
        this.addSecureHash(params);
        this.intercomApiInterface.getConversations(this.getBasicAuth(), params, this.callbacks.inboxCallback());
    }

    public void getUnreadConversations() {
        Map<String, Object> params = Bridge.getIdentityStore().getUserMap();
        params.put("per_page", "20");
        this.addSecureHash(params);
        this.intercomApiInterface.getUnreadConversations(this.getBasicAuth(), params, this.callbacks.unreadCallback());
    }

    public void getConversation(String conversationId) {
        Map<String, Object> params = Bridge.getIdentityStore().getUserMap();
        this.addSecureHash(params);
        this.intercomApiInterface.getConversation(conversationId, this.getBasicAuth(), params, this.callbacks.conversationCallback());
    }

    public void textReply(String conversationId, String messageText, int tempPartPosition, String tempPartId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", Bridge.getIdentityStore().getAppId());
        params.put("type", USER);
        params.put("message_type", "comment");
        params.put("body", messageText);
        params.put(USER, Bridge.getIdentityStore().getUserMap());
        this.addSecureHash(params);
        this.intercomApiInterface.replyToConversation(conversationId, this.getBasicAuth(), params, this.callbacks.replyCallback(tempPartPosition, false, tempPartId, conversationId));
    }

    public void attachmentReply(String conversationId, int uploadId, int tempPartPosition, String tempPartId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", Bridge.getIdentityStore().getAppId());
        params.put("type", USER);
        params.put("message_type", "comment");
        params.put("upload_ids", new int[]{uploadId});
        params.put(USER, Bridge.getIdentityStore().getUserMap());
        this.addSecureHash(params);
        this.intercomApiInterface.replyToConversation(conversationId, this.getBasicAuth(), params, this.callbacks.replyCallback(tempPartPosition, true, tempPartId, conversationId));
    }

    public void startNewConversation(String messageText, int position, String tempPartId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", Bridge.getIdentityStore().getAppId());
        params.put("body", messageText);
        params.put(USER, Bridge.getIdentityStore().getUserMap());
        this.addSecureHash(params);
        this.intercomApiInterface.startNewConversation(this.getBasicAuth(), params, this.callbacks.newConversationCallback(position, tempPartId));
    }

    public void startNewAttachmentConversation(int uploadId, int position, String tempPartId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", Bridge.getIdentityStore().getAppId());
        params.put("upload_ids", new int[]{uploadId});
        params.put(USER, Bridge.getIdentityStore().getUserMap());
        this.addSecureHash(params);
        this.intercomApiInterface.startNewConversation(this.getBasicAuth(), params, this.callbacks.newConversationCallback(position, tempPartId));
    }

    public void uploadFile(final File file, final String originalFileName, long size, final String mimeType, final int width, final int height, final int tempPartPosition, final String tempPartId, final UploadProgressListener listener, final Context context) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Object> uploadMap = new HashMap<String, Object>();
        uploadMap.put("original_filename", originalFileName);
        uploadMap.put("size_in_bytes", size);
        uploadMap.put("content_type", mimeType);
        uploadMap.put("width", width);
        uploadMap.put("height", height);
        params.put(UPLOAD, uploadMap);
        params.put(USER, Bridge.getIdentityStore().getUserMap());
        this.addSecureHash(params);
        this.intercomApiInterface.uploadFile(this.getBasicAuth(), params, (retrofit.Callback<Upload.Builder>)new BaseCallback<Upload.Builder>(){

            public void success(Upload.Builder builder, retrofit.client.Response response) {
                final Upload uploadResponse = builder.build();
                if (mimeType.contains(Image.MIME_TYPE)) {
                    int maxWidth = context.getResources().getDimensionPixelSize(R.dimen.intercomsdk_max_image_width);
                    Picasso.with((Context)context).load(file).stableKey(uploadResponse.getPublicUrl()).resize(maxWidth, ImageUtils.getAspectHeight(maxWidth, ImageUtils.getAspectRatio(width, height))).transform((Transformation)new RoundedCornersTransform(context.getResources().getDimensionPixelSize(R.dimen.intercomsdk_image_rounded_corners))).onlyScaleDown().fetch();
                }
                RequestBody requestBody = new MultipartBuilder().type(MultipartBuilder.FORM).addFormDataPart("key", uploadResponse.getKey()).addFormDataPart("acl", uploadResponse.getAcl()).addFormDataPart("Content-Type", uploadResponse.getContentType()).addFormDataPart("AWSAccessKeyId", uploadResponse.getAwsAccessKey()).addFormDataPart("policy", uploadResponse.getPolicy()).addFormDataPart("signature", uploadResponse.getSignature()).addFormDataPart("success_action_status", uploadResponse.getSuccessActionStatus()).addFormDataPart("file", originalFileName, (RequestBody)new ProgressRequestBody(MediaType.parse((String)mimeType), file, listener)).build();
                new OkHttpClient().newCall(new Request.Builder().url(uploadResponse.getUploadDestination()).post(requestBody).build()).enqueue(new Callback(){

                    public void onFailure(Request request, IOException e) {
                        Logger.ERROR("Upload failed: request body " + request.body());
                        Bridge.getBus().post((Object)new UploadFailedEvent(tempPartPosition, tempPartId));
                    }

                    public void onResponse(Response response) {
                        Logger.INTERNAL("API Success", "Successfully uploaded");
                        if (response.isSuccessful()) {
                            Bridge.getBus().post((Object)new UploadEvent(uploadResponse.getId(), tempPartPosition, tempPartId));
                        } else {
                            Logger.ERROR("Upload failed: request body " + response.body());
                            Bridge.getBus().post((Object)new UploadFailedEvent(tempPartPosition, tempPartId));
                        }
                        try {
                            response.body().close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
                Logger.INTERNAL("API Success", "Successfully uploaded");
            }

            @Override
            public void failure(RetrofitError error) {
                5.logError(error.getResponse(), "Upload failed");
                Bridge.getBus().post((Object)new UploadFailedEvent(tempPartPosition, tempPartId));
            }
        });
    }

    public void getVideo(String url, Callback callback) {
        new OkHttpClient().newCall(new Request.Builder().url(url).build()).enqueue(callback);
    }

    public void hitTrackingUrl(String url) {
        new OkHttpClient().newCall(new Request.Builder().url(url).build()).enqueue(new Callback(){

            public void onFailure(Request request, IOException e) {
                Logger.INTERNAL("Tracking Url", "Failed tracking url request");
            }

            public void onResponse(Response response) {
                try {
                    response.body().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    protected static int getRetryTimer(int count) {
        return (int)(Math.pow(2.0, count) * 1000.0);
    }

    protected static boolean isUserNotFound(RetrofitError error, Map userParams) {
        if (error.getResponse() != null && error.getResponse().getStatus() == 404 && userParams != null && userParams.get("intercom_id") != null && userParams.size() > 1 && error.getResponse().getBody() != null) {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(error.getResponse().getBody().in()));
                StringBuilder out = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    out.append(line);
                }
                reader.close();
                String errorString = out.toString();
                JSONObject errorObject = new JSONObject(errorString);
                if (errorObject.getJSONArray("errors").getJSONObject(0).getString("code").equals("not_found")) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    protected static boolean isRetriable(RetrofitError error) {
        if (error.getResponse() != null) {
            int status = error.getResponse().getStatus();
            return status < 400 || status >= 500;
        }
        IdentityStore store = Bridge.getIdentityStore();
        return store.appIdentityExists() && store.userIdentityExists();
    }

    private String getBasicAuth() {
        return "Basic " + Base64.encodeToString((byte[])(Bridge.getIdentityStore().getAppId() + ":" + Bridge.getIdentityStore().getApiKey()).getBytes(), (int)2);
    }

    private void addSecureHash(Map<String, Object> params) {
        IdentityStore identityStore = Bridge.getIdentityStore();
        String secureData = identityStore.getData();
        String secureHmac = identityStore.getHmac();
        if (!TextUtils.isEmpty((CharSequence)secureData) && !TextUtils.isEmpty((CharSequence)secureHmac)) {
            params.put(DATA, secureData);
            params.put(HMAC, secureHmac);
        }
    }

    private Map<String, Object> generateUpdateUserParams(Map<String, Object> deviceData, boolean newSession) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, Bridge.getIdentityStore().getUserMap());
        params.put(DEVICE_DATA, deviceData);
        params.put(NEW_SESSION, newSession);
        this.addSecureHash(params);
        return params;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }
}

