/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.retrofit;

import io.intercom.retrofit.mime.TypedInput;
import java.io.IOException;
import java.io.InputStream;

class ExceptionCatchingTypedInput
implements TypedInput {
    private final TypedInput delegate;
    private final ExceptionCatchingInputStream delegateStream;

    ExceptionCatchingTypedInput(TypedInput delegate) throws IOException {
        this.delegate = delegate;
        this.delegateStream = new ExceptionCatchingInputStream(delegate.in());
    }

    @Override
    public String mimeType() {
        return this.delegate.mimeType();
    }

    @Override
    public long length() {
        return this.delegate.length();
    }

    @Override
    public InputStream in() throws IOException {
        return this.delegateStream;
    }

    IOException getThrownException() {
        return this.delegateStream.thrownException;
    }

    boolean threwException() {
        return this.delegateStream.thrownException != null;
    }

    private static class ExceptionCatchingInputStream
    extends InputStream {
        private final InputStream delegate;
        private IOException thrownException;

        ExceptionCatchingInputStream(InputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public int read() throws IOException {
            try {
                return this.delegate.read();
            }
            catch (IOException e) {
                this.thrownException = e;
                throw e;
            }
        }

        @Override
        public int read(byte[] buffer) throws IOException {
            try {
                return this.delegate.read(buffer);
            }
            catch (IOException e) {
                this.thrownException = e;
                throw e;
            }
        }

        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException {
            try {
                return this.delegate.read(buffer, offset, length);
            }
            catch (IOException e) {
                this.thrownException = e;
                throw e;
            }
        }

        @Override
        public long skip(long byteCount) throws IOException {
            try {
                return this.delegate.skip(byteCount);
            }
            catch (IOException e) {
                this.thrownException = e;
                throw e;
            }
        }

        @Override
        public int available() throws IOException {
            try {
                return this.delegate.available();
            }
            catch (IOException e) {
                this.thrownException = e;
                throw e;
            }
        }

        @Override
        public void close() throws IOException {
            try {
                this.delegate.close();
            }
            catch (IOException e) {
                this.thrownException = e;
                throw e;
            }
        }

        @Override
        public synchronized void mark(int readLimit) {
            this.delegate.mark(readLimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            try {
                this.delegate.reset();
            }
            catch (IOException e) {
                this.thrownException = e;
                throw e;
            }
        }

        @Override
        public boolean markSupported() {
            return this.delegate.markSupported();
        }
    }
}

