/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.text.TextUtils;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.api.BaseCallback;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.models.BaseResponse;
import io.intercom.android.sdk.models.Config;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.ConversationsResponse;
import io.intercom.android.sdk.models.Events.ConversationEvent;
import io.intercom.android.sdk.models.Events.Failure.InboxFailedEvent;
import io.intercom.android.sdk.models.Events.Failure.NewConversationFailedEvent;
import io.intercom.android.sdk.models.Events.Failure.ReplyFailedEvent;
import io.intercom.android.sdk.models.Events.InboxEvent;
import io.intercom.android.sdk.models.Events.NewConversationEvent;
import io.intercom.android.sdk.models.Events.ReadEvent;
import io.intercom.android.sdk.models.Events.ReplyEvent;
import io.intercom.android.sdk.models.Events.UnreadConversationsEvent;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.ReadResponse;
import io.intercom.android.sdk.models.User;
import io.intercom.android.sdk.models.UserAndConfigResponse;
import io.intercom.android.sdk.models.UsersResponse;
import io.intercom.retrofit.Callback;
import io.intercom.retrofit.RetrofitError;

public class CallbackHolder {
    public BaseCallback<UserAndConfigResponse.Builder> userAndConfigCallback(final String successMessage, final String failureMessage) {
        return new BaseCallback<UserAndConfigResponse.Builder>(){

            @Override
            public void onSuccess(UserAndConfigResponse.Builder responseBuilder) {
                CallbackHolder.this.updateBaseResponseObjects(responseBuilder.build());
                if (!TextUtils.isEmpty((CharSequence)successMessage)) {
                    IntercomLogger.INFO(successMessage);
                }
            }

            @Override
            public void onFailure(RetrofitError error) {
                if (!TextUtils.isEmpty((CharSequence)failureMessage)) {
                    IntercomLogger.ERROR(failureMessage + error.getMessage());
                }
            }
        };
    }

    public BaseCallback<ReadResponse.Builder> readCallback(final String conversationId) {
        return new BaseCallback<ReadResponse.Builder>(){

            @Override
            public void onSuccess(ReadResponse.Builder builder) {
                ReadResponse response = builder.build();
                CallbackHolder.this.updateBaseResponseObjects(response);
                Bridge.getBus().post((Object)new ReadEvent(conversationId));
            }
        };
    }

    public BaseCallback<UsersResponse.Builder> unreadCallback() {
        return new BaseCallback<UsersResponse.Builder>(){

            @Override
            public void onSuccess(UsersResponse.Builder responseBuilder) {
                UsersResponse response = responseBuilder.build();
                CallbackHolder.this.updateBaseResponseObjects(response);
                Bridge.getBus().post((Object)new UnreadConversationsEvent(response.getUnreadConversations()));
            }
        };
    }

    public Callback<ConversationsResponse.Builder> inboxCallback() {
        return new BaseCallback<ConversationsResponse.Builder>(){

            @Override
            public void onSuccess(ConversationsResponse.Builder builder) {
                ConversationsResponse response = builder.build();
                CallbackHolder.this.updateBaseResponseObjects(response);
                Bridge.getBus().post((Object)new InboxEvent(response.getConversationPage()));
            }

            @Override
            public void onFailure(RetrofitError error) {
                Bridge.getBus().post((Object)new InboxFailedEvent());
            }
        };
    }

    public Callback<Part.Builder> replyCallback(final int position, final boolean isUpload, final String partId, final String conversationId) {
        return new BaseCallback<Part.Builder>(){

            @Override
            public void onSuccess(Part.Builder builder) {
                Bridge.getBus().post((Object)new ReplyEvent(builder.build(), position, partId, conversationId));
            }

            @Override
            public void onFailure(RetrofitError error) {
                Bridge.getBus().post((Object)new ReplyFailedEvent(position, isUpload, partId));
            }
        };
    }

    public Callback<Conversation.Builder> conversationCallback() {
        return new BaseCallback<Conversation.Builder>(){

            @Override
            public void onSuccess(Conversation.Builder builder) {
                Bridge.getBus().post((Object)new ConversationEvent(builder.build()));
            }
        };
    }

    public Callback<Conversation.Builder> newConversationCallback(final int position, final String partId) {
        return new BaseCallback<Conversation.Builder>(){

            @Override
            public void onSuccess(Conversation.Builder builder) {
                Bridge.getBus().post((Object)new NewConversationEvent(builder.build(), partId));
            }

            @Override
            public void onFailure(RetrofitError error) {
                Bridge.getBus().post((Object)new NewConversationFailedEvent(position, partId));
            }
        };
    }

    private void updateBaseResponseObjects(BaseResponse response) {
        this.updateIdentityStore(response.getUser());
        this.updateAppConfig(response.getConfig());
    }

    private void updateIdentityStore(User user) {
        Bridge.getIdentityStore().setUser(user);
    }

    private void updateAppConfig(Config config) {
        Bridge.getIdentityStore().setAppConfig(config);
    }
}

