/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.util.Base64;
import io.intercom.android.sdk.Bridge;
import io.intercom.com.squareup.okhttp.Interceptor;
import io.intercom.com.squareup.okhttp.Request;
import io.intercom.com.squareup.okhttp.Response;
import java.io.IOException;

public class HeaderInterceptor
implements Interceptor {
    private static final String CORDOVA_PREFS = "intercomsdk_cordova_prefs";
    private static final String CORDOVA_VERSION = "cordova_version";
    private static final String INTERCOM_AGENT = "X-INTERCOM-AGENT";
    private static final String INTERCOM_AGENT_WRAPPER = "X-INTERCOM-AGENT-WRAPPER";
    private static final String ANDROID_HEADER = "intercom-android-sdk/";
    private static final String CORDOVA_HEADER = "intercom-sdk-cordova/";
    private static final String AUTHORIZATION = "Authorization";
    private static final String CONTENT_TYPE_KEY = "Content-Type";
    private static final String CONTENT_TYPE_VALUE = "application/json";
    private final String cordovaVersion;

    public HeaderInterceptor(Context context) {
        this.cordovaVersion = context.getSharedPreferences(CORDOVA_PREFS, 0).getString(CORDOVA_VERSION, "");
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request.Builder requestBuilder = chain.request().newBuilder().header(CONTENT_TYPE_KEY, CONTENT_TYPE_VALUE).header(AUTHORIZATION, this.getBasicAuth()).header(INTERCOM_AGENT, "intercom-android-sdk/1.1.18");
        if (!this.cordovaVersion.isEmpty()) {
            requestBuilder.header(INTERCOM_AGENT_WRAPPER, CORDOVA_HEADER + this.cordovaVersion);
        }
        Request build = requestBuilder.build();
        return chain.proceed(build);
    }

    private String getBasicAuth() {
        return "Basic " + Base64.encodeToString((byte[])(Bridge.getIdentityStore().getAppId() + ":" + Bridge.getIdentityStore().getApiKey()).getBytes(), (int)2);
    }

    @SuppressLint(value={"CommitPrefEdits"})
    public static void setCordovaVersion(Context context, String cordovaVersion) {
        SharedPreferences prefs = context.getSharedPreferences(CORDOVA_PREFS, 0);
        prefs.edit().putString(CORDOVA_VERSION, cordovaVersion).commit();
    }
}

