/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.content.Context;
import android.text.TextUtils;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.annotations.IntercomExclusionStrategy;
import io.intercom.android.sdk.api.BaseCallback;
import io.intercom.android.sdk.api.CallbackHolder;
import io.intercom.android.sdk.api.HeaderInterceptor;
import io.intercom.android.sdk.api.IdentityInterceptor;
import io.intercom.android.sdk.api.IntercomApiInterface;
import io.intercom.android.sdk.api.ProgressRequestBody;
import io.intercom.android.sdk.api.RetryInterceptor;
import io.intercom.android.sdk.blocks.Image;
import io.intercom.android.sdk.commons.utilities.DeviceUtils;
import io.intercom.android.sdk.conversation.UploadProgressListener;
import io.intercom.android.sdk.identity.IdentityStore;
import io.intercom.android.sdk.identity.Registration;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.models.Events.Failure.UploadFailedEvent;
import io.intercom.android.sdk.models.Events.UploadEvent;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.Upload;
import io.intercom.android.sdk.models.UsersResponse;
import io.intercom.android.sdk.transforms.RoundedCornersTransform;
import io.intercom.android.sdk.user.DeviceData;
import io.intercom.android.sdk.utilities.ImageUtils;
import io.intercom.com.google.gson.ExclusionStrategy;
import io.intercom.com.google.gson.Gson;
import io.intercom.com.google.gson.GsonBuilder;
import io.intercom.com.squareup.okhttp.Cache;
import io.intercom.com.squareup.okhttp.CertificatePinner;
import io.intercom.com.squareup.okhttp.MediaType;
import io.intercom.com.squareup.okhttp.MultipartBuilder;
import io.intercom.com.squareup.okhttp.OkHttpClient;
import io.intercom.com.squareup.okhttp.Request;
import io.intercom.com.squareup.okhttp.RequestBody;
import io.intercom.com.squareup.picasso.Picasso;
import io.intercom.com.squareup.picasso.Transformation;
import io.intercom.retrofit.Callback;
import io.intercom.retrofit.RestAdapter;
import io.intercom.retrofit.RetrofitError;
import io.intercom.retrofit.client.Client;
import io.intercom.retrofit.client.OkClient;
import io.intercom.retrofit.client.Response;
import io.intercom.retrofit.converter.Converter;
import io.intercom.retrofit.converter.GsonConverter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class Api {
    private static final String CACHE_NAME = "Intercom_SDK/HttpCache";
    private static final String PROTOCOL = "https://";
    private static final String PARTIAL_HOSTNAME = ".mobile-sdk-api.intercom.io";
    private static final String ENDPOINT = "/oreo";
    private static final int CACHE_SIZE = 0xA00000;
    private static final String USER = "user";
    private static final String DEVICE_TOKEN = "device_token";
    private static final String USER_ATTRIBUTES = "user_attributes";
    private static final String DEVICE_DATA = "device_data";
    private static final String NEW_SESSION = "new_session";
    private static final String HMAC = "hmac";
    private static final String DATA = "data";
    private static final String UPLOAD = "upload";
    public static final int MAX_DNS_SEGMENT_SIZE = 63;
    private final CallbackHolder callbacks;
    private final String appId;
    private IntercomApiInterface intercomApiInterface;
    private boolean synchronous;

    public Api(Context context, String appId, boolean synchronous) {
        this.appId = appId;
        this.synchronous = synchronous;
        this.intercomApiInterface = this.createIntercomApiInterface(context);
        this.callbacks = new CallbackHolder();
    }

    public void configureRequestSynchronicity(Context context, boolean hasIntercomId) {
        if (hasIntercomId == this.synchronous) {
            this.synchronous = !hasIntercomId;
            this.intercomApiInterface = this.createIntercomApiInterface(context);
        }
    }

    protected IntercomApiInterface createIntercomApiInterface(Context context) {
        return (IntercomApiInterface)this.configureRestAdapter(context, this.synchronous).create(IntercomApiInterface.class);
    }

    private RestAdapter configureRestAdapter(Context context, boolean synchronousRequests) {
        File cacheDirectory = new File(context.getCacheDir().getAbsolutePath(), CACHE_NAME);
        OkHttpClient client = new OkHttpClient();
        client.setConnectTimeout(2L, TimeUnit.MINUTES);
        client.setReadTimeout(2L, TimeUnit.MINUTES);
        client.setWriteTimeout(2L, TimeUnit.MINUTES);
        client.interceptors().add(new IdentityInterceptor());
        client.interceptors().add(new RetryInterceptor(new RetryInterceptor.Sleeper()));
        client.networkInterceptors().add(new HeaderInterceptor(context));
        String hostname = Api.getFullHostname(DeviceUtils.getAppVersion((Context)context), this.appId);
        client.setCache(new Cache(cacheDirectory, 0xA00000L));
        CertificatePinner certificatePinner = new CertificatePinner.Builder().add(hostname, new String[]{"sha1/BiCgk94N+oILO/VULX+wYS6gWKU="}).build();
        client.setCertificatePinner(certificatePinner);
        Gson gson = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new IntercomExclusionStrategy()}).create();
        RestAdapter.Builder a = new RestAdapter.Builder().setEndpoint(Api.convertHostnameToUrl(hostname)).setClient((Client)new OkClient(client)).setConverter((Converter)new GsonConverter(gson));
        if (synchronousRequests) {
            ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
            a.setExecutors((Executor)executorService, (Executor)executorService);
        }
        return a.build();
    }

    public void registerUnidentifiedUser() {
        this.retriableUpdateUser(this.generateUpdateUserParams(DeviceData.generateDeviceData(Bridge.getContext()), true), Bridge.getIdentityStore().getUserIdentityFingerprint());
    }

    public void registerIdentifiedUser(Registration registration) {
        Map<String, Object> deviceData = DeviceData.generateDeviceData(Bridge.getContext());
        if (!registration.getRegistrationId().isEmpty()) {
            deviceData.put(DEVICE_TOKEN, registration.getRegistrationId());
        }
        Map<String, Object> params = this.generateUpdateUserParams(deviceData, true);
        params.put(USER_ATTRIBUTES, registration.getAttributes());
        this.retriableUpdateUser(params, Bridge.getIdentityStore().getUserIdentityFingerprint());
    }

    public void ping() {
        IdentityStore identityStore = Bridge.getIdentityStore();
        if (identityStore.userIdentityExists() && identityStore.appIdentityExists()) {
            this.retriableUpdateUser(this.generateUpdateUserParams(DeviceData.generateDeviceData(Bridge.getContext()), true), identityStore.getUserIdentityFingerprint());
        }
    }

    public void setGCMPushKey(String gcmRegistrationId) {
        Map<String, Object> deviceData = DeviceData.generateDeviceData(Bridge.getContext());
        deviceData.put(DEVICE_TOKEN, gcmRegistrationId);
        this.retriableUpdateUser(this.generateUpdateUserParams(deviceData, false), Bridge.getIdentityStore().getUserIdentityFingerprint());
    }

    public void removeGCMDeviceToken(String token) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, Bridge.getIdentityStore().getUserMap());
        params.put(DEVICE_TOKEN, token);
        this.intercomApiInterface.deleteDeviceToken(params, new Callback<UsersResponse.Builder>(){

            public void success(UsersResponse.Builder builder, Response response) {
            }

            public void failure(RetrofitError error) {
            }
        });
    }

    public void updateUser(Map<String, ?> attributes) {
        Map<String, Object> params = this.generateUpdateUserParams(DeviceData.generateDeviceData(Bridge.getContext()), false);
        params.put(USER_ATTRIBUTES, attributes);
        this.retriableUpdateUser(params, Bridge.getIdentityStore().getUserIdentityFingerprint());
    }

    protected void retriableUpdateUser(final Map<String, Object> params, final String fingerprint) {
        this.intercomApiInterface.updateUser(params, (Callback<UsersResponse.Builder>)new BaseCallback<UsersResponse.Builder>(){

            @Override
            public void onSuccess(UsersResponse.Builder builder) {
                if (fingerprint.equals(Bridge.getIdentityStore().getUserIdentityFingerprint())) {
                    IntercomLogger.INFO("Successfully registered or updated user");
                    Api.this.callbacks.unreadCallback().onSuccess(builder);
                }
            }

            @Override
            public void onFailure(RetrofitError error) {
                Map user = (Map)params.get(Api.USER);
                if (Api.isUserNotFound(error, user)) {
                    user.remove("intercom_id");
                    params.put(Api.USER, user);
                    Api.this.retriableUpdateUser(params, fingerprint);
                }
            }

            @Override
            void logFailure(String reason, RetrofitError error) {
                super.logFailure("Failed to register or update user", error);
            }
        });
    }

    public void logEvent(String name, Map<String, ?> metaData) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        params.put(USER, Bridge.getIdentityStore().getUserMap());
        eventParams.put("event_name", name);
        if (!metaData.isEmpty()) {
            eventParams.put("metadata", metaData);
        }
        params.put("event", eventParams);
        this.addSecureHash(params);
        this.intercomApiInterface.logEvent(params, this.callbacks.unreadCallback());
    }

    public void markConversationAsRead(String conversationId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", Bridge.getIdentityStore().getAppId());
        params.put(USER, Bridge.getIdentityStore().getUserMap());
        this.addSecureHash(params);
        this.intercomApiInterface.markAsRead(conversationId, params, this.callbacks.readCallback(conversationId));
    }

    public void sendLWRResponse(String conversationId, String replyType, String replyOption) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("reply_type", replyType);
        params.put("reply_option", replyOption);
        params.put(USER, Bridge.getIdentityStore().getUserMap());
        this.addSecureHash(params);
        this.intercomApiInterface.replyToConversation(conversationId, params, new Callback<Part.Builder>(){

            public void success(Part.Builder builder, Response response) {
                IntercomLogger.INTERNAL("API Success", "Successfully sent LWR");
            }

            public void failure(RetrofitError error) {
                IntercomLogger.INTERNAL("API Failure", "Sending LWR failed");
            }
        });
    }

    public void getInbox() {
        Map<String, Object> params = Bridge.getIdentityStore().getUserMap();
        params.put("per_page", "20");
        this.addSecureHash(params);
        this.intercomApiInterface.getConversations(params, this.callbacks.inboxCallback());
    }

    public void getInboxBefore(long before) {
        Map<String, Object> params = Bridge.getIdentityStore().getUserMap();
        params.put("before", String.valueOf(before));
        params.put("per_page", "20");
        this.addSecureHash(params);
        this.intercomApiInterface.getConversations(params, this.callbacks.inboxCallback());
    }

    public void getUnreadConversations() {
        Map<String, Object> params = Bridge.getIdentityStore().getUserMap();
        params.put("per_page", "20");
        this.addSecureHash(params);
        this.intercomApiInterface.getUnreadConversations(params, this.callbacks.unreadCallback());
    }

    public void getConversation(String conversationId) {
        Map<String, Object> params = Bridge.getIdentityStore().getUserMap();
        this.addSecureHash(params);
        this.intercomApiInterface.getConversation(conversationId, params, this.callbacks.conversationCallback());
    }

    public void textReply(String conversationId, String messageText, int tempPartPosition, String tempPartId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", Bridge.getIdentityStore().getAppId());
        params.put("type", USER);
        params.put("message_type", "comment");
        params.put("body", messageText);
        params.put(USER, Bridge.getIdentityStore().getUserMap());
        this.addSecureHash(params);
        this.intercomApiInterface.replyToConversation(conversationId, params, this.callbacks.replyCallback(tempPartPosition, false, tempPartId, conversationId));
    }

    public void attachmentReply(String conversationId, int uploadId, int tempPartPosition, String tempPartId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", Bridge.getIdentityStore().getAppId());
        params.put("type", USER);
        params.put("message_type", "comment");
        params.put("upload_ids", new int[]{uploadId});
        params.put(USER, Bridge.getIdentityStore().getUserMap());
        this.addSecureHash(params);
        this.intercomApiInterface.replyToConversation(conversationId, params, this.callbacks.replyCallback(tempPartPosition, true, tempPartId, conversationId));
    }

    public void startNewConversation(String messageText, int position, String tempPartId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", Bridge.getIdentityStore().getAppId());
        params.put("body", messageText);
        params.put(USER, Bridge.getIdentityStore().getUserMap());
        this.addSecureHash(params);
        this.intercomApiInterface.startNewConversation(params, this.callbacks.newConversationCallback(position, tempPartId));
    }

    public void startNewAttachmentConversation(int uploadId, int position, String tempPartId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", Bridge.getIdentityStore().getAppId());
        params.put("upload_ids", new int[]{uploadId});
        params.put(USER, Bridge.getIdentityStore().getUserMap());
        this.addSecureHash(params);
        this.intercomApiInterface.startNewConversation(params, this.callbacks.newConversationCallback(position, tempPartId));
    }

    public void uploadFile(final File file, final String originalFileName, long size, final String mimeType, final int width, final int height, final int tempPartPosition, final String tempPartId, final UploadProgressListener listener, final Context context) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Object> uploadMap = new HashMap<String, Object>();
        uploadMap.put("original_filename", originalFileName);
        uploadMap.put("size_in_bytes", size);
        uploadMap.put("content_type", mimeType);
        uploadMap.put("width", width);
        uploadMap.put("height", height);
        params.put(UPLOAD, uploadMap);
        params.put(USER, Bridge.getIdentityStore().getUserMap());
        this.addSecureHash(params);
        this.intercomApiInterface.uploadFile(params, (Callback<Upload.Builder>)new BaseCallback<Upload.Builder>(){

            @Override
            public void onSuccess(Upload.Builder builder) {
                final Upload uploadResponse = builder.build();
                if (mimeType.contains(Image.MIME_TYPE)) {
                    int maxWidth = context.getResources().getDimensionPixelSize(R.dimen.intercomsdk_max_image_width);
                    Picasso.with((Context)context).load(file).stableKey(uploadResponse.getPublicUrl()).resize(maxWidth, ImageUtils.getAspectHeight(maxWidth, ImageUtils.getAspectRatio(width, height))).transform((Transformation)new RoundedCornersTransform(context.getResources().getDimensionPixelSize(R.dimen.intercomsdk_image_rounded_corners))).onlyScaleDown().fetch();
                }
                RequestBody requestBody = new MultipartBuilder().type(MultipartBuilder.FORM).addFormDataPart("key", uploadResponse.getKey()).addFormDataPart("acl", uploadResponse.getAcl()).addFormDataPart("Content-Type", uploadResponse.getContentType()).addFormDataPart("AWSAccessKeyId", uploadResponse.getAwsAccessKey()).addFormDataPart("policy", uploadResponse.getPolicy()).addFormDataPart("signature", uploadResponse.getSignature()).addFormDataPart("success_action_status", uploadResponse.getSuccessActionStatus()).addFormDataPart("file", originalFileName, (RequestBody)new ProgressRequestBody(MediaType.parse((String)mimeType), file, listener)).build();
                new OkHttpClient().newCall(new Request.Builder().url(uploadResponse.getUploadDestination()).post(requestBody).build()).enqueue(new io.intercom.com.squareup.okhttp.Callback(){

                    public void onFailure(Request request, IOException e) {
                        IntercomLogger.ERROR("Upload failed: request body " + request.body());
                        Bridge.getBus().post((Object)new UploadFailedEvent(tempPartPosition, tempPartId));
                    }

                    public void onResponse(io.intercom.com.squareup.okhttp.Response response) {
                        IntercomLogger.INTERNAL("API Success", "Successfully uploaded");
                        if (response.isSuccessful()) {
                            Bridge.getBus().post((Object)new UploadEvent(uploadResponse.getId(), tempPartPosition, tempPartId));
                        } else {
                            IntercomLogger.ERROR("Upload failed: request body " + response.body());
                            Bridge.getBus().post((Object)new UploadFailedEvent(tempPartPosition, tempPartId));
                        }
                        try {
                            response.body().close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
                IntercomLogger.INTERNAL("API Success", "Successfully uploaded");
            }

            @Override
            public void onFailure(RetrofitError error) {
                Bridge.getBus().post((Object)new UploadFailedEvent(tempPartPosition, tempPartId));
            }

            @Override
            void logFailure(String reason, RetrofitError error) {
                super.logFailure("Upload failed", error);
            }
        });
    }

    public void getVideo(String url, io.intercom.com.squareup.okhttp.Callback callback) {
        new OkHttpClient().newCall(new Request.Builder().url(url).build()).enqueue(callback);
    }

    public void hitTrackingUrl(String url) {
        new OkHttpClient().newCall(new Request.Builder().url(url).build()).enqueue(new io.intercom.com.squareup.okhttp.Callback(){

            public void onFailure(Request request, IOException e) {
                IntercomLogger.INTERNAL("Tracking Url", "Failed tracking url request");
            }

            public void onResponse(io.intercom.com.squareup.okhttp.Response response) {
                try {
                    response.body().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    static String convertHostnameToUrl(String hostname) {
        return PROTOCOL + hostname + ENDPOINT;
    }

    static String getFullHostname(String version, String appId) {
        return Api.createUniqueIdentifier(version, appId) + PARTIAL_HOSTNAME;
    }

    static String createUniqueIdentifier(String version, String appId) {
        String result = appId + "-android" + TextUtils.join((CharSequence)"-", (Object[])version.replaceAll("[^\\d]", "").split(""));
        if (result.length() > 63) {
            result = result.substring(0, 63);
        }
        return result;
    }

    protected static int getRetryTimer(int count) {
        return (int)(Math.pow(2.0, count) * 1000.0);
    }

    protected static boolean isUserNotFound(RetrofitError error, Map userParams) {
        if (error.getResponse() != null && error.getResponse().getStatus() == 404 && userParams != null && userParams.get("intercom_id") != null && userParams.size() > 1 && error.getResponse().getBody() != null) {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(error.getResponse().getBody().in()));
                StringBuilder out = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    out.append(line);
                }
                reader.close();
                String errorString = out.toString();
                JSONObject errorObject = new JSONObject(errorString);
                if (errorObject.getJSONArray("errors").getJSONObject(0).getString("code").equals("not_found")) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private void addSecureHash(Map<String, Object> params) {
        IdentityStore identityStore = Bridge.getIdentityStore();
        String secureData = identityStore.getData();
        String secureHmac = identityStore.getHmac();
        if (!TextUtils.isEmpty((CharSequence)secureData) && !TextUtils.isEmpty((CharSequence)secureHmac)) {
            params.put(DATA, secureData);
            params.put(HMAC, secureHmac);
        }
    }

    private Map<String, Object> generateUpdateUserParams(Map<String, Object> deviceData, boolean newSession) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, Bridge.getIdentityStore().getUserMap());
        params.put(DEVICE_DATA, deviceData);
        params.put(NEW_SESSION, newSession);
        Map<String, Integer> countMetrics = Bridge.getMetricsStore().getMap();
        params.put("count_metrics", countMetrics);
        this.addSecureHash(params);
        return params;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }
}

