/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.squareup.okhttp.internal.framed;

import io.intercom.com.squareup.okhttp.Protocol;
import io.intercom.com.squareup.okhttp.internal.Internal;
import io.intercom.com.squareup.okhttp.internal.NamedRunnable;
import io.intercom.com.squareup.okhttp.internal.Util;
import io.intercom.com.squareup.okhttp.internal.framed.ErrorCode;
import io.intercom.com.squareup.okhttp.internal.framed.FrameReader;
import io.intercom.com.squareup.okhttp.internal.framed.FrameWriter;
import io.intercom.com.squareup.okhttp.internal.framed.FramedStream;
import io.intercom.com.squareup.okhttp.internal.framed.Header;
import io.intercom.com.squareup.okhttp.internal.framed.HeadersMode;
import io.intercom.com.squareup.okhttp.internal.framed.Http2;
import io.intercom.com.squareup.okhttp.internal.framed.Ping;
import io.intercom.com.squareup.okhttp.internal.framed.PushObserver;
import io.intercom.com.squareup.okhttp.internal.framed.Settings;
import io.intercom.com.squareup.okhttp.internal.framed.Spdy3;
import io.intercom.com.squareup.okhttp.internal.framed.Variant;
import io.intercom.okio.Buffer;
import io.intercom.okio.BufferedSink;
import io.intercom.okio.BufferedSource;
import io.intercom.okio.ByteString;
import io.intercom.okio.Okio;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public final class FramedConnection
implements Closeable {
    private static final ExecutorService executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory("OkHttp FramedConnection", true));
    final Protocol protocol;
    final boolean client;
    private final Listener listener;
    private final Map<Integer, FramedStream> streams = new HashMap<Integer, FramedStream>();
    private final String hostName;
    private int lastGoodStreamId;
    private int nextStreamId;
    private boolean shutdown;
    private long idleStartTimeNs = System.nanoTime();
    private final ExecutorService pushExecutor;
    private Map<Integer, Ping> pings;
    private final PushObserver pushObserver;
    private int nextPingId;
    long unacknowledgedBytesRead = 0L;
    long bytesLeftInWriteWindow;
    Settings okHttpSettings = new Settings();
    private static final int OKHTTP_CLIENT_WINDOW_SIZE = 0x1000000;
    final Settings peerSettings = new Settings();
    private boolean receivedInitialPeerSettings = false;
    final Variant variant;
    final Socket socket;
    final FrameWriter frameWriter;
    final Reader readerRunnable;
    private final Set<Integer> currentPushRequests = new LinkedHashSet<Integer>();

    private FramedConnection(Builder builder) throws IOException {
        this.protocol = builder.protocol;
        this.pushObserver = builder.pushObserver;
        this.client = builder.client;
        this.listener = builder.listener;
        int n = this.nextStreamId = builder.client ? 1 : 2;
        if (builder.client && this.protocol == Protocol.HTTP_2) {
            this.nextStreamId += 2;
        }
        int n2 = this.nextPingId = builder.client ? 1 : 2;
        if (builder.client) {
            this.okHttpSettings.set(7, 0, 0x1000000);
        }
        this.hostName = builder.hostName;
        if (this.protocol == Protocol.HTTP_2) {
            this.variant = new Http2();
            this.pushExecutor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), Util.threadFactory(String.format("OkHttp %s Push Observer", this.hostName), true));
            this.peerSettings.set(7, 0, 65535);
            this.peerSettings.set(5, 0, 16384);
        } else if (this.protocol == Protocol.SPDY_3) {
            this.variant = new Spdy3();
            this.pushExecutor = null;
        } else {
            throw new AssertionError((Object)this.protocol);
        }
        this.bytesLeftInWriteWindow = this.peerSettings.getInitialWindowSize(65536);
        this.socket = builder.socket;
        this.frameWriter = this.variant.newWriter(builder.sink, this.client);
        this.readerRunnable = new Reader(this.variant.newReader(builder.source, this.client));
        new Thread(this.readerRunnable).start();
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public synchronized int openStreamCount() {
        return this.streams.size();
    }

    synchronized FramedStream getStream(int id) {
        return this.streams.get(id);
    }

    synchronized FramedStream removeStream(int streamId) {
        FramedStream stream = this.streams.remove(streamId);
        if (stream != null && this.streams.isEmpty()) {
            this.setIdle(true);
        }
        this.notifyAll();
        return stream;
    }

    private synchronized void setIdle(boolean value) {
        this.idleStartTimeNs = value ? System.nanoTime() : Long.MAX_VALUE;
    }

    public synchronized boolean isIdle() {
        return this.idleStartTimeNs != Long.MAX_VALUE;
    }

    public synchronized int maxConcurrentStreams() {
        return this.peerSettings.getMaxConcurrentStreams(Integer.MAX_VALUE);
    }

    public synchronized long getIdleStartTimeNs() {
        return this.idleStartTimeNs;
    }

    public FramedStream pushStream(int associatedStreamId, List<Header> requestHeaders, boolean out) throws IOException {
        if (this.client) {
            throw new IllegalStateException("Client cannot push requests.");
        }
        if (this.protocol != Protocol.HTTP_2) {
            throw new IllegalStateException("protocol != HTTP_2");
        }
        return this.newStream(associatedStreamId, requestHeaders, out, false);
    }

    public FramedStream newStream(List<Header> requestHeaders, boolean out, boolean in) throws IOException {
        return this.newStream(0, requestHeaders, out, in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FramedStream newStream(int associatedStreamId, List<Header> requestHeaders, boolean out, boolean in) throws IOException {
        FramedStream stream;
        boolean outFinished = !out;
        boolean inFinished = !in;
        FrameWriter frameWriter = this.frameWriter;
        synchronized (frameWriter) {
            int streamId;
            FramedConnection framedConnection = this;
            synchronized (framedConnection) {
                if (this.shutdown) {
                    throw new IOException("shutdown");
                }
                streamId = this.nextStreamId;
                this.nextStreamId += 2;
                stream = new FramedStream(streamId, this, outFinished, inFinished, requestHeaders);
                if (stream.isOpen()) {
                    this.streams.put(streamId, stream);
                    this.setIdle(false);
                }
            }
            if (associatedStreamId == 0) {
                this.frameWriter.synStream(outFinished, inFinished, streamId, associatedStreamId, requestHeaders);
            } else {
                if (this.client) {
                    throw new IllegalArgumentException("client streams shouldn't have associated stream IDs");
                }
                this.frameWriter.pushPromise(associatedStreamId, streamId, requestHeaders);
            }
        }
        if (!out) {
            this.frameWriter.flush();
        }
        return stream;
    }

    void writeSynReply(int streamId, boolean outFinished, List<Header> alternating) throws IOException {
        this.frameWriter.synReply(outFinished, streamId, alternating);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeData(int streamId, boolean outFinished, Buffer buffer, long byteCount) throws IOException {
        if (byteCount == 0L) {
            this.frameWriter.data(outFinished, streamId, buffer, 0);
            return;
        }
        while (byteCount > 0L) {
            int toWrite;
            FramedConnection framedConnection = this;
            synchronized (framedConnection) {
                try {
                    while (this.bytesLeftInWriteWindow <= 0L) {
                        if (!this.streams.containsKey(streamId)) {
                            throw new IOException("stream closed");
                        }
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
                toWrite = (int)Math.min(byteCount, this.bytesLeftInWriteWindow);
                toWrite = Math.min(toWrite, this.frameWriter.maxDataLength());
                this.bytesLeftInWriteWindow -= (long)toWrite;
            }
            this.frameWriter.data(outFinished && (byteCount -= (long)toWrite) == 0L, streamId, buffer, toWrite);
        }
    }

    void addBytesToWriteWindow(long delta) {
        this.bytesLeftInWriteWindow += delta;
        if (delta > 0L) {
            this.notifyAll();
        }
    }

    void writeSynResetLater(final int streamId, final ErrorCode errorCode) {
        executor.submit(new NamedRunnable("OkHttp %s stream %d", new Object[]{this.hostName, streamId}){

            @Override
            public void execute() {
                try {
                    FramedConnection.this.writeSynReset(streamId, errorCode);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    void writeSynReset(int streamId, ErrorCode statusCode) throws IOException {
        this.frameWriter.rstStream(streamId, statusCode);
    }

    void writeWindowUpdateLater(final int streamId, final long unacknowledgedBytesRead) {
        executor.execute(new NamedRunnable("OkHttp Window Update %s stream %d", new Object[]{this.hostName, streamId}){

            @Override
            public void execute() {
                try {
                    FramedConnection.this.frameWriter.windowUpdate(streamId, unacknowledgedBytesRead);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ping ping() throws IOException {
        int pingId;
        Ping ping = new Ping();
        FramedConnection framedConnection = this;
        synchronized (framedConnection) {
            if (this.shutdown) {
                throw new IOException("shutdown");
            }
            pingId = this.nextPingId;
            this.nextPingId += 2;
            if (this.pings == null) {
                this.pings = new HashMap<Integer, Ping>();
            }
            this.pings.put(pingId, ping);
        }
        this.writePing(false, pingId, 1330343787, ping);
        return ping;
    }

    private void writePingLater(final boolean reply, final int payload1, final int payload2, final Ping ping) {
        executor.execute(new NamedRunnable("OkHttp %s ping %08x%08x", new Object[]{this.hostName, payload1, payload2}){

            @Override
            public void execute() {
                try {
                    FramedConnection.this.writePing(reply, payload1, payload2, ping);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePing(boolean reply, int payload1, int payload2, Ping ping) throws IOException {
        FrameWriter frameWriter = this.frameWriter;
        synchronized (frameWriter) {
            if (ping != null) {
                ping.send();
            }
            this.frameWriter.ping(reply, payload1, payload2);
        }
    }

    private synchronized Ping removePing(int id) {
        return this.pings != null ? this.pings.remove(id) : null;
    }

    public void flush() throws IOException {
        this.frameWriter.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(ErrorCode statusCode) throws IOException {
        FrameWriter frameWriter = this.frameWriter;
        synchronized (frameWriter) {
            int lastGoodStreamId;
            FramedConnection framedConnection = this;
            synchronized (framedConnection) {
                if (this.shutdown) {
                    return;
                }
                this.shutdown = true;
                lastGoodStreamId = this.lastGoodStreamId;
            }
            this.frameWriter.goAway(lastGoodStreamId, statusCode, Util.EMPTY_BYTE_ARRAY);
        }
    }

    @Override
    public void close() throws IOException {
        this.close(ErrorCode.NO_ERROR, ErrorCode.CANCEL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(ErrorCode connectionCode, ErrorCode streamCode) throws IOException {
        assert (!Thread.holdsLock(this));
        IOException thrown = null;
        try {
            this.shutdown(connectionCode);
        }
        catch (IOException e) {
            thrown = e;
        }
        FramedStream[] streamsToClose = null;
        Ping[] pingsToCancel = null;
        FramedStream[] framedStreamArray = this;
        synchronized (this) {
            block19: {
                if (!this.streams.isEmpty()) {
                    streamsToClose = this.streams.values().toArray(new FramedStream[this.streams.size()]);
                    this.streams.clear();
                    super.setIdle(false);
                }
                if (this.pings != null) {
                    pingsToCancel = this.pings.values().toArray(new Ping[this.pings.size()]);
                    this.pings = null;
                }
                // ** MonitorExit[framedStreamArray] (shouldn't be in output)
                if (streamsToClose != null) {
                    for (FramedStream framedStream : streamsToClose) {
                        try {
                            framedStream.close(streamCode);
                        }
                        catch (IOException e) {
                            if (thrown == null) continue;
                            thrown = e;
                        }
                    }
                }
                if (pingsToCancel != null) {
                    for (FramedStream framedStream : pingsToCancel) {
                        ((Ping)((Object)framedStream)).cancel();
                    }
                }
                try {
                    this.frameWriter.close();
                }
                catch (IOException e) {
                    if (thrown != null) break block19;
                    thrown = e;
                }
            }
            try {
                this.socket.close();
            }
            catch (IOException e) {
                thrown = e;
            }
            if (thrown != null) {
                throw thrown;
            }
            return;
        }
    }

    public void sendConnectionPreface() throws IOException {
        this.frameWriter.connectionPreface();
        this.frameWriter.settings(this.okHttpSettings);
        int windowSize = this.okHttpSettings.getInitialWindowSize(65536);
        if (windowSize != 65536) {
            this.frameWriter.windowUpdate(0, windowSize - 65536);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSettings(Settings settings) throws IOException {
        FrameWriter frameWriter = this.frameWriter;
        synchronized (frameWriter) {
            FramedConnection framedConnection = this;
            synchronized (framedConnection) {
                if (this.shutdown) {
                    throw new IOException("shutdown");
                }
                this.okHttpSettings.merge(settings);
                this.frameWriter.settings(settings);
            }
        }
    }

    private boolean pushedStream(int streamId) {
        return this.protocol == Protocol.HTTP_2 && streamId != 0 && (streamId & 1) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushRequestLater(final int streamId, final List<Header> requestHeaders) {
        FramedConnection framedConnection = this;
        synchronized (framedConnection) {
            if (this.currentPushRequests.contains(streamId)) {
                this.writeSynResetLater(streamId, ErrorCode.PROTOCOL_ERROR);
                return;
            }
            this.currentPushRequests.add(streamId);
        }
        this.pushExecutor.execute(new NamedRunnable("OkHttp %s Push Request[%s]", new Object[]{this.hostName, streamId}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                block5: {
                    boolean cancel = FramedConnection.this.pushObserver.onRequest(streamId, requestHeaders);
                    try {
                        if (!cancel) break block5;
                        FramedConnection.this.frameWriter.rstStream(streamId, ErrorCode.CANCEL);
                        FramedConnection framedConnection = FramedConnection.this;
                        synchronized (framedConnection) {
                            FramedConnection.this.currentPushRequests.remove(streamId);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private void pushHeadersLater(final int streamId, final List<Header> requestHeaders, final boolean inFinished) {
        this.pushExecutor.execute(new NamedRunnable("OkHttp %s Push Headers[%s]", new Object[]{this.hostName, streamId}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                block6: {
                    boolean cancel = FramedConnection.this.pushObserver.onHeaders(streamId, requestHeaders, inFinished);
                    try {
                        if (cancel) {
                            FramedConnection.this.frameWriter.rstStream(streamId, ErrorCode.CANCEL);
                        }
                        if (!cancel && !inFinished) break block6;
                        FramedConnection framedConnection = FramedConnection.this;
                        synchronized (framedConnection) {
                            FramedConnection.this.currentPushRequests.remove(streamId);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private void pushDataLater(final int streamId, BufferedSource source, final int byteCount, final boolean inFinished) throws IOException {
        final Buffer buffer = new Buffer();
        source.require(byteCount);
        source.read(buffer, byteCount);
        if (buffer.size() != (long)byteCount) {
            throw new IOException(buffer.size() + " != " + byteCount);
        }
        this.pushExecutor.execute(new NamedRunnable("OkHttp %s Push Data[%s]", new Object[]{this.hostName, streamId}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                block6: {
                    try {
                        boolean cancel = FramedConnection.this.pushObserver.onData(streamId, buffer, byteCount, inFinished);
                        if (cancel) {
                            FramedConnection.this.frameWriter.rstStream(streamId, ErrorCode.CANCEL);
                        }
                        if (!cancel && !inFinished) break block6;
                        FramedConnection framedConnection = FramedConnection.this;
                        synchronized (framedConnection) {
                            FramedConnection.this.currentPushRequests.remove(streamId);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private void pushResetLater(final int streamId, final ErrorCode errorCode) {
        this.pushExecutor.execute(new NamedRunnable("OkHttp %s Push Reset[%s]", new Object[]{this.hostName, streamId}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                FramedConnection.this.pushObserver.onReset(streamId, errorCode);
                FramedConnection framedConnection = FramedConnection.this;
                synchronized (framedConnection) {
                    FramedConnection.this.currentPushRequests.remove(streamId);
                }
            }
        });
    }

    public static abstract class Listener {
        public static final Listener REFUSE_INCOMING_STREAMS = new Listener(){

            @Override
            public void onStream(FramedStream stream) throws IOException {
                stream.close(ErrorCode.REFUSED_STREAM);
            }
        };

        public abstract void onStream(FramedStream var1) throws IOException;

        public void onSettings(FramedConnection connection) {
        }
    }

    class Reader
    extends NamedRunnable
    implements FrameReader.Handler {
        final FrameReader frameReader;

        private Reader(FrameReader frameReader) {
            super("OkHttp %s", FramedConnection.this.hostName);
            this.frameReader = frameReader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void execute() {
            ErrorCode connectionErrorCode = ErrorCode.INTERNAL_ERROR;
            ErrorCode streamErrorCode = ErrorCode.INTERNAL_ERROR;
            try {
                if (!FramedConnection.this.client) {
                    this.frameReader.readConnectionPreface();
                }
                while (this.frameReader.nextFrame(this)) {
                }
                connectionErrorCode = ErrorCode.NO_ERROR;
                streamErrorCode = ErrorCode.CANCEL;
            }
            catch (IOException e) {
                connectionErrorCode = ErrorCode.PROTOCOL_ERROR;
                streamErrorCode = ErrorCode.PROTOCOL_ERROR;
            }
            finally {
                try {
                    FramedConnection.this.close(connectionErrorCode, streamErrorCode);
                }
                catch (IOException iOException) {}
                Util.closeQuietly(this.frameReader);
            }
        }

        @Override
        public void data(boolean inFinished, int streamId, BufferedSource source, int length) throws IOException {
            if (FramedConnection.this.pushedStream(streamId)) {
                FramedConnection.this.pushDataLater(streamId, source, length, inFinished);
                return;
            }
            FramedStream dataStream = FramedConnection.this.getStream(streamId);
            if (dataStream == null) {
                FramedConnection.this.writeSynResetLater(streamId, ErrorCode.INVALID_STREAM);
                source.skip(length);
                return;
            }
            dataStream.receiveData(source, length);
            if (inFinished) {
                dataStream.receiveFin();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void headers(boolean outFinished, boolean inFinished, int streamId, int associatedStreamId, List<Header> headerBlock, HeadersMode headersMode) {
            FramedStream stream;
            if (FramedConnection.this.pushedStream(streamId)) {
                FramedConnection.this.pushHeadersLater(streamId, headerBlock, inFinished);
                return;
            }
            FramedConnection framedConnection = FramedConnection.this;
            synchronized (framedConnection) {
                if (FramedConnection.this.shutdown) {
                    return;
                }
                stream = FramedConnection.this.getStream(streamId);
                if (stream == null) {
                    if (headersMode.failIfStreamAbsent()) {
                        FramedConnection.this.writeSynResetLater(streamId, ErrorCode.INVALID_STREAM);
                        return;
                    }
                    if (streamId <= FramedConnection.this.lastGoodStreamId) {
                        return;
                    }
                    if (streamId % 2 == FramedConnection.this.nextStreamId % 2) {
                        return;
                    }
                    final FramedStream newStream = new FramedStream(streamId, FramedConnection.this, outFinished, inFinished, headerBlock);
                    FramedConnection.this.lastGoodStreamId = streamId;
                    FramedConnection.this.streams.put(streamId, newStream);
                    executor.execute(new NamedRunnable("OkHttp %s stream %d", new Object[]{FramedConnection.this.hostName, streamId}){

                        @Override
                        public void execute() {
                            try {
                                FramedConnection.this.listener.onStream(newStream);
                            }
                            catch (IOException e) {
                                Internal.logger.log(Level.INFO, "FramedConnection.Listener failure for " + FramedConnection.this.hostName, e);
                                try {
                                    newStream.close(ErrorCode.PROTOCOL_ERROR);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                    });
                    return;
                }
            }
            if (headersMode.failIfStreamPresent()) {
                stream.closeLater(ErrorCode.PROTOCOL_ERROR);
                FramedConnection.this.removeStream(streamId);
                return;
            }
            stream.receiveHeaders(headerBlock, headersMode);
            if (inFinished) {
                stream.receiveFin();
            }
        }

        @Override
        public void rstStream(int streamId, ErrorCode errorCode) {
            if (FramedConnection.this.pushedStream(streamId)) {
                FramedConnection.this.pushResetLater(streamId, errorCode);
                return;
            }
            FramedStream rstStream = FramedConnection.this.removeStream(streamId);
            if (rstStream != null) {
                rstStream.receiveRstStream(errorCode);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void settings(boolean clearPrevious, Settings newSettings) {
            long delta = 0L;
            FramedStream[] streamsToNotify = null;
            FramedConnection framedConnection = FramedConnection.this;
            synchronized (framedConnection) {
                int peerInitialWindowSize;
                int priorWriteWindowSize = FramedConnection.this.peerSettings.getInitialWindowSize(65536);
                if (clearPrevious) {
                    FramedConnection.this.peerSettings.clear();
                }
                FramedConnection.this.peerSettings.merge(newSettings);
                if (FramedConnection.this.getProtocol() == Protocol.HTTP_2) {
                    this.ackSettingsLater(newSettings);
                }
                if ((peerInitialWindowSize = FramedConnection.this.peerSettings.getInitialWindowSize(65536)) != -1 && peerInitialWindowSize != priorWriteWindowSize) {
                    delta = peerInitialWindowSize - priorWriteWindowSize;
                    if (!FramedConnection.this.receivedInitialPeerSettings) {
                        FramedConnection.this.addBytesToWriteWindow(delta);
                        FramedConnection.this.receivedInitialPeerSettings = true;
                    }
                    if (!FramedConnection.this.streams.isEmpty()) {
                        streamsToNotify = FramedConnection.this.streams.values().toArray(new FramedStream[FramedConnection.this.streams.size()]);
                    }
                }
                executor.execute(new NamedRunnable("OkHttp %s settings", new Object[]{FramedConnection.this.hostName}){

                    @Override
                    public void execute() {
                        FramedConnection.this.listener.onSettings(FramedConnection.this);
                    }
                });
            }
            if (streamsToNotify != null && delta != 0L) {
                framedConnection = streamsToNotify;
                int n = ((FramedConnection)framedConnection).length;
                for (int i = 0; i < n; ++i) {
                    FramedConnection stream;
                    FramedConnection framedConnection2 = stream = framedConnection[i];
                    synchronized (framedConnection2) {
                        ((FramedStream)((Object)stream)).addBytesToWriteWindow(delta);
                        continue;
                    }
                }
            }
        }

        private void ackSettingsLater(final Settings peerSettings) {
            executor.execute(new NamedRunnable("OkHttp %s ACK Settings", new Object[]{FramedConnection.this.hostName}){

                @Override
                public void execute() {
                    try {
                        FramedConnection.this.frameWriter.ackSettings(peerSettings);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }

        @Override
        public void ackSettings() {
        }

        @Override
        public void ping(boolean reply, int payload1, int payload2) {
            if (reply) {
                Ping ping = FramedConnection.this.removePing(payload1);
                if (ping != null) {
                    ping.receive();
                }
            } else {
                FramedConnection.this.writePingLater(true, payload1, payload2, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void goAway(int lastGoodStreamId, ErrorCode errorCode, ByteString debugData) {
            if (debugData.size() > 0) {
                // empty if block
            }
            FramedStream[] framedStreamArray = FramedConnection.this;
            synchronized (FramedConnection.this) {
                FramedStream[] streamsCopy = FramedConnection.this.streams.values().toArray(new FramedStream[FramedConnection.this.streams.size()]);
                FramedConnection.this.shutdown = true;
                // ** MonitorExit[var4_4] (shouldn't be in output)
                for (FramedStream framedStream : streamsCopy) {
                    if (framedStream.getId() <= lastGoodStreamId || !framedStream.isLocallyInitiated()) continue;
                    framedStream.receiveRstStream(ErrorCode.REFUSED_STREAM);
                    FramedConnection.this.removeStream(framedStream.getId());
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowUpdate(int streamId, long windowSizeIncrement) {
            if (streamId == 0) {
                FramedConnection framedConnection = FramedConnection.this;
                synchronized (framedConnection) {
                    FramedConnection.this.bytesLeftInWriteWindow += windowSizeIncrement;
                    FramedConnection.this.notifyAll();
                }
            }
            FramedStream stream = FramedConnection.this.getStream(streamId);
            if (stream != null) {
                FramedStream framedStream = stream;
                synchronized (framedStream) {
                    stream.addBytesToWriteWindow(windowSizeIncrement);
                }
            }
        }

        @Override
        public void priority(int streamId, int streamDependency, int weight, boolean exclusive) {
        }

        @Override
        public void pushPromise(int streamId, int promisedStreamId, List<Header> requestHeaders) {
            FramedConnection.this.pushRequestLater(promisedStreamId, requestHeaders);
        }

        @Override
        public void alternateService(int streamId, String origin, ByteString protocol, String host, int port, long maxAge) {
        }
    }

    public static class Builder {
        private Socket socket;
        private String hostName;
        private BufferedSource source;
        private BufferedSink sink;
        private Listener listener = Listener.REFUSE_INCOMING_STREAMS;
        private Protocol protocol = Protocol.SPDY_3;
        private PushObserver pushObserver = PushObserver.CANCEL;
        private boolean client;

        public Builder(boolean client) throws IOException {
            this.client = client;
        }

        public Builder socket(Socket socket) throws IOException {
            return this.socket(socket, ((InetSocketAddress)socket.getRemoteSocketAddress()).getHostName(), Okio.buffer(Okio.source(socket)), Okio.buffer(Okio.sink(socket)));
        }

        public Builder socket(Socket socket, String hostName, BufferedSource source, BufferedSink sink) {
            this.socket = socket;
            this.hostName = hostName;
            this.source = source;
            this.sink = sink;
            return this;
        }

        public Builder listener(Listener listener) {
            this.listener = listener;
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder pushObserver(PushObserver pushObserver) {
            this.pushObserver = pushObserver;
            return this;
        }

        public FramedConnection build() throws IOException {
            return new FramedConnection(this);
        }
    }
}

