/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.nexus;

import android.annotation.TargetApi;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.LruCache;
import io.intercom.android.sdk.nexus.NexusConfig;
import io.intercom.android.sdk.nexus.NexusEvent;
import io.intercom.android.sdk.nexus.NexusListener;
import io.intercom.android.sdk.nexus.NexusLogger;
import io.intercom.android.sdk.nexus.NexusSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;

@TargetApi(value=14)
public class NexusClient {
    private final LruCache<String, Boolean> cache = new LruCache(100);
    private final List<NexusListener> listeners = new CopyOnWriteArrayList<NexusListener>();
    private final List<NexusSocket> sockets = new ArrayList<NexusSocket>();
    private long presenceInterval;
    private Handler backgroundHandler;

    public NexusClient() {
        HandlerThread bgThread = new HandlerThread("background-handler");
        bgThread.start();
        this.backgroundHandler = new Handler(bgThread.getLooper());
    }

    public void connect(NexusConfig config, boolean shouldSendPresence) {
        if (config.getEndpoints().isEmpty()) {
            NexusLogger.errorLog("No endpoints present");
        }
        for (String url : config.getEndpoints()) {
            NexusLogger.log("adding socket");
            this.sockets.add(new NexusSocket(url, config.getConnectionTimeout(), shouldSendPresence, new SocketListener()));
        }
        this.presenceInterval = TimeUnit.SECONDS.toMillis(config.getPresenceHeartbeatInterval());
        if (shouldSendPresence) {
            this.schedulePresence();
        }
    }

    public synchronized void disconnect() {
        if (!this.sockets.isEmpty()) {
            for (NexusSocket nexusSocket : this.sockets) {
                NexusLogger.log("disconnecting socket");
                nexusSocket.disconnect();
            }
            this.sockets.clear();
            NexusLogger.log("client disconnected");
        }
        this.backgroundHandler.removeCallbacksAndMessages(null);
    }

    public synchronized void fire(NexusEvent event) {
        this.cache.put((Object)event.getGuid(), (Object)true);
        String data = event.toJsonFormattedString();
        if (!data.isEmpty()) {
            for (NexusSocket nexusSocket : this.sockets) {
                nexusSocket.fire(data);
            }
        }
    }

    public synchronized void localUpdate(NexusEvent event) {
        for (NexusListener nexusListener : this.listeners) {
            nexusListener.notifyEvent(event);
        }
    }

    public synchronized boolean isConnected() {
        for (NexusSocket socket : this.sockets) {
            if (!socket.isConnected()) continue;
            return true;
        }
        return false;
    }

    public void addEventListener(NexusListener listener) {
        this.listeners.add(listener);
    }

    public void removeEventListener(NexusListener listener) {
        this.listeners.remove(listener);
    }

    public void setLoggingEnabled(boolean loggingEnabled) {
        NexusLogger.setLoggingEnabled(loggingEnabled);
    }

    public void setPresenceHeartbeatEnabled(boolean presenceHeartbeatEnabled) {
        this.backgroundHandler.removeCallbacksAndMessages(null);
        if (presenceHeartbeatEnabled) {
            this.schedulePresence();
        }
    }

    private void schedulePresence() {
        if (this.presenceInterval > 0L) {
            this.backgroundHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    NexusClient.this.fire(NexusEvent.UserPresence);
                    NexusClient.this.schedulePresence();
                }
            }, this.presenceInterval);
        }
    }

    private class SocketListener
    implements NexusListener {
        private SocketListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyEvent(NexusEvent event) {
            if (event != NexusEvent.UNKNOWN) {
                LruCache lruCache = NexusClient.this.cache;
                synchronized (lruCache) {
                    if (NexusClient.this.cache.get((Object)event.getGuid()) == null) {
                        NexusClient.this.cache.put((Object)event.getGuid(), (Object)true);
                        NexusLogger.log("notifying a listener");
                        for (NexusListener listener : NexusClient.this.listeners) {
                            listener.notifyEvent(event);
                        }
                    } else {
                        NexusLogger.log("dropping event, already in cache:" + event.toJsonFormattedString());
                    }
                }
            }
        }

        @Override
        public void onConnect() {
            NexusLogger.log("notifying listeners that a connection opened");
            for (NexusListener listener : NexusClient.this.listeners) {
                listener.onConnect();
            }
        }

        @Override
        public void onConnectFailed() {
            NexusLogger.log("notifying listeners that a connection failed to open");
            for (NexusListener listener : NexusClient.this.listeners) {
                listener.onConnectFailed();
            }
        }
    }
}

