/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.commons.utilities;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import java.util.UUID;

public class DeviceUtils {
    public static String generateDeviceId(Context context) {
        String uuid = DeviceUtils.getTelephonyDeviceId(context);
        if (TextUtils.isEmpty((CharSequence)uuid)) {
            String macAddress = DeviceUtils.getWifiMacAddress(context);
            String androidId = DeviceUtils.getAndroidId(context);
            if (!TextUtils.isEmpty((CharSequence)macAddress) && !TextUtils.isEmpty((CharSequence)androidId)) {
                uuid = new UUID(androidId.hashCode(), macAddress.hashCode()).toString();
            } else if (!TextUtils.isEmpty((CharSequence)androidId)) {
                uuid = androidId;
            } else if (!TextUtils.isEmpty((CharSequence)macAddress)) {
                uuid = macAddress;
            }
            if (TextUtils.isEmpty((CharSequence)uuid)) {
                uuid = UUID.randomUUID().toString();
            }
        }
        return uuid;
    }

    static String getTelephonyDeviceId(Context context) {
        String result = null;
        if (DeviceUtils.hasPermission(context, "android.permission.READ_PHONE_STATE")) {
            try {
                TelephonyManager telephonyService = (TelephonyManager)context.getSystemService("phone");
                result = telephonyService.getDeviceId();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result == null ? "" : result;
    }

    static String getWifiMacAddress(Context context) {
        WifiInfo wifiInfo;
        WifiManager wifiManager;
        String result = null;
        if (DeviceUtils.hasPermission(context, "android.permission.ACCESS_WIFI_STATE") && (wifiManager = (WifiManager)context.getSystemService("wifi")) != null && (wifiInfo = wifiManager.getConnectionInfo()) != null) {
            result = wifiInfo.getMacAddress();
        }
        return result == null ? "" : result;
    }

    static String getAndroidId(Context context) {
        String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        return androidId == null || androidId.equalsIgnoreCase("9774d56d682e549c") ? "" : androidId;
    }

    public static boolean hasPermission(Context context, String permissionType) {
        int res = context.checkCallingOrSelfPermission(permissionType);
        return res == 0;
    }

    public static String getAppVersion(Context context) {
        String version = "";
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            if (packageInfo.versionName != null) {
                version = packageInfo.versionName;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return version;
    }

    public static String getAppName(Context context) {
        String packageName = context.getPackageName();
        return packageName == null ? "" : packageName;
    }
}

