/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.retrofit.client;

import io.intercom.retrofit.client.Client;
import io.intercom.retrofit.client.Header;
import io.intercom.retrofit.client.Request;
import io.intercom.retrofit.client.Response;
import io.intercom.retrofit.mime.TypedByteArray;
import io.intercom.retrofit.mime.TypedOutput;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

public class ApacheClient
implements Client {
    private final HttpClient client;

    private static HttpClient createDefaultClient() {
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)15000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)20000);
        return new DefaultHttpClient((HttpParams)params);
    }

    public ApacheClient() {
        this(ApacheClient.createDefaultClient());
    }

    public ApacheClient(HttpClient client) {
        this.client = client;
    }

    @Override
    public Response execute(Request request) throws IOException {
        HttpUriRequest apacheRequest = ApacheClient.createRequest(request);
        HttpResponse apacheResponse = this.execute(this.client, apacheRequest);
        return ApacheClient.parseResponse(request.getUrl(), apacheResponse);
    }

    protected HttpResponse execute(HttpClient client, HttpUriRequest request) throws IOException {
        return client.execute(request);
    }

    static HttpUriRequest createRequest(Request request) {
        if (request.getBody() != null) {
            return new GenericEntityHttpRequest(request);
        }
        return new GenericHttpRequest(request);
    }

    static Response parseResponse(String url, HttpResponse response) throws IOException {
        StatusLine statusLine = response.getStatusLine();
        int status = statusLine.getStatusCode();
        String reason = statusLine.getReasonPhrase();
        ArrayList<Header> headers = new ArrayList<Header>();
        String contentType = "application/octet-stream";
        for (org.apache.http.Header header : response.getAllHeaders()) {
            String name = header.getName();
            String value = header.getValue();
            if ("Content-Type".equalsIgnoreCase(name)) {
                contentType = value;
            }
            headers.add(new Header(name, value));
        }
        TypedByteArray body = null;
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            byte[] bytes = EntityUtils.toByteArray((HttpEntity)entity);
            body = new TypedByteArray(contentType, bytes);
        }
        return new Response(url, status, reason, headers, body);
    }

    static class TypedOutputEntity
    extends AbstractHttpEntity {
        final TypedOutput typedOutput;

        TypedOutputEntity(TypedOutput typedOutput) {
            this.typedOutput = typedOutput;
            this.setContentType(typedOutput.mimeType());
        }

        public boolean isRepeatable() {
            return true;
        }

        public long getContentLength() {
            return this.typedOutput.length();
        }

        public InputStream getContent() throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.typedOutput.writeTo(out);
            return new ByteArrayInputStream(out.toByteArray());
        }

        public void writeTo(OutputStream out) throws IOException {
            this.typedOutput.writeTo(out);
        }

        public boolean isStreaming() {
            return false;
        }
    }

    private static class GenericEntityHttpRequest
    extends HttpEntityEnclosingRequestBase {
        private final String method;

        GenericEntityHttpRequest(Request request) {
            this.method = request.getMethod();
            this.setURI(URI.create(request.getUrl()));
            for (Header header : request.getHeaders()) {
                this.addHeader((org.apache.http.Header)new BasicHeader(header.getName(), header.getValue()));
            }
            this.setEntity((HttpEntity)new TypedOutputEntity(request.getBody()));
        }

        public String getMethod() {
            return this.method;
        }
    }

    private static class GenericHttpRequest
    extends HttpRequestBase {
        private final String method;

        public GenericHttpRequest(Request request) {
            this.method = request.getMethod();
            this.setURI(URI.create(request.getUrl()));
            for (Header header : request.getHeaders()) {
                this.addHeader((org.apache.http.Header)new BasicHeader(header.getName(), header.getValue()));
            }
        }

        public String getMethod() {
            return this.method;
        }
    }
}

