/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.transforms;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Shader;
import com.squareup.picasso.Transformation;

public class RoundTransform
implements Transformation {
    public Bitmap transform(Bitmap source) {
        int y;
        int size = Math.min(source.getWidth(), source.getHeight());
        int x = (source.getWidth() - size) / 2;
        Bitmap squaredBitmap = Bitmap.createBitmap((Bitmap)source, (int)x, (int)(y = (source.getHeight() - size) / 2), (int)size, (int)size);
        if (squaredBitmap != source) {
            source.recycle();
        }
        Bitmap.Config config = source.getConfig() != null ? source.getConfig() : Bitmap.Config.ARGB_8888;
        Bitmap bitmap = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)config);
        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint();
        BitmapShader shader = new BitmapShader(squaredBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        paint.setShader((Shader)shader);
        paint.setAntiAlias(true);
        float r = (float)size / 2.0f;
        canvas.drawCircle(r, r, r, paint);
        squaredBitmap.recycle();
        return bitmap;
    }

    public String key() {
        return "circle";
    }
}

