/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex;

import io.reactivex.CompletableObserver;
import io.reactivex.CompletableOnSubscribe;
import io.reactivex.CompletableSource;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.annotations.CheckReturnValue;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.c.i;
import io.reactivex.internal.c.m;
import io.reactivex.internal.d.a.a;
import io.reactivex.internal.d.a.b;
import io.reactivex.internal.d.a.c;
import io.reactivex.internal.d.a.d;
import io.reactivex.internal.d.a.e;
import io.reactivex.internal.d.a.f;
import io.reactivex.internal.d.a.g;
import io.reactivex.internal.d.a.j;
import io.reactivex.internal.d.a.k;
import io.reactivex.internal.d.a.l;
import io.reactivex.internal.d.a.n;
import io.reactivex.internal.d.a.o;
import io.reactivex.internal.d.a.p;
import io.reactivex.internal.functions.Functions;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public abstract class Completable
implements CompletableSource {
    @CheckReturnValue
    @NonNull
    public static Completable complete() {
        return RxJavaPlugins.onAssembly(e.a);
    }

    @CheckReturnValue
    @NonNull
    public static Completable create(CompletableOnSubscribe completableOnSubscribe) {
        io.reactivex.internal.functions.a.a(completableOnSubscribe, "source is null");
        return RxJavaPlugins.onAssembly(new b(completableOnSubscribe));
    }

    @CheckReturnValue
    @NonNull
    public static Completable defer(Callable<? extends CompletableSource> callable) {
        io.reactivex.internal.functions.a.a(callable, "completableSupplier");
        return RxJavaPlugins.onAssembly(new c(callable));
    }

    @CheckReturnValue
    @NonNull
    public static Completable error(Throwable throwable) {
        io.reactivex.internal.functions.a.a(throwable, "error is null");
        return RxJavaPlugins.onAssembly(new f(throwable));
    }

    @CheckReturnValue
    @NonNull
    public static Completable fromCallable(Callable<?> callable) {
        io.reactivex.internal.functions.a.a(callable, "callable is null");
        return RxJavaPlugins.onAssembly(new g(callable));
    }

    @CheckReturnValue
    @NonNull
    public static Completable merge(Iterable<? extends CompletableSource> iterable) {
        io.reactivex.internal.functions.a.a(iterable, "sources is null");
        return RxJavaPlugins.onAssembly(new io.reactivex.internal.d.a.i(iterable));
    }

    @CheckReturnValue
    @NonNull
    public static Completable timer(long l2, TimeUnit timeUnit, Scheduler scheduler) {
        io.reactivex.internal.functions.a.a(timeUnit, "unit is null");
        io.reactivex.internal.functions.a.a(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new o(l2, timeUnit, scheduler));
    }

    @CheckReturnValue
    @NonNull
    public final <T> Single<T> andThen(SingleSource<T> singleSource) {
        io.reactivex.internal.functions.a.a(singleSource, "next is null");
        return RxJavaPlugins.onAssembly(new io.reactivex.internal.d.f.c<T>(singleSource, this));
    }

    @CheckReturnValue
    public final Completable andThen(CompletableSource completableSource) {
        io.reactivex.internal.functions.a.a(completableSource, "next is null");
        return RxJavaPlugins.onAssembly(new a(this, completableSource));
    }

    @CheckReturnValue
    public final Completable delay(long l2, TimeUnit object, Scheduler scheduler) {
        TimeUnit timeUnit = object;
        boolean bl2 = false;
        object = scheduler;
        TimeUnit timeUnit2 = timeUnit;
        long l3 = l2;
        Completable completable = this;
        io.reactivex.internal.functions.a.a(timeUnit2, "unit is null");
        io.reactivex.internal.functions.a.a(object, "scheduler is null");
        return RxJavaPlugins.onAssembly(new d(completable, l3, timeUnit2, (Scheduler)object, false));
    }

    @CheckReturnValue
    public final Completable doOnComplete(Action action) {
        Action action2 = Functions.EMPTY_ACTION;
        return this.a(Functions.emptyConsumer(), Functions.emptyConsumer(), action, action2, action2, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    public final Completable doOnError(Consumer<? super Throwable> consumer) {
        Action action = Functions.EMPTY_ACTION;
        Action action2 = Functions.EMPTY_ACTION;
        return this.a(Functions.emptyConsumer(), consumer, action, action, action2, action2);
    }

    @CheckReturnValue
    @NonNull
    private Completable a(Consumer<? super Disposable> consumer, Consumer<? super Throwable> consumer2, Action action, Action action2, Action action3, Action action4) {
        io.reactivex.internal.functions.a.a(consumer, "onSubscribe is null");
        io.reactivex.internal.functions.a.a(consumer2, "onError is null");
        io.reactivex.internal.functions.a.a(action, "onComplete is null");
        io.reactivex.internal.functions.a.a(action2, "onTerminate is null");
        io.reactivex.internal.functions.a.a(action3, "onAfterTerminate is null");
        io.reactivex.internal.functions.a.a(action4, "onDispose is null");
        return RxJavaPlugins.onAssembly(new l(this, consumer, consumer2, action, action2, action3, action4));
    }

    @CheckReturnValue
    public final Completable doOnSubscribe(Consumer<? super Disposable> consumer) {
        Action action = Functions.EMPTY_ACTION;
        Action action2 = Functions.EMPTY_ACTION;
        return this.a(consumer, Functions.emptyConsumer(), action, action, action2, action2);
    }

    @CheckReturnValue
    @NonNull
    public final Completable observeOn(Scheduler scheduler) {
        io.reactivex.internal.functions.a.a(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new j(this, scheduler));
    }

    @CheckReturnValue
    public final Completable onErrorComplete() {
        Predicate predicate = Functions.alwaysTrue();
        Completable completable = this;
        io.reactivex.internal.functions.a.a(predicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new k(completable, predicate));
    }

    public final Disposable subscribe() {
        m m2 = new m();
        this.subscribe(m2);
        return m2;
    }

    @Override
    public final void subscribe(CompletableObserver object) {
        io.reactivex.internal.functions.a.a(object, "observer is null");
        try {
            object = RxJavaPlugins.a(this, (CompletableObserver)object);
            io.reactivex.internal.functions.a.a(object, "The RxJavaPlugins.onSubscribe hook returned a null CompletableObserver. Please check the handler provided to RxJavaPlugins.setOnCompletableSubscribe for invalid null returns. Further reading: https://github.com/ReactiveX/RxJava/wiki/Plugins");
            this.subscribeActual((CompletableObserver)object);
            return;
        }
        catch (NullPointerException nullPointerException) {
            object = nullPointerException;
            throw nullPointerException;
        }
        catch (Throwable throwable) {
            object = throwable;
            Exceptions.throwIfFatal(throwable);
            RxJavaPlugins.onError((Throwable)object);
            NullPointerException nullPointerException = new NullPointerException("Actually not, but can't pass out an exception otherwise...");
            nullPointerException.initCause((Throwable)object);
            throw nullPointerException;
        }
    }

    protected abstract void subscribeActual(CompletableObserver var1);

    @CheckReturnValue
    @NonNull
    public final Disposable subscribe(Action object, Consumer<? super Throwable> consumer) {
        io.reactivex.internal.functions.a.a(consumer, "onError is null");
        io.reactivex.internal.functions.a.a(object, "onComplete is null");
        object = new i(consumer, (Action)object);
        this.subscribe((CompletableObserver)object);
        return object;
    }

    @CheckReturnValue
    @NonNull
    public final Disposable subscribe(Action object) {
        io.reactivex.internal.functions.a.a(object, "onComplete is null");
        object = new i((Action)object);
        this.subscribe((CompletableObserver)object);
        return object;
    }

    @CheckReturnValue
    @NonNull
    public final Completable subscribeOn(Scheduler scheduler) {
        io.reactivex.internal.functions.a.a(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new io.reactivex.internal.d.a.m(this, scheduler));
    }

    @CheckReturnValue
    public final Completable timeout(long l2, TimeUnit object) {
        TimeUnit timeUnit = object;
        Completable completable = null;
        object = Schedulers.computation();
        TimeUnit timeUnit2 = timeUnit;
        long l3 = l2;
        completable = this;
        io.reactivex.internal.functions.a.a(timeUnit2, "unit is null");
        io.reactivex.internal.functions.a.a(object, "scheduler is null");
        return RxJavaPlugins.onAssembly(new n(completable, l3, timeUnit2, (Scheduler)object, null));
    }

    @CheckReturnValue
    @NonNull
    public final <T> Single<T> toSingle(Callable<? extends T> callable) {
        io.reactivex.internal.functions.a.a(callable, "completionValueSupplier is null");
        return RxJavaPlugins.onAssembly(new p<Object>(this, callable, null));
    }

    @CheckReturnValue
    @NonNull
    public final <T> Single<T> toSingleDefault(T t2) {
        io.reactivex.internal.functions.a.a(t2, "completionValue is null");
        return RxJavaPlugins.onAssembly(new p<T>(this, null, t2));
    }
}

